/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.motionpath;

import java.awt.geom.Point2D;
import javax.swing.table.AbstractTableModel;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.common.localization.Localizer;

public class MotionPathTableModel
extends AbstractTableModel {
    private static String[] myColumnNames = new String[]{Localizer.$((String)"time"), Localizer.$((String)"position")};
    private static Class[] myColumnClasses = new Class[]{Long.class, Double.class};
    private MotionPathEditor myController;

    public void setController(MotionPathEditor c) {
        this.myController = c;
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return myColumnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return myColumnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this.myController.isLocked();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.myController == null || this.myController.isLocked()) {
            return;
        }
        Point2D p = ((ControlPointEditor)this.myController.getChild(rowIndex)).getSelected();
        Point2D.Double nP = new Point2D.Double();
        if (columnIndex == 0) {
            ((Point2D)nP).setLocation(((Long)aValue).longValue(), p.getY());
        } else if (columnIndex == 1) {
            ((Point2D)nP).setLocation(p.getX(), (Double)aValue);
        }
        this.myController.movePoint(aValue, rowIndex, (long)((Point2D)nP).getX(), ((Point2D)nP).getY(), this.myController.getSharedHistory());
    }

    @Override
    public int getRowCount() {
        return this.myController == null ? 0 : this.myController.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.myController == null) {
            return null;
        }
        Point2D p = ((ControlPointEditor)this.myController.getChild(rowIndex)).getSelected();
        if (columnIndex == 0) {
            return (long)p.getX();
        }
        return p.getY();
    }
}

