/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.motionpath;

import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.robokind.api.animation.editor.ControlPointEditor;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.animation.editor.actions.ControlPointActions;
import org.robokind.api.common.localization.Localizer;
import org.rwshop.swing.animation.menus.UIMenuItem;

public class MotionPathTableContextMenu
implements MouseListener {
    private JTable myTable;
    private MotionPathEditor myController;

    public MotionPathTableContextMenu(JTable table) {
        this.myTable = table;
        this.myTable.addMouseListener(this);
    }

    public void setController(MotionPathEditor controller) {
        this.myController = controller;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.tryShowPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.tryShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.tryShowPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void tryShowPopup(MouseEvent e) {
        if (this.myController == null) {
            return;
        }
        if (e.getButton() != 3 || !e.isPopupTrigger()) {
            return;
        }
        int i = this.myTable.rowAtPoint(e.getPoint());
        if (i >= 0) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new UIMenuItem(Localizer.$((String)"remove"), (ActionListener)ControlPointActions.Remove((ControlPointEditor)((ControlPointEditor)this.myController.getChild(i)))));
            menu.show(this.myTable, e.getX(), e.getY());
        }
    }
}

