/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.history;

import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.editor.history.HistoryAction;
import org.robokind.api.animation.editor.history.HistoryListener;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.rwshop.swing.animation.table.history.HistoryTableModel;

public class HistoryTableHistoryStackListener
implements HistoryListener {
    private HistoryTableModel myModel;
    private JTable myTable;

    public HistoryTableHistoryStackListener(JTable table) {
        this.myTable = table;
    }

    public void setModel(HistoryTableModel model) {
        this.myModel = model;
    }

    public void eventAdded(HistoryStack stack, HistoryAction event, int oldLength) {
        if (this.myModel == null) {
            return;
        }
        if (oldLength >= stack.size()) {
            this.myModel.fireTableRowsDeleted(stack.size() - 1, oldLength - 1);
        }
        this.myModel.fireTableRowsInserted(stack.size() - 1, stack.getHistory().size() - 1);
        final int i = this.myTable.getRowCount() - 1;
        this.myTable.getSelectionModel().setSelectionInterval(i, i);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryTableHistoryStackListener.this.myTable.scrollRectToVisible(HistoryTableHistoryStackListener.this.myTable.getCellRect(i, HistoryTableHistoryStackListener.this.myTable.getColumnCount(), true));
            }
        });
    }

    public void timeSelected(HistoryStack stack, int time) {
        this.myTable.getSelectionModel().setSelectionInterval(time, time);
        final int i = time;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryTableHistoryStackListener.this.myTable.scrollRectToVisible(HistoryTableHistoryStackListener.this.myTable.getCellRect(i, HistoryTableHistoryStackListener.this.myTable.getColumnCount(), true));
            }
        });
    }
}

