/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.channel;

import javax.swing.table.AbstractTableModel;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.interpolation.InterpolatorFactory;

public class ChannelTableModel
extends AbstractTableModel {
    private static String[] myColumnNames = new String[]{"Enabled", "Name", "Type", "Locked", "Visible"};
    private static Class[] myColumnClasses = new Class[]{Boolean.class, String.class, InterpolatorFactory.class, Boolean.class, Boolean.class};
    private ChannelEditor myController;

    public void setController(ChannelEditor c) {
        this.myController = c;
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return myColumnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return myColumnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.myController == null) {
            return;
        }
        MotionPathEditor mpc = (MotionPathEditor)this.myController.getChild(rowIndex);
        switch (columnIndex) {
            case 0: {
                mpc.setState((Object)this, EditState.DISABLED, (Boolean)aValue == false, this.myController.getSharedHistory());
                break;
            }
            case 2: {
                mpc.setInterpolatorFactory((Object)this, (InterpolatorFactory)aValue, this.myController.getSharedHistory());
                break;
            }
            case 3: {
                mpc.setState((Object)this, EditState.LOCKED, ((Boolean)aValue).booleanValue(), this.myController.getSharedHistory());
                break;
            }
            case 4: {
                mpc.setState((Object)this, EditState.VISIBLE, ((Boolean)aValue).booleanValue(), this.myController.getSharedHistory());
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.myController == null) {
            return 0;
        }
        if (this.myController.getChildren() == null) {
            return 0;
        }
        return this.myController.getChildren().size();
    }

    @Override
    public int getColumnCount() {
        return myColumnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.myController == null) {
            return 0;
        }
        MotionPathEditor mpc = (MotionPathEditor)this.myController.getChild(rowIndex);
        if (mpc == null) {
            return 0;
        }
        switch (columnIndex) {
            case 0: {
                return !EditState.hasFlag((int)mpc.getStateFlags(), (EditState)EditState.DISABLED);
            }
            case 1: {
                return Localizer.$_((String)"motion.path.short") + rowIndex;
            }
            case 2: {
                return mpc.getInterpolatorFactory();
            }
            case 3: {
                return EditState.hasFlag((int)mpc.getStateFlags(), (EditState)EditState.LOCKED);
            }
            case 4: {
                return EditState.hasFlag((int)mpc.getStateFlags(), (EditState)EditState.VISIBLE);
            }
        }
        return 0;
    }
}

