/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.channel;

import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.animation.editor.MotionPathEditor;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.interpolation.InterpolatorDirectory;
import org.rwshop.swing.animation.InterpolatorRenderer;
import org.rwshop.swing.animation.table.channel.ChannelTableAnimationListener;
import org.rwshop.swing.animation.table.channel.ChannelTableChannelListener;
import org.rwshop.swing.animation.table.channel.ChannelTableContextMenu;
import org.rwshop.swing.animation.table.channel.ChannelTableLayoutListener;
import org.rwshop.swing.animation.table.channel.ChannelTableListener;
import org.rwshop.swing.animation.table.channel.ChannelTableModel;
import org.rwshop.swing.animation.table.channel.ChannelTableMotionPathListener;
import org.rwshop.swing.common.TableHelper;
import org.rwshop.swing.common.utils.SettingsRepository;

public class ChannelTable
extends JPanel {
    private ChannelTableModel myTableModel;
    private ChannelTableMotionPathListener myPathListener;
    private AnimationEditor myAnimationEditor;
    private ChannelEditor myChannelEditor;
    private ChannelTableChannelListener myChannelListener;
    private ChannelTableListener myTableListener;
    private ChannelTableLayoutListener myLayoutListener;
    private ChannelTableContextMenu myContextMenu;
    private ChannelTableAnimationListener myAnimationListener;
    private boolean myIsInitialized;
    private JScrollPane jScrollPane1;
    private JTable myTable;

    public ChannelTable() {
        this.initComponents();
        this.myTableModel = new ChannelTableModel();
        this.myPathListener = new ChannelTableMotionPathListener();
        this.myChannelListener = new ChannelTableChannelListener();
        this.myLayoutListener = new ChannelTableLayoutListener();
        this.myTableListener = new ChannelTableListener(this.myTable);
        this.myContextMenu = new ChannelTableContextMenu(this.myTable);
        this.myAnimationListener = new ChannelTableAnimationListener();
        this.myAnimationListener.init(this);
        this.myPathListener.init(this.myTableModel);
        this.myTable.setModel(this.myTableModel);
        this.myTable.getSelectionModel().addListSelectionListener(this.myTableListener);
        this.myTable.addComponentListener(this.myLayoutListener);
        this.myChannelListener.init(this.myPathListener, this.myTableModel);
        this.myChannelListener.setTable(this.myTable);
        this.myIsInitialized = false;
        this.jScrollPane1.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void setAnimationController(AnimationEditor ac) {
        if (this.myAnimationEditor == ac) {
            return;
        }
        this.myAnimationEditor = ac;
        this.myAnimationListener.cleanConsumer();
        if (ac == null || ac.getChildren().isEmpty()) {
            this.setController(null);
        } else {
            this.setController((ChannelEditor)ac.getSelected());
        }
        if (ac != null) {
            ac.addConsumer((EditorListener)this.myAnimationListener);
        }
    }

    public void setController(ChannelEditor controller) {
        if (this.myChannelEditor == controller) {
            return;
        }
        this.myPathListener.cleanConsumer();
        this.myChannelListener.cleanConsumer();
        this.myChannelEditor = controller;
        this.myPathListener.setController(this.myChannelEditor);
        this.myTableListener.setController(this.myChannelEditor);
        this.myTableModel.setController(this.myChannelEditor);
        this.myContextMenu.setController(this.myChannelEditor);
        if (!this.myIsInitialized) {
            this.setTableLayout();
            this.myIsInitialized = true;
        }
        if (this.myChannelEditor == null) {
            return;
        }
        for (MotionPathEditor mpc : this.myChannelEditor.getChildren()) {
            mpc.addConsumer((EditorListener)this.myPathListener);
        }
        this.myChannelEditor.addConsumer((EditorListener)this.myChannelListener);
    }

    private void setTableLayout() {
        Icon[] i = SettingsRepository.getAnimationTableIcons();
        TableColumn colEnabled = this.myTable.getColumn("Enabled");
        TableHelper.setColumnCheckBoxIcons((TableColumn)colEnabled, null, null, (String)Localizer.$((String)"enable.motion.path"));
        TableColumn colLocked = this.myTable.getColumn("Locked");
        TableHelper.setColumnCheckBoxIcons((TableColumn)colLocked, (Icon)i[0], (Icon)i[1], (String)Localizer.$((String)"lock.motion.path"));
        TableColumn colVis = this.myTable.getColumn("Visible");
        TableHelper.setColumnCheckBoxIcons((TableColumn)colVis, (Icon)i[2], (Icon)i[3], (String)Localizer.$((String)"show.motion.path"));
        TableColumn colType = this.myTable.getColumn("Type");
        InterpolatorRenderer typeRenderer = new InterpolatorRenderer();
        colType.setCellRenderer(typeRenderer);
        JComboBox<Object> cb = new JComboBox<Object>(InterpolatorDirectory.instance().buildFactoryList().toArray());
        cb.setRenderer(new InterpolatorRenderer());
        DefaultCellEditor dce = new DefaultCellEditor(cb);
        colType.setCellEditor(dce);
    }

    public void hideHeader() {
        this.myTable.setTableHeader(null);
    }

    public void setTableHeader(String name) {
        JTableHeader th = this.myTable.getTableHeader();
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn tc = new TableColumn();
        tcm.addColumn(tc);
        th.setColumnModel(tcm);
        tc.setHeaderValue(name);
        tc.setWidth(this.myTable.getWidth());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.myTable = new JTable();
        this.myTable.setSelectionMode(0);
        this.myTable.setShowVerticalLines(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.myTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 40, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 38, Short.MAX_VALUE));
    }
}

