/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.animation;

import java.awt.Color;
import javax.swing.table.AbstractTableModel;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;

public class AnimationTableModel
extends AbstractTableModel {
    private static String[] myColumnNames = new String[]{"Enabled", "Name", "Color", "Locked", "Visible"};
    private static Class[] myColumnClasses = new Class[]{Boolean.class, String.class, Color.class, Boolean.class, Boolean.class};
    private AnimationEditor myController;

    public void setController(AnimationEditor c) {
        this.myController = c;
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return myColumnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return myColumnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.myController == null) {
            return;
        }
        ChannelEditor cc = (ChannelEditor)this.myController.getChild(rowIndex);
        switch (columnIndex) {
            case 0: {
                cc.setState((Object)this, EditState.DISABLED, (Boolean)aValue == false, this.myController.getSharedHistory());
                break;
            }
            case 2: {
                cc.setPrimaryColor((Object)this, (Color)aValue);
                break;
            }
            case 3: {
                cc.setState((Object)this, EditState.LOCKED, ((Boolean)aValue).booleanValue(), this.myController.getSharedHistory());
                break;
            }
            case 4: {
                cc.setState((Object)this, EditState.VISIBLE, ((Boolean)aValue).booleanValue(), this.myController.getSharedHistory());
            }
        }
    }

    @Override
    public int getRowCount() {
        if (this.myController == null) {
            return 0;
        }
        if (this.myController.getChildren() == null) {
            return 0;
        }
        return this.myController.getChildren().size();
    }

    @Override
    public int getColumnCount() {
        return myColumnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.myController == null) {
            return 0;
        }
        ChannelEditor cc = (ChannelEditor)this.myController.getChild(rowIndex);
        if (cc == null) {
            return 0;
        }
        switch (columnIndex) {
            case 0: {
                return !EditState.hasFlag((int)cc.getStateFlags(), (EditState)EditState.DISABLED);
            }
            case 1: {
                return cc.getName();
            }
            case 2: {
                return cc.getPrimaryColor();
            }
            case 3: {
                return EditState.hasFlag((int)cc.getStateFlags(), (EditState)EditState.LOCKED);
            }
            case 4: {
                return EditState.hasFlag((int)cc.getStateFlags(), (EditState)EditState.VISIBLE);
            }
        }
        return 0;
    }
}

