/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.animation;

import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.actions.ChannelActions;
import org.robokind.api.common.localization.Localizer;
import org.rwshop.swing.animation.actions.UIAction;
import org.rwshop.swing.animation.menus.UIMenuItem;

public class AnimationTableContextMenu
implements MouseListener {
    private JTable myTable;
    private AnimationEditor myController;

    public AnimationTableContextMenu(JTable table) {
        this.myTable = table;
        this.myTable.addMouseListener(this);
        this.myTable.getParent().addMouseListener(this);
    }

    public void setController(AnimationEditor controller) {
        this.myController = controller;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.tryShowPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.tryShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.tryShowPopup(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void tryShowPopup(MouseEvent e) {
        if (this.myController == null) {
            return;
        }
        if (e.getButton() != 3 || !e.isPopupTrigger()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        int i = this.myTable.rowAtPoint(e.getPoint());
        if (i >= 0) {
            ChannelEditor controller = (ChannelEditor)this.myController.getChild(i);
            menu.add(new UIMenuItem(Localizer.$((String)"remove"), (ActionListener)ChannelActions.Remove((ChannelEditor)controller)));
            for (JComponent c : UIMenuItem.buildStateMenuItems((AbstractEditor)controller)) {
                menu.add(c);
            }
            menu.addSeparator();
        }
        menu.add(UIAction.AddChannelMenu(this.myController));
        menu.show(this.myTable, e.getX(), e.getY());
    }
}

