/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.animation;

import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditState;
import org.robokind.api.animation.editor.EditorListener;
import org.rwshop.swing.animation.table.animation.AnimationTableChannelListener;
import org.rwshop.swing.animation.table.animation.AnimationTableModel;

public class AnimationTableAnimationListener
extends EditorListener {
    JTable myTable;
    AnimationTableModel myTableModel;
    AnimationTableChannelListener myChannelListener;

    public void setTable(JTable table) {
        this.myTable = table;
    }

    public void setTableModel(AnimationTableModel model) {
        this.myTableModel = model;
    }

    public void setChannelListener(AnimationTableChannelListener listener) {
        this.myChannelListener = listener;
    }

    public void itemAdded(Object invoker, Object controller, int index) {
        if (this.myTableModel == null || this.myChannelListener == null) {
            return;
        }
        ((ChannelEditor)((AnimationEditor)controller).getChild(index)).addConsumer((EditorListener)this.myChannelListener);
        this.myTableModel.fireTableRowsInserted(index, index);
    }

    public void itemRemoved(Object invoker, Object controller, int index) {
        if (this.myTableModel == null || this.myChannelListener == null) {
            return;
        }
        this.myTableModel.fireTableRowsDeleted(index, index);
    }

    public void selectionChanged(Object invoker, Object controller, int oldIndex, int newIndex) {
        if (this.myTable == null) {
            return;
        }
        this.myTable.getSelectionModel().setSelectionInterval(newIndex, newIndex);
        final int i = newIndex;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AnimationTableAnimationListener.this.myTable.scrollRectToVisible(AnimationTableAnimationListener.this.myTable.getCellRect(i, AnimationTableAnimationListener.this.myTable.getColumnCount(), true));
            }
        });
    }

    public void structureChanged(Object invoker, Object controller) {
    }

    public void stateChanged(Object invoker, Object controller, EditState state, boolean value) {
    }

    public void itemMoved(Object invoker, Object controller, int oldIndex, int newIndex) {
    }
}

