/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.table.animation;

import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.editor.EditorListener;
import org.robokind.api.common.localization.Localizer;
import org.rwshop.swing.animation.table.animation.AnimationTableAnimationListener;
import org.rwshop.swing.animation.table.animation.AnimationTableChannelListener;
import org.rwshop.swing.animation.table.animation.AnimationTableContextMenu;
import org.rwshop.swing.animation.table.animation.AnimationTableLayoutListener;
import org.rwshop.swing.animation.table.animation.AnimationTableListener;
import org.rwshop.swing.animation.table.animation.AnimationTableModel;
import org.rwshop.swing.common.ColorEditor;
import org.rwshop.swing.common.ColorRenderer;
import org.rwshop.swing.common.TableHelper;
import org.rwshop.swing.common.utils.SettingsRepository;

public class AnimationTable
extends JPanel {
    private AnimationTableModel myTableModel;
    private AnimationTableChannelListener myChannelListener;
    private AnimationTableContextMenu myContextMenu;
    private AnimationTableAnimationListener myAnimationListener;
    private AnimationTableListener myTableListener;
    private AnimationTableLayoutListener myLayoutListener;
    private AnimationEditor myController;
    private JScrollPane jScrollPane1;
    private JTable myTable;

    public AnimationTable() {
        this.initComponents();
        this.myTableModel = new AnimationTableModel();
        this.myTable.setModel(this.myTableModel);
        this.myChannelListener = new AnimationTableChannelListener();
        this.myChannelListener.setTableModel(this.myTableModel);
        this.myAnimationListener = new AnimationTableAnimationListener();
        this.myAnimationListener.setChannelListener(this.myChannelListener);
        this.myAnimationListener.setTableModel(this.myTableModel);
        this.myAnimationListener.setTable(this.myTable);
        this.myTableListener = new AnimationTableListener();
        this.myTableListener.setTable(this.myTable);
        this.myTable.getSelectionModel().addListSelectionListener(this.myTableListener);
        this.myLayoutListener = new AnimationTableLayoutListener();
        this.myTable.addComponentListener(this.myLayoutListener);
        this.myContextMenu = new AnimationTableContextMenu(this.myTable);
        this.jScrollPane1.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void setController(AnimationEditor controller) {
        if (this.myController == controller) {
            return;
        }
        this.myController = controller;
        this.myChannelListener.cleanConsumer();
        this.myAnimationListener.cleanConsumer();
        this.myTableModel.setController(this.myController);
        this.myChannelListener.setController(this.myController);
        this.myTableListener.setController(this.myController);
        this.myContextMenu.setController(this.myController);
        if (this.myController != null) {
            this.myController.addConsumer((EditorListener)this.myAnimationListener);
            for (ChannelEditor cc : this.myController.getChildren()) {
                cc.addConsumer((EditorListener)this.myChannelListener);
            }
        }
        this.setTableLayout();
        this.myLayoutListener.setTableLayout(this.myTable);
    }

    private void setTableLayout() {
        Icon[] i = SettingsRepository.getAnimationTableIcons();
        TableColumn colEnabled = this.myTable.getColumn("Enabled");
        TableHelper.setColumnCheckBoxIcons((TableColumn)colEnabled, null, null, (String)Localizer.$((String)"enable.channel"));
        TableColumn colLocked = this.myTable.getColumn("Locked");
        TableHelper.setColumnCheckBoxIcons((TableColumn)colLocked, (Icon)i[0], (Icon)i[1], (String)Localizer.$((String)"lock.channel"));
        TableColumn colVis = this.myTable.getColumn("Visible");
        TableHelper.setColumnCheckBoxIcons((TableColumn)colVis, (Icon)i[2], (Icon)i[3], (String)Localizer.$((String)"show.channel"));
        TableColumn colColor = this.myTable.getColumn("Color");
        colColor.setCellRenderer((TableCellRenderer)new ColorRenderer());
        colColor.setCellEditor((TableCellEditor)new ColorEditor());
    }

    public void hideHeader() {
        this.myTable.setTableHeader(null);
    }

    public void setTableHeader(String name) {
        JTableHeader th = this.myTable.getTableHeader();
        DefaultTableColumnModel tcm = new DefaultTableColumnModel();
        TableColumn tc = new TableColumn();
        tcm.addColumn(tc);
        th.setColumnModel(tcm);
        tc.setHeaderValue(name);
        tc.setWidth(this.myTable.getWidth());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.myTable = new JTable();
        this.myTable.setModel(new DefaultTableModel(new Object[][]{{null}, {null}}, new String[]{"nulldf"}));
        this.myTable.setSelectionMode(0);
        this.myTable.setShowVerticalLines(false);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.myTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 47, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 41, Short.MAX_VALUE));
    }
}

