/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.menus;

import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.jflux.api.core.Source;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.actions.AnimationPlayerAction;
import org.robokind.api.animation.editor.actions.HistoryAction;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.common.localization.Localizer;
import org.robokind.api.common.utils.RKSource;
import org.rwshop.swing.animation.actions.FileAction;
import org.rwshop.swing.common.utils.SettingsRepository;

public class UIToolBar {
    public static JToolBar FileToolBar(RKSource<AnimationEditor> source, Source<? extends HistoryStack> histFact) {
        JToolBar bar = new JToolBar(Localizer.$((String)"file.menu"));
        Icon[] icons = SettingsRepository.getFileIcons();
        bar.add(UIToolBar.button(icons[0], Localizer.$((String)"new"), new FileAction.New(source, histFact)));
        bar.add(UIToolBar.button(icons[1], Localizer.$((String)"open"), new FileAction.Open(source, histFact, null)));
        bar.add(UIToolBar.button(icons[2], Localizer.$((String)"save"), new FileAction.Save(source, false)));
        return bar;
    }

    public static JToolBar HistoryToolBar(RKSource<? extends HistoryStack> source) {
        JToolBar bar = new JToolBar(Localizer.$((String)"history.menu"));
        Icon[] icons = SettingsRepository.getHistoryIcons();
        bar.add(UIToolBar.button(icons[0], Localizer.$((String)"undo"), (ActionListener)HistoryAction.Undo(source)));
        bar.add(UIToolBar.button(icons[1], Localizer.$((String)"undo"), (ActionListener)HistoryAction.Redo(source)));
        return bar;
    }

    public static JToolBar PlayerToolBar(RKSource<AnimationEditor> source) {
        JToolBar bar = new JToolBar(Localizer.$((String)"animation.player.menu"));
        Icon[] icons = SettingsRepository.getPlayerIcons();
        bar.add(UIToolBar.button(icons[0], Localizer.$((String)"play"), (ActionListener)new AnimationPlayerAction.Play(source)));
        bar.add(UIToolBar.button(icons[1], Localizer.$((String)"pause"), (ActionListener)new AnimationPlayerAction.Pause()));
        bar.add(UIToolBar.button(icons[2], Localizer.$((String)"stop"), (ActionListener)new AnimationPlayerAction.Stop()));
        return bar;
    }

    private static JButton button(Icon icon, String toolTip, ActionListener action) {
        JButton button = new JButton(icon);
        button.setToolTipText(toolTip);
        button.addActionListener(action);
        return button;
    }
}

