/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.joblist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationPlayer;
import org.robokind.api.common.utils.TimeUtils;
import org.rwshop.swing.animation.joblist.AnimationJobListPanel;

public class AnimationJobServiceListener
implements ServiceListener {
    private static final Logger theLogger = Logger.getLogger(AnimationJobServiceListener.class.getName());
    private AnimationJobListPanel myList;
    private BundleContext myContext;
    private Map<AnimationJob, ServiceReference> myReferenceMap;

    public AnimationJobServiceListener(BundleContext context, AnimationJobListPanel list) {
        this.myContext = context;
        this.myList = list;
        this.myReferenceMap = new HashMap<AnimationJob, ServiceReference>();
        if (this.myContext != null) {
            String filter = "(objectClass=" + AnimationJob.class.getName() + ")";
            try {
                this.myContext.addServiceListener((ServiceListener)this, filter);
            }
            catch (InvalidSyntaxException ex) {
                theLogger.log(Level.WARNING, "Could not register ServiceListener.  Invalid filter syntax.", ex);
            }
        }
        if (this.myList == null || this.myContext == null) {
            return;
        }
        try {
            ServiceReference[] refs = context.getServiceReferences(AnimationJob.class.getName(), null);
            if (refs == null || refs.length == 0) {
                return;
            }
            ArrayList<AnimationJob> jobs = new ArrayList<AnimationJob>(refs.length);
            for (ServiceReference se : refs) {
                AnimationJob job = (AnimationJob)context.getService(se);
                jobs.add(job);
                this.myReferenceMap.put(job, se);
            }
            this.myList.addAnimationJobs(jobs);
        }
        catch (InvalidSyntaxException ex) {
            theLogger.log(Level.SEVERE, "There was an error fetching service references.", ex);
        }
    }

    public void serviceChanged(ServiceEvent se) {
        switch (se.getType()) {
            case 1: {
                this.addService(se);
                break;
            }
            case 4: 
            case 8: {
                this.removeService(se);
            }
        }
    }

    private void addService(ServiceEvent se) {
        AnimationJob job = this.getService(se);
        if (job == null) {
            return;
        }
        this.myList.addAnimationJob(job);
        this.myReferenceMap.put(job, se.getServiceReference());
    }

    private void removeService(ServiceEvent se) {
        AnimationJob job = this.getService(se);
        this.myReferenceMap.remove(job);
        this.myList.removeAnimationJob(job);
    }

    private AnimationJob getService(ServiceEvent se) {
        ServiceReference ref = se.getServiceReference();
        if (ref == null || this.myContext == null) {
            return null;
        }
        Object obj = this.myContext.getService(ref);
        if (!(obj instanceof AnimationJob)) {
            return null;
        }
        AnimationJob job = (AnimationJob)obj;
        return job;
    }

    public void unregisterService(AnimationJob job) {
        if (job == null) {
            return;
        }
        job.stop(TimeUtils.now());
        AnimationPlayer source = job.getSource();
        if (source == null) {
            return;
        }
        source.removeAnimationJob(job);
    }
}

