/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.joblist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.robokind.api.animation.editor.ChannelEditor;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.animation.player.AnimationJobListener;
import org.robokind.api.common.config.VersionProperty;
import org.robokind.api.common.playable.PlayState;
import org.robokind.api.common.playable.Playable;
import org.robokind.api.common.playable.PlayableListener;
import org.robokind.api.common.utils.TimeUtils;
import org.rwshop.swing.animation.AnimationRenderer;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.timeline.layers.AnimationProgressLayer;
import org.rwshop.swing.common.ComponentHeaderPanel;
import org.rwshop.swing.common.PlayControlPanel;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.DefaultCoordinateScalar;
import org.rwshop.swing.common.utils.SettingsRepository;

public class AnimationJobPanel
extends JPanel
implements PlayableListener,
AnimationJobListener {
    public static final String ANIMATION_JOB_LABEL = "Animation Job";
    private AnimationJob myAnimationJob;
    private List<ActionListener> myCloseListeners;
    private AnimationProgressLayer myAnimationLayer;
    private CoordinateScalar myScalar;
    private long myStartTime;
    private long myAnimationLength;
    private JLabel jLabel1;
    private JPanel myAnimationBorder;
    private AnimationRenderer myAnimationRenderer;
    private JLabel myElapsedTimeLabel;
    private ComponentHeaderPanel myHeader;
    private JCheckBox myLoopCheckBox;
    private PlayControlPanel myPlayControl;
    private JLabel myTotalTimeLabel;

    public AnimationJobPanel() {
        this.initComponents();
        this.myStartTime = 0L;
        if (this.myHeader == null) {
            return;
        }
        this.myHeader.addCloseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationJobPanel.this.close();
            }
        });
    }

    public AnimationJob getAnimationJob() {
        return this.myAnimationJob;
    }

    public void setAnimationJob(AnimationJob job) {
        if (this.myAnimationJob != null) {
            this.myAnimationJob.removePlayableListener((PlayableListener)this);
            this.myAnimationJob.removeAnimationListener((AnimationJobListener)this);
        }
        this.myAnimationJob = job;
        this.myPlayControl.setPlayable((Playable)job);
        if (this.myAnimationJob == null) {
            return;
        }
        this.myAnimationJob.addPlayableListener((PlayableListener)this);
        this.myAnimationJob.addAnimationListener((AnimationJobListener)this);
        VersionProperty version = this.myAnimationJob.getAnimation().getVersion();
        this.myHeader.setTitle(version.getName(), version.getNumber());
        this.myHeader.setLabel(null);
        this.setHeaderState(this.myAnimationJob.getPlayState());
        Animation anim = this.myAnimationJob.getAnimation();
        HashMap<Integer, PathProperties> props = new HashMap<Integer, PathProperties>();
        for (Channel chan : anim.getChannels()) {
            int id = chan.getId();
            Color col = ChannelEditor.getChannelColor((Integer)id);
            PathProperties chanProps = new PathProperties(null, col, null);
            props.put(chan.getId(), chanProps);
        }
        this.myScalar = new DefaultCoordinateScalar();
        this.myAnimationRenderer.setScalar(this.myScalar);
        this.myAnimationRenderer.setAnimation(anim, props);
        this.myAnimationLength = this.myAnimationJob.getAnimationLength();
        String len = TimeUtils.timeString((long)this.myAnimationJob.getAnimationLength());
        this.myTotalTimeLabel.setText(len);
        this.myAnimationLayer = new AnimationProgressLayer(this.myScalar);
        this.myAnimationLayer.setPanel(this.myAnimationRenderer);
        this.myAnimationRenderer.addLayer(this.myAnimationLayer);
        this.myAnimationJob.addAnimationListener((AnimationJobListener)this.myAnimationLayer);
        this.updateTime(job.getElapsedPlayTime(TimeUtils.now()));
        boolean loop = this.myAnimationJob.getLoop();
        this.myLoopCheckBox.setSelected(loop);
    }

    private void updateTime(long time) {
        long elapsed = time;
        if (elapsed > this.myAnimationLength) {
            elapsed = this.myAnimationLength;
        }
        String elStr = TimeUtils.timeString((long)elapsed);
        this.myElapsedTimeLabel.setText(elStr);
    }

    public void addCloseListener(ActionListener listener) {
        if (this.myCloseListeners == null) {
            this.myCloseListeners = new ArrayList<ActionListener>();
        }
        this.myCloseListeners.add(listener);
    }

    public void removeCloseListener(ActionListener listener) {
        if (this.myCloseListeners == null) {
            return;
        }
        this.myCloseListeners.remove(listener);
    }

    protected void close() {
        if (this.myCloseListeners == null) {
            return;
        }
        ActionEvent event = new ActionEvent(this, 0, null);
        for (ActionListener listener : this.myCloseListeners) {
            listener.actionPerformed(event);
        }
    }

    private void initComponents() {
        this.myHeader = new ComponentHeaderPanel();
        this.myPlayControl = new PlayControlPanel();
        this.myElapsedTimeLabel = new JLabel();
        this.myTotalTimeLabel = new JLabel();
        this.myAnimationBorder = new JPanel();
        this.myAnimationRenderer = new AnimationRenderer();
        this.myLoopCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.myElapsedTimeLabel.setText("Elapsed Time");
        this.myTotalTimeLabel.setText("Total Time");
        this.myAnimationBorder.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout myAnimationRendererLayout = new GroupLayout(this.myAnimationRenderer);
        this.myAnimationRenderer.setLayout(myAnimationRendererLayout);
        myAnimationRendererLayout.setHorizontalGroup(myAnimationRendererLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 177, Short.MAX_VALUE));
        myAnimationRendererLayout.setVerticalGroup(myAnimationRendererLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        GroupLayout myAnimationBorderLayout = new GroupLayout(this.myAnimationBorder);
        this.myAnimationBorder.setLayout(myAnimationBorderLayout);
        myAnimationBorderLayout.setHorizontalGroup(myAnimationBorderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myAnimationRenderer, -1, -1, Short.MAX_VALUE));
        myAnimationBorderLayout.setVerticalGroup(myAnimationBorderLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myAnimationRenderer, -1, -1, Short.MAX_VALUE));
        this.myLoopCheckBox.setAlignmentY(0.0f);
        this.myLoopCheckBox.setBorder(null);
        this.myLoopCheckBox.setContentAreaFilled(false);
        this.myLoopCheckBox.setIconTextGap(0);
        this.myLoopCheckBox.setMaximumSize(new Dimension(20, 16));
        this.myLoopCheckBox.setMinimumSize(new Dimension(20, 16));
        this.myLoopCheckBox.setPreferredSize(new Dimension(20, 16));
        this.myLoopCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimationJobPanel.this.myLoopCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Loop");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.myHeader, GroupLayout.Alignment.TRAILING, -1, 285, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.myPlayControl, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.myLoopCheckBox, -2, 20, -2).addGap(3, 3, 3).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.myElapsedTimeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addComponent(this.myTotalTimeLabel)).addComponent(this.myAnimationBorder, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent((Component)this.myHeader, -2, 19, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.myPlayControl, -2, -1, -2).addComponent(this.myAnimationBorder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myElapsedTimeLabel).addComponent(this.myTotalTimeLabel).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.myLoopCheckBox, -2, -1, -2)).addComponent(this.jLabel1)))));
    }

    private void myLoopCheckBoxActionPerformed(ActionEvent evt) {
        boolean val = this.myLoopCheckBox.isSelected();
        this.myAnimationJob.setLoop(val);
    }

    public void playStateChanged(PlayState prev, PlayState state, long time) {
        this.setHeaderState(state);
        Color col = AnimationProgressLayer.PLAYING_COLOR;
        switch (state) {
            case PAUSED: {
                col = AnimationProgressLayer.PAUSED_COLOR;
                break;
            }
            case STOPPED: {
                col = AnimationProgressLayer.STOPPED_COLOR;
                break;
            }
            case COMPLETED: {
                col = AnimationProgressLayer.COMPLETED_COLOR;
            }
        }
        this.myAnimationLayer.setColor(col);
        this.myAnimationRenderer.repaint();
    }

    private void setHeaderState(PlayState state) {
        this.myHeader.setStatus(state.name());
        Icon[] icons = SettingsRepository.getPlayStatusIcons();
        Icon icon = null;
        switch (state) {
            case RUNNING: {
                icon = icons[0];
                break;
            }
            case PAUSED: {
                icon = icons[1];
                break;
            }
            case STOPPED: {
                icon = icons[2];
                break;
            }
            case PENDING: {
                icon = icons[2];
                break;
            }
            case COMPLETED: {
                icon = icons[3];
            }
        }
        this.myHeader.setIcon(icon);
    }

    public void animationAdvanced(long time) {
        this.updateTime(time);
    }

    public void animationStart(long start, Long end) {
        this.myStartTime = start;
    }
}

