/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.joblist;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.robokind.api.animation.player.AnimationJob;
import org.robokind.api.common.utils.TimeUtils;
import org.rwshop.swing.animation.joblist.AnimationJobPanel;
import org.rwshop.swing.animation.joblist.AnimationJobServiceListener;

public class AnimationJobListPanel
extends JPanel {
    private static final Border theBorder = new MatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY);
    private List<AnimationJobPanel> myAnimationJobPanels;
    private Map<AnimationJob, AnimationJobPanel> myAnimationJobMap;
    private AnimationJobServiceListener myServiceListener;
    private JPanel myAnimationJobsPanel;
    private JScrollPane myAnimationJobsScrollPane;

    public AnimationJobListPanel() {
        this.initComponents();
        this.myAnimationJobPanels = new ArrayList<AnimationJobPanel>();
        this.myAnimationJobMap = new HashMap<AnimationJob, AnimationJobPanel>();
        this.myAnimationJobsPanel.setLayout(new BoxLayout(this.myAnimationJobsPanel, 1));
        this.startListening();
    }

    public void addAnimationJob(AnimationJob job) {
        this.addJob(job);
        this.myAnimationJobsPanel.revalidate();
    }

    public void addAnimationJobs(List<AnimationJob> jobs) {
        for (AnimationJob job : jobs) {
            this.addJob(job);
        }
        this.myAnimationJobsPanel.revalidate();
    }

    public void startListening() {
        Bundle bundle = FrameworkUtil.getBundle(AnimationJob.class);
        if (bundle == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        this.startListening(context);
    }

    public void startListening(BundleContext context) {
        if (context == null || this.myServiceListener != null) {
            return;
        }
        this.myServiceListener = new AnimationJobServiceListener(context, this);
    }

    private void addJob(AnimationJob job) {
        if (job == null) {
            return;
        }
        if (this.myAnimationJobMap.containsKey(job)) {
            return;
        }
        AnimationJobPanel panel = new AnimationJobPanel();
        panel.setBorder(theBorder);
        panel.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationJobListPanel.this.closePanel(e);
            }
        });
        panel.setAnimationJob(job);
        this.myAnimationJobMap.put(job, panel);
        this.myAnimationJobPanels.add(panel);
        this.myAnimationJobsPanel.add(panel);
    }

    public void removeAnimationJob(AnimationJob job) {
        AnimationJobPanel panel = this.myAnimationJobMap.remove(job);
        if (panel == null) {
            return;
        }
        this.myAnimationJobPanels.remove(panel);
        this.myAnimationJobsPanel.remove(panel);
        this.myAnimationJobsPanel.revalidate();
        this.myAnimationJobsPanel.repaint();
    }

    private void closePanel(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == null || !(obj instanceof AnimationJobPanel)) {
            return;
        }
        AnimationJobPanel panel = (AnimationJobPanel)obj;
        if (panel == null) {
            return;
        }
        AnimationJob job = panel.getAnimationJob();
        if (job == null) {
            return;
        }
        job.stop(TimeUtils.now());
        this.removeAnimationJob(job);
        if (this.myServiceListener != null) {
            this.myServiceListener.unregisterService(job);
        }
    }

    private void initComponents() {
        this.myAnimationJobsScrollPane = new JScrollPane();
        this.myAnimationJobsPanel = new JPanel();
        this.myAnimationJobsScrollPane.setBorder(null);
        GroupLayout myAnimationJobsPanelLayout = new GroupLayout(this.myAnimationJobsPanel);
        this.myAnimationJobsPanel.setLayout(myAnimationJobsPanelLayout);
        myAnimationJobsPanelLayout.setHorizontalGroup(myAnimationJobsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 49, Short.MAX_VALUE));
        myAnimationJobsPanelLayout.setVerticalGroup(myAnimationJobsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 33, Short.MAX_VALUE));
        this.myAnimationJobsScrollPane.setViewportView(this.myAnimationJobsPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myAnimationJobsScrollPane, -1, 49, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myAnimationJobsScrollPane, -1, 33, Short.MAX_VALUE));
    }
}

