/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jflux.api.core.Adapter;
import org.osgi.framework.BundleContext;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.lifecycle.AnimationPlayerClientLifecycle;
import org.robokind.api.animation.messaging.RemoteAnimationPlayerClient;
import org.robokind.api.animation.protocol.AnimationEvent;
import org.robokind.api.animation.protocol.AnimationSignal;
import org.robokind.api.common.lifecycle.ManagedService;
import org.robokind.api.common.lifecycle.ServiceLifecycleProvider;
import org.robokind.api.common.lifecycle.utils.SimpleLifecycle;
import org.robokind.api.common.osgi.OSGiUtils;
import org.robokind.api.common.osgi.lifecycle.OSGiComponent;
import org.robokind.avrogen.animation.AnimationRecord;
import org.robokind.avrogen.animation.AnimationSignallingRecord;
import org.robokind.impl.animation.messaging.PortableAnimationEvent;
import org.robokind.impl.animation.messaging.PortableAnimationSignal;
import org.robokind.impl.messaging.lifecycle.JMSAvroAsyncReceiverLifecycle;
import org.robokind.impl.messaging.lifecycle.JMSAvroMessageSenderLifecycle;
import org.robokind.impl.messaging.utils.ConnectionManager;
import org.robokind.impl.messaging.utils.ConnectionUtils;

public class DemoPanel
extends JPanel {
    private AnimationPlayerClientLifecycle myLifecycle;
    private ManagedService myPlayerService;
    private ManagedService mySenderService;
    private ManagedService myConnectionService;
    private ManagedService mySessionService;
    private boolean myStartFlag;
    private JButton btnClear;
    private JButton btnDisconnect;
    private JButton btnSet;
    private JLabel jLabel1;
    private JTextField txtIP;

    public DemoPanel() {
        this.initComponents();
        this.myStartFlag = false;
        this.btnDisconnect.setEnabled(false);
        this.btnClear.setEnabled(false);
    }

    private void initComponents() {
        this.btnSet = new JButton();
        this.jLabel1 = new JLabel();
        this.txtIP = new JTextField();
        this.btnClear = new JButton();
        this.btnDisconnect = new JButton();
        this.btnSet.setText("Set Remote Player");
        this.btnSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoPanel.this.btnSetActionPerformed(evt);
            }
        });
        this.jLabel1.setText("IP Addr:");
        this.txtIP.setText("127.0.0.1");
        this.btnClear.setText("Clear Anims");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoPanel.this.btnClearActionPerformed(evt);
            }
        });
        this.btnDisconnect.setText("Disconnect");
        this.btnDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DemoPanel.this.btnDisconnectActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtIP, -1, 168, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(layout.createSequentialGroup().addComponent(this.btnClear).addGap(145, 145, 145))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnDisconnect, -1, -1, Short.MAX_VALUE).addComponent(this.btnSet, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.txtIP, -2, -1, -2).addComponent(this.btnSet)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnClear).addComponent(this.btnDisconnect)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnSetActionPerformed(ActionEvent evt) {
        this.startOnce();
        this.btnSet.setEnabled(!this.myStartFlag);
        this.btnDisconnect.setEnabled(this.myStartFlag);
        this.btnClear.setEnabled(this.myStartFlag);
    }

    private synchronized void startOnce() {
        if (this.myStartFlag) {
            return;
        }
        BundleContext context = OSGiUtils.getBundleContext(Animation.class);
        String ip = this.txtIP.getText();
        Connection con = ConnectionManager.createConnection((String)"admin", (String)"admin", (String)"client1", (String)"test", (String)("tcp://" + ip + ":5672"));
        try {
            con.start();
        }
        catch (JMSException ex) {
            JOptionPane.showMessageDialog(this, "Unable to connect to " + ip, "Connection Error", 0);
            return;
        }
        this.myConnectionService = new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)con, Connection.class));
        this.myConnectionService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteAnimConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationRequest", "animationRequest", 1, null});
        JMSAvroMessageSenderLifecycle senderLife = new JMSAvroMessageSenderLifecycle((Adapter)new PortableAnimationEvent.MessageRecordAdapter(), AnimationEvent.class, AnimationRecord.class, "remoteAnimSender", "remoteAnimConnection", "remoteAnimationRequest");
        this.registerEventFactory(context);
        this.mySenderService = new OSGiComponent(context, (ServiceLifecycleProvider)senderLife);
        this.mySenderService.start();
        ConnectionUtils.ensureSession((BundleContext)context, (String)"remoteSignalConnection", (Connection)con, null);
        ConnectionUtils.ensureDestinations((BundleContext)context, (Object[])new Object[]{"remoteAnimationSignal", "animationSignal", 1, null});
        JMSAvroAsyncReceiverLifecycle receiverLife = new JMSAvroAsyncReceiverLifecycle((Adapter)new PortableAnimationSignal.RecordMessageAdapter(), AnimationSignal.class, AnimationSignallingRecord.class, AnimationSignallingRecord.SCHEMA$, "remoteSignalReceiver", "remoteSignalConnection", "remoteAnimationSignal");
        OSGiComponent myReceiverService = new OSGiComponent(context, (ServiceLifecycleProvider)receiverLife);
        myReceiverService.start();
        this.myLifecycle = new AnimationPlayerClientLifecycle("remotePlayer", "remotePlayer", "remoteAnimSender", "remoteSignalReceiver", context);
        this.myPlayerService = new OSGiComponent(context, (ServiceLifecycleProvider)this.myLifecycle);
        this.myPlayerService.start();
        this.myStartFlag = true;
    }

    private void registerEventFactory(BundleContext context) {
        if (OSGiUtils.serviceExists((BundleContext)context, AnimationEvent.AnimationEventFactory.class, null).booleanValue()) {
            return;
        }
        new OSGiComponent(context, (ServiceLifecycleProvider)new SimpleLifecycle((Object)new PortableAnimationEvent.Factory(), AnimationEvent.AnimationEventFactory.class)).start();
    }

    private void btnClearActionPerformed(ActionEvent evt) {
        if (this.myLifecycle == null) {
            return;
        }
        RemoteAnimationPlayerClient client = (RemoteAnimationPlayerClient)this.myLifecycle.getService();
        if (client == null) {
            return;
        }
        client.clearAnimations();
    }

    private void btnDisconnectActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private synchronized void stop() {
        if (this.myPlayerService != null) {
            this.myPlayerService.dispose();
            this.myPlayerService = null;
        }
        if (this.mySenderService != null) {
            this.mySenderService.dispose();
            this.mySenderService = null;
        }
        if (this.myConnectionService != null) {
            this.myConnectionService.dispose();
            this.myConnectionService = null;
        }
        if (this.mySessionService != null) {
            this.mySessionService.dispose();
            this.mySessionService = null;
        }
        this.myStartFlag = false;
        this.btnSet.setEnabled(!this.myStartFlag);
        this.btnDisconnect.setEnabled(this.myStartFlag);
        this.btnClear.setEnabled(this.myStartFlag);
    }
}

