/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.util.ArrayList;
import java.util.List;
import org.rwshop.swing.animation.config.UIProperties;

public class UIStateProperties<T extends UIProperties> {
    private T myDefaultProperties;
    private List<T> myBefore;
    private List<T> myAfter;

    public UIStateProperties(T p, List<T> b, List<T> a) {
        this.myDefaultProperties = p;
        if (b == null) {
            b = new ArrayList<T>();
        }
        this.myBefore = b;
        if (a == null) {
            a = new ArrayList<T>();
        }
        this.myAfter = a;
    }

    public T getDefaultProperties() {
        return this.myDefaultProperties;
    }

    public void setDefaultProperties(T properties) {
        this.myDefaultProperties = properties;
    }

    public List<T> getBefore() {
        return this.myBefore;
    }

    public List<T> getAfter() {
        return this.myAfter;
    }

    public UIStateProperties<T> copy() {
        return new UIStateProperties<UIProperties>(this.myDefaultProperties == null ? null : ((UIProperties)this.myDefaultProperties).copy(), UIStateProperties.copyList(this.getBefore()), UIStateProperties.copyList(this.getAfter()));
    }

    public static <T extends UIProperties> UIStateProperties<T> combine(List<UIStateProperties<T>> a, UIProperties.PropertyHelper<T> combiner) {
        if (a == null || combiner == null) {
            return null;
        }
        ArrayList<T> props = new ArrayList<T>();
        ArrayList<List<T>> before = new ArrayList<List<T>>();
        ArrayList<List<T>> after = new ArrayList<List<T>>();
        for (UIStateProperties<T> p : a) {
            if (p == null) continue;
            props.add(p.getDefaultProperties());
            before.add(p.getBefore());
            after.add(p.getAfter());
        }
        return new UIStateProperties<T>(combiner.combine(props), UIStateProperties.copyLists(before), UIStateProperties.copyLists(after));
    }

    private static <T extends UIProperties> List<T> copyLists(List<List<T>> a) {
        if (a == null) {
            return null;
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (List<T> p : a) {
            if (p == null) continue;
            ret.addAll(p);
        }
        return UIStateProperties.copyList(ret);
    }

    private static <T extends UIProperties> List<T> copyList(List<T> props) {
        ArrayList<UIProperties> ret = new ArrayList<UIProperties>(props.size());
        for (UIProperties p : props) {
            ret.add(p.copy());
        }
        return ret;
    }
}

