/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.rwshop.swing.animation.config.StrokeProperties;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public abstract class UIProperties {
    protected StrokeProperties myStroke;
    protected Color myColor;
    protected Float myOpacity;

    public UIProperties(StrokeProperties stroke, Color c, Float a) {
        this.myStroke = stroke;
        this.myColor = c;
        this.myOpacity = a;
    }

    public StrokeProperties getStroke() {
        return this.myStroke;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color col) {
        this.myColor = col;
    }

    public Float getOpacity() {
        return this.myOpacity;
    }

    public abstract UIProperties copy();

    public abstract void paint(Graphics2D var1, List<Point2D> var2, CoordinateScalar var3);

    public static void setStroke(UIProperties props, Graphics2D g) {
        if (props != null && props.getStroke() != null) {
            g.setStroke(props.getStroke().getStroke());
        }
    }

    public static void setColor(UIProperties props, Graphics2D g) {
        Color c = props.getColor();
        if (c == null) {
            c = g.getColor();
        }
        if (props.getOpacity() != null) {
            float a = (float)c.getAlpha() / 255.0f;
            c = new Color(c.getColorSpace(), c.getComponents(null), a *= props.getOpacity().floatValue());
        }
        g.setColor(c);
    }

    public static abstract class PropertyHelper<T extends UIProperties> {
        public abstract String getPrefix();

        public abstract T read(Configuration var1);

        public abstract T combine(List<T> var1);

        public StrokeProperties readStrokeProperties(Configuration config) {
            Float width = config.getFloat("width", null);
            float[] dash = ConfigUtils.readFloats((Configuration)config, (String)"dash");
            Float phase = config.getFloat("dash.phase", null);
            return new StrokeProperties(width, dash, phase);
        }

        public abstract T createEmptyProperties();
    }
}

