/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.robokind.api.animation.editor.EditState;
import org.rwshop.swing.animation.config.PropertyReader;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.config.UIProperties;
import org.rwshop.swing.animation.config.UIStateProperties;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public abstract class UIConfigLayer<T extends UIProperties> {
    private static final EditState[] theDefaultStateOrder = new EditState[]{EditState.HOVER, EditState.SELECTED, EditState.DISABLED, EditState.LOCKED};
    protected PropertySet<T> myProperties;
    protected EditState[] myStateOrder;
    protected UIProperties.PropertyHelper<T> myPropertyHelper;

    public UIConfigLayer(Configuration config, String key, String def, UIProperties.PropertyHelper<T> helper) {
        if (helper == null) {
            throw new NullPointerException("PropertyHelper cannot be null.");
        }
        this.myPropertyHelper = helper;
        this.myProperties = PropertyReader.buildPropertiesCache(config, key, def, this.myPropertyHelper);
    }

    public UIConfigLayer(PropertySet<T> props, UIProperties.PropertyHelper<T> helper) {
        if (helper == null) {
            throw new NullPointerException("PropertyHelper cannot be null.");
        }
        this.myProperties = props;
        this.myPropertyHelper = helper;
    }

    public PropertySet<T> getProperties() {
        return this.myProperties;
    }

    public void setStateOrder(EditState ... states) {
        this.myStateOrder = states;
    }

    public void paint(Graphics g, List<Point2D> points, int flags, CoordinateScalar scalar, T optionalDrawProperties) {
        UIStateProperties<T> props = this.getProperties(flags);
        this.paint(g, points, props, scalar, optionalDrawProperties);
    }

    public void paint(Graphics g, List<Point2D> points, CoordinateScalar scalar, String settings, T optionalDrawProperties) {
        if (this.myProperties == null || !this.myProperties.hasSetting(settings)) {
            return;
        }
        UIStateProperties<T> props = this.myProperties.getProperties(settings);
        if (props == null && (props = this.myProperties.getDefaultProperties()) == null) {
            return;
        }
        this.paint(g, points, props, scalar, optionalDrawProperties);
    }

    private void paint(Graphics g, List<Point2D> points, UIStateProperties<T> props, CoordinateScalar scalar, T optional) {
        if (props == null || points == null || g == null || scalar == null) {
            return;
        }
        T def = props.getDefaultProperties();
        Object prop = def == null ? optional : (optional == null ? def : this.myPropertyHelper.combine(Arrays.asList(def, optional)));
        Graphics2D g2 = (Graphics2D)g;
        Stroke stroke = g2.getStroke();
        this.paintPoints(g2, points, props.getBefore(), scalar);
        if (prop != null) {
            ((UIProperties)prop).paint(g2, points, scalar);
        }
        this.paintPoints(g2, points, props.getAfter(), scalar);
        g2.setStroke(stroke);
    }

    public void paintPoints(Graphics2D g, List<Point2D> points, List<T> props, CoordinateScalar scalar) {
        if (props == null) {
            return;
        }
        for (UIProperties p : props) {
            p.paint(g, points, scalar);
        }
    }

    protected UIStateProperties<T> getProperties(int flags) {
        EditState[] order;
        ArrayList<String> settings = new ArrayList<String>();
        for (EditState s : order = this.myStateOrder == null ? theDefaultStateOrder : this.myStateOrder) {
            this.addStateString(flags, settings, s);
        }
        if (this.myProperties == null) {
            return null;
        }
        return this.myProperties.getProperties(settings);
    }

    protected void addStateString(int flags, List<String> settings, EditState state) {
        if (EditState.hasFlag((int)flags, (EditState)state)) {
            settings.add(state.toString().toLowerCase());
        }
    }
}

