/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.List;

public class StrokeProperties {
    private Float myWidth;
    private Float myDashPhase;
    private float[] myDash;

    public StrokeProperties(Float width, float[] dash, Float phase) {
        this.myWidth = width;
        this.myDash = dash;
        this.myDashPhase = phase;
    }

    public Float getWidth() {
        return this.myWidth;
    }

    public float[] getDash() {
        return this.myDash;
    }

    public Float getDashPhase() {
        return this.myDashPhase;
    }

    public Stroke getStroke() {
        float width;
        float f = width = this.getWidth() == null ? 1.0f : this.getWidth().floatValue();
        if (this.getDashPhase() == null || this.getDash() == null) {
            return new BasicStroke(width);
        }
        return new BasicStroke(this.getWidth().floatValue(), 0, 0, 10.0f, this.getDash(), this.getDashPhase().floatValue());
    }

    public StrokeProperties copy() {
        return new StrokeProperties(this.myWidth, this.myDash == null ? null : Arrays.copyOf(this.myDash, this.myDash.length), this.myDashPhase);
    }

    public static StrokeProperties combine(List<StrokeProperties> a) {
        if (a == null || a.isEmpty()) {
            return null;
        }
        StrokeProperties props = new StrokeProperties(Float.valueOf(1.0f), null, null);
        for (StrokeProperties p : a) {
            if (p == null) continue;
            if (p.getWidth() != null) {
                props.myWidth = p.getWidth();
            }
            if (p.getDash() != null) {
                props.myDash = p.getDash();
            }
            if (p.getDashPhase() == null) continue;
            props.myDashPhase = p.getDashPhase();
        }
        return props;
    }
}

