/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robokind.api.common.utils.Utils;
import org.rwshop.swing.animation.config.UIProperties;
import org.rwshop.swing.animation.config.UIStateProperties;

public class PropertySet<T extends UIProperties> {
    private UIStateProperties<T> myDefault;
    private UIProperties.PropertyHelper<T> myHelper;
    protected Map<String, UIStateProperties<T>> mySettings;
    private Map<String, UIStateProperties<T>> myCache;
    private Map<String, PropertySet> mySets;

    public PropertySet(UIStateProperties<T> props, UIProperties.PropertyHelper<T> pc) {
        if (props == null && pc != null) {
            T prop = pc.createEmptyProperties();
            props = new UIStateProperties<T>(prop, null, null);
        }
        this.myDefault = props;
        this.mySettings = new HashMap<String, UIStateProperties<T>>();
        this.myCache = new HashMap<String, UIStateProperties<T>>();
        this.myHelper = pc;
        this.mySets = new HashMap<String, PropertySet>();
    }

    public UIStateProperties<T> getDefaultProperties() {
        return this.myDefault;
    }

    public Color getPrimaryColor() {
        if (this.myDefault == null) {
            return null;
        }
        T props = this.myDefault.getDefaultProperties();
        if (props == null) {
            return null;
        }
        return ((UIProperties)props).getColor();
    }

    public void setPrimaryColor(Color col) {
        if (this.myDefault == null) {
            return;
        }
        T props = this.myDefault.getDefaultProperties();
        if (props == null) {
            return;
        }
        ((UIProperties)props).setColor(col);
        this.myCache.clear();
    }

    public boolean hasSetting(String setting) {
        return this.mySettings.containsKey(setting);
    }

    public UIStateProperties<T> getProperties(List<String> settings) {
        String key = Arrays.toString(settings.toArray());
        if (!this.myCache.containsKey(key)) {
            this.myCache.put(key, this.buildProperties(settings));
        }
        return this.myCache.get(key);
    }

    public UIStateProperties<T> getProperties(String ... settings) {
        String key = Arrays.toString(settings);
        if (!this.myCache.containsKey(key)) {
            this.myCache.put(key, this.buildProperties(Arrays.asList(settings)));
        }
        return this.myCache.get(key);
    }

    public void putChildProperties(String key, PropertySet ps) {
        this.mySets.put(key, ps);
    }

    public PropertySet getChildProperties(String key) {
        return this.mySets.get(key);
    }

    public void clearCache() {
        this.myCache.clear();
    }

    private UIStateProperties<T> buildProperties(List<String> settings) {
        ArrayList props = new ArrayList();
        props.add(this.myDefault.copy());
        for (String s : settings) {
            props.add(this.mySettings.get(s));
        }
        return UIStateProperties.combine(props, this.myHelper);
    }

    public PropertySet copy() {
        PropertySet<T> ps = new PropertySet<T>(this.myDefault.copy(), this.myHelper);
        for (Map.Entry<String, UIStateProperties<T>> e : this.mySettings.entrySet()) {
            ps.mySettings.put(e.getKey(), e.getValue().copy());
        }
        boolean addSelf = false;
        String selfKey = null;
        for (Map.Entry<String, PropertySet> e : this.mySets.entrySet()) {
            if (e.getValue() == this) {
                addSelf = true;
                selfKey = e.getKey();
                continue;
            }
            ps.mySets.put(e.getKey(), e.getValue().copy());
        }
        if (addSelf) {
            ps.mySets.put(selfKey, ps);
        }
        return ps;
    }

    public static PropertySet merge(PropertySet a, PropertySet b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        UIStateProperties sp = a.myDefault;
        UIProperties.PropertyHelper ph = a.myHelper;
        if (sp == null) {
            sp = b.myDefault;
            ph = b.myHelper;
        }
        PropertySet ps = new PropertySet(sp, ph);
        Utils.mergeMaps(ps.mySettings, (Map[])new Map[]{a.mySettings, b.mySettings});
        Utils.mergeMaps(ps.mySets, (Map[])new Map[]{a.mySets});
        for (Map.Entry<String, PropertySet> e : b.mySets.entrySet()) {
            PropertySet pb = e.getValue();
            PropertySet pa = ps.mySets.get(e.getKey());
            String k = e.getKey();
            if (ps.mySets.containsKey(k)) {
                if (pa == a && pb == b) {
                    ps.mySets.put(k, ps);
                    continue;
                }
                if (pa == a) {
                    ps.mySets.put(k, PropertySet.merge(ps, pb));
                    continue;
                }
                if (pb == b) {
                    ps.mySets.put(k, PropertySet.merge(pa, ps));
                    continue;
                }
                ps.mySets.put(k, PropertySet.merge(pa, pb));
                continue;
            }
            ps.mySets.put(k, pb);
        }
        for (Map.Entry<String, PropertySet> e : ps.mySets.entrySet()) {
            PropertySet p = e.getValue();
            if (p != a && p != b) continue;
            ps.mySets.put(e.getKey(), ps);
        }
        return ps;
    }
}

