/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.config.PointProperties;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.config.UIProperties;
import org.rwshop.swing.animation.config.UIStateProperties;
import org.rwshop.swing.common.utils.UIConfigHelper;

public class PropertyReader {
    public static PropertySet getAnimationProperties() {
        return PropertyReader.getAnimationProperties(null, "logicalid", null);
    }

    public static PropertySet getAnimationProperties(String defaultPathKey, String channelPrefix, String pointsKey) {
        PropertySet ps = new PropertySet(null, null);
        Configuration config = UIConfigHelper.getDisplayConfig();
        PropertySet controlPoints = null;
        if (pointsKey != null) {
            PropertyReader.getPointProperties(pointsKey);
            ps.putChildProperties("controlpoint", controlPoints);
        }
        int i = 0;
        while (!config.subset(channelPrefix + i).isEmpty()) {
            String key = channelPrefix + i + ".channel";
            String cKey = "logicalid" + i + ".channel";
            PropertySet<PathProperties> p = PropertyReader.getPathProperties(key, defaultPathKey);
            if (pointsKey != null) {
                p.putChildProperties("controlpoint", controlPoints);
            }
            ps.putChildProperties(cKey, p);
            ++i;
        }
        PropertySet<PathProperties> p = PropertyReader.getPathProperties(defaultPathKey, defaultPathKey);
        p.setPrimaryColor(Color.red);
        if (pointsKey != null) {
            p.putChildProperties("controlpoint", controlPoints);
        }
        ps.putChildProperties("default", p);
        return ps;
    }

    public static PropertySet<PathProperties> getPathProperties(String key, String defaultKey) {
        return PropertyReader.buildPropertiesCache(UIConfigHelper.getDisplayConfig(), key, defaultKey, PathProperties.Helper);
    }

    public static PropertySet<PointProperties> getPointProperties(String key) {
        return PropertyReader.buildPropertiesCache(UIConfigHelper.getDisplayConfig(), key, null, PointProperties.Helper);
    }

    public static <T extends UIProperties> PropertySet<T> buildPropertiesCache(Configuration config, String key, String def, UIProperties.PropertyHelper<T> helper) {
        Configuration keyConfig = config.subset(key);
        UIStateProperties<T> p = PropertyReader.readStateProperties(keyConfig, helper);
        PropertySet<T> props = new PropertySet<T>(p, helper);
        String statesKey = keyConfig.getString("states", null);
        Configuration statesConfig = null;
        if (statesKey == null) {
            statesConfig = keyConfig.subset("states");
            if (statesConfig.isEmpty() && def != null) {
                statesConfig = config.subset(def + ".states");
            }
        } else {
            statesConfig = config.subset(statesKey);
        }
        PropertyReader.loadSettings(props, statesConfig, helper);
        return props;
    }

    private static <T extends UIProperties> void loadSettings(PropertySet<T> props, Configuration c, UIProperties.PropertyHelper<T> helper) {
        ArrayList<String> keys = new ArrayList<String>();
        Iterator it = c.getKeys();
        while (it.hasNext()) {
            String k = ((String)it.next()).split("[.]")[0];
            if (k == null || k.isEmpty() || keys.contains(k)) continue;
            keys.add(k);
        }
        PropertyReader.loadSettings(props, c, keys, helper);
    }

    private static <T extends UIProperties> void loadSettings(PropertySet<T> props, Configuration config, List<String> keys, UIProperties.PropertyHelper<T> helper) {
        for (String s : keys) {
            UIStateProperties<T> sp = PropertyReader.readStateProperties(config.subset(s), helper);
            props.mySettings.put(s, sp);
        }
    }

    public static <T extends UIProperties> UIStateProperties<T> readStateProperties(Configuration config, UIProperties.PropertyHelper<T> helper) {
        T path = helper.read(config);
        List<T> before = PropertyReader.readLayers(config.subset("before"), helper);
        List<T> after = PropertyReader.readLayers(config.subset("after"), helper);
        return new UIStateProperties<T>(path, before, after);
    }

    private static <T extends UIProperties> List<T> readLayers(Configuration config, UIProperties.PropertyHelper<T> helper) {
        ArrayList<T> properties = new ArrayList<T>();
        String pre = helper.getPrefix();
        Configuration pathConfig = config.subset(pre);
        if (!pathConfig.isEmpty()) {
            properties.add(helper.read(config.subset(pre)));
            return properties;
        }
        int i = 1;
        Configuration c = config.subset("layer" + i + "." + pre);
        while (!c.isEmpty()) {
            properties.add(helper.read(config.subset("layer" + i + "." + pre)));
            c = config.subset("layer" + ++i + "." + pre);
        }
        return properties;
    }
}

