/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.config.StrokeProperties;
import org.rwshop.swing.animation.config.UIConfigLayer;
import org.rwshop.swing.animation.config.UIProperties;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.utils.UIHelpers;

public class PointProperties
extends UIProperties {
    public static final PointHelper Helper = new PointHelper();
    private Integer myWidth;
    private Integer myHeight;
    private String myStyle;

    public PointProperties(Integer width, Integer height, StrokeProperties stroke, Color c, Float a, String style) {
        super(stroke, c, a);
        this.myWidth = width;
        this.myHeight = height;
        this.myStyle = style;
    }

    public Integer getHeight() {
        return this.myHeight;
    }

    public Integer getWidth() {
        return this.myWidth;
    }

    public String getStyle() {
        return this.myStyle;
    }

    @Override
    public UIProperties copy() {
        return new PointProperties(this.getWidth(), this.getHeight(), this.myStroke.copy(), this.myColor, this.myOpacity, this.myStyle);
    }

    @Override
    public void paint(Graphics2D g, List<Point2D> points, CoordinateScalar s) {
        int h;
        UIProperties.setStroke(this, g);
        UIProperties.setColor(this, g);
        int w = this.myWidth == null ? 4 : this.myWidth;
        int n = h = this.myHeight == null ? 4 : this.myHeight;
        if (this.myStyle != null && this.myStyle.equals("FILL")) {
            for (Point2D p : points) {
                int x = (int)s.scaleX(p) - w / 2;
                int y = (int)s.scaleY(p) - h / 2;
                g.fillOval(x, y, w, h);
            }
        } else {
            for (Point2D p : points) {
                int x = (int)s.scaleX(p) - w / 2;
                int y = (int)s.scaleY(p) - h / 2;
                g.drawOval(x, y, w, h);
            }
        }
        UIHelpers.drawLines((Graphics)g, points, (CoordinateScalar)s);
    }

    public static class PointConfigRenderer
    extends UIConfigLayer<PointProperties> {
        public PointConfigRenderer(Configuration config, String key) {
            super(config, key, null, Helper);
        }

        public PointConfigRenderer(PropertySet ps) {
            super(ps, Helper);
        }
    }

    public static class PointHelper
    extends UIProperties.PropertyHelper<PointProperties> {
        @Override
        public String getPrefix() {
            return "point";
        }

        @Override
        public PointProperties read(Configuration config) {
            StrokeProperties props = this.readStrokeProperties(config.subset("stroke"));
            Color col = ConfigUtils.readColor((Configuration)config, (String)"color");
            Float opacity = config.getFloat("opacity", null);
            Integer width = config.getInteger("width", null);
            Integer height = config.getInteger("height", null);
            String style = config.getString("style", null);
            return new PointProperties(width, height, props, col, opacity, style);
        }

        @Override
        public PointProperties combine(List<PointProperties> a) {
            if (a == null) {
                return null;
            }
            ArrayList<StrokeProperties> strokes = new ArrayList<StrokeProperties>();
            Color c = null;
            Float alpha = Float.valueOf(1.0f);
            Integer w = null;
            Integer h = null;
            String style = null;
            for (PointProperties p : a) {
                if (p == null) continue;
                strokes.add(p.getStroke());
                if (p.getColor() != null) {
                    c = p.getColor();
                }
                if (p.getOpacity() != null) {
                    alpha = Float.valueOf(alpha.floatValue() * p.getOpacity().floatValue());
                }
                if (p.getWidth() != null) {
                    w = p.getWidth();
                }
                if (p.getHeight() != null) {
                    h = p.getHeight();
                }
                if (p.getStyle() == null) continue;
                style = p.getStyle();
            }
            return new PointProperties(w, h, StrokeProperties.combine(strokes), c, alpha, style);
        }

        @Override
        public PointProperties createEmptyProperties() {
            StrokeProperties props = new StrokeProperties(Float.valueOf(1.0f), null, null);
            return new PointProperties(10, 10, props, Color.BLACK, Float.valueOf(1.0f), null);
        }
    }
}

