/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.config;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.robokind.extern.utils.apache_commons_configuration.ConfigUtils;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.config.StrokeProperties;
import org.rwshop.swing.animation.config.UIConfigLayer;
import org.rwshop.swing.animation.config.UIProperties;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.utils.UIHelpers;

public class PathProperties
extends UIProperties {
    public static final PathHelper Helper = new PathHelper();

    public PathProperties(StrokeProperties stroke, Color c, Float a) {
        super(stroke, c, a);
    }

    @Override
    public UIProperties copy() {
        StrokeProperties stroke = this.myStroke == null ? null : this.myStroke.copy();
        return new PathProperties(stroke, this.myColor, this.myOpacity);
    }

    @Override
    public void paint(Graphics2D g, List<Point2D> points, CoordinateScalar s) {
        UIProperties.setStroke(this, g);
        UIProperties.setColor(this, g);
        UIHelpers.drawLines((Graphics)g, points, (CoordinateScalar)s);
    }

    public static class PathConfigRenderer
    extends UIConfigLayer<PathProperties> {
        public PathConfigRenderer(Configuration config, String key) {
            super(config, key, "default.channel", Helper);
        }

        public PathConfigRenderer(PropertySet ps) {
            super(ps, Helper);
        }
    }

    public static class PathHelper
    extends UIProperties.PropertyHelper<PathProperties> {
        @Override
        public String getPrefix() {
            return "path";
        }

        @Override
        public PathProperties read(Configuration config) {
            StrokeProperties props = this.readStrokeProperties(config.subset("stroke"));
            Color col = ConfigUtils.readColor((Configuration)config, (String)"color");
            Float opacity = config.getFloat("opacity", null);
            return new PathProperties(props, col, opacity);
        }

        @Override
        public PathProperties combine(List<PathProperties> a) {
            if (a == null) {
                return null;
            }
            ArrayList<StrokeProperties> strokes = new ArrayList<StrokeProperties>();
            Color c = null;
            Float alpha = Float.valueOf(1.0f);
            for (PathProperties p : a) {
                if (p == null) continue;
                StrokeProperties stroke = p.getStroke();
                if (p != null) {
                    strokes.add(stroke);
                }
                if (p.getColor() != null) {
                    c = p.getColor();
                }
                if (p.getOpacity() == null) continue;
                alpha = Float.valueOf(alpha.floatValue() * p.getOpacity().floatValue());
            }
            return new PathProperties(StrokeProperties.combine(strokes), c, alpha);
        }

        @Override
        public PathProperties createEmptyProperties() {
            StrokeProperties props = new StrokeProperties(Float.valueOf(1.0f), null, null);
            return new PathProperties(props, Color.BLACK, Float.valueOf(1.0f));
        }
    }
}

