/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import org.jflux.api.core.Source;
import org.robokind.api.animation.editor.AbstractEditor;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.actions.EditorAction;
import org.robokind.api.animation.factory.ChannelFactory;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.animation.utils.ChannelNode;
import org.robokind.api.animation.utils.ChannelsParameter;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.common.localization.Localizer;
import org.rwshop.swing.animation.menus.UIMenuItem;
import org.rwshop.swing.animation.timeline.AnimationTimelinePanel;
import org.rwshop.swing.common.scaling.CoordinateScalar;

public abstract class UIAction {
    public static JMenu AddChannelMenu(AnimationEditor controller) {
        JMenu menu = new JMenu(Localizer.$((String)"add.channel"));
        ChannelsParameterSource paramSource = AnimationUtils.getChannelsParameterSource();
        if (paramSource == null) {
            return menu;
        }
        ChannelNode root = paramSource.getChannelTree();
        if (root != null) {
            menu.add(UIAction.channelNodeMenu(controller, root));
        }
        for (ChannelsParameter channel : paramSource.getChannelParameters()) {
            String label = channel.getChannelName();
            JMenuItem item = null;
            if (controller.containsLogicalId(channel.getChannelID())) {
                item = new JMenuItem(label);
                item.setEnabled(false);
            } else {
                ChannelFactory fact = new ChannelFactory(channel.getChannelID(), channel.getChannelName());
                item = new UIMenuItem(label, (ActionListener)new EditorAction.AddChild((AbstractEditor)controller, (Source)fact, true));
            }
            menu.add(item);
        }
        return menu;
    }

    public static JMenu channelNodeMenu(AnimationEditor editor, ChannelNode node) {
        JMenu menu = new JMenu(node.getName());
        ActionListener all = UIAction.buildAddRecChildChannels(editor, node);
        if (all == null) {
            return menu;
        }
        menu.add(new UIMenuItem("Add All: " + node.getName(), all));
        List nodes = node.getChildGroups();
        if (nodes == null) {
            nodes = Collections.EMPTY_LIST;
        }
        for (ChannelNode n : nodes) {
            JMenu childMenu = UIAction.channelNodeMenu(editor, n);
            menu.add(childMenu);
        }
        List chans = node.getChannels();
        if (chans == null) {
            chans = Collections.EMPTY_LIST;
        }
        for (ChannelNode.ChannelDefinition def : chans) {
            String label = def.getName();
            JMenuItem item = null;
            if (editor.containsLogicalId(def.getId())) {
                item = new JMenuItem(label);
                item.setEnabled(false);
            } else {
                ChannelFactory fact = new ChannelFactory(def.getId(), def.getName());
                item = new UIMenuItem(label, (ActionListener)new EditorAction.AddChild((AbstractEditor)editor, (Source)fact, true));
            }
            menu.add(item);
        }
        return menu;
    }

    public static ActionListener buildAddRecChildChannels(AnimationEditor editor, ChannelNode node) {
        List list = node.getChildGroups();
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        int size = list.size();
        ArrayList<ActionListener> actions = new ArrayList<ActionListener>(size + 1);
        for (ChannelNode n : list) {
            ActionListener l = UIAction.buildAddRecChildChannels(editor, n);
            if (l == null) continue;
            actions.add(l);
        }
        ActionListener l = UIAction.buildAddChildChannels(editor, node);
        if (l != null) {
            actions.add(l);
        }
        if (actions.isEmpty()) {
            return null;
        }
        return new CompoundAction(actions);
    }

    public static ActionListener buildAddChildChannels(AnimationEditor editor, ChannelNode node) {
        List l = node.getChannels();
        if (l == null || l.isEmpty()) {
            return null;
        }
        ArrayList<ActionListener> actions = new ArrayList<ActionListener>(l.size());
        for (ChannelNode.ChannelDefinition def : l) {
            if (editor.containsLogicalId(def.getId())) continue;
            actions.add((ActionListener)new EditorAction.AddChild((AbstractEditor)editor, (Source)new ChannelFactory(def.getId(), def.getName()), true));
        }
        if (actions.isEmpty()) {
            return null;
        }
        return new CompoundAction(actions);
    }

    public static class CompoundAction
    implements ActionListener {
        private List<ActionListener> myActions;

        public CompoundAction(List<ActionListener> listeners) {
            if (listeners == null) {
                throw new NullPointerException();
            }
            this.myActions = listeners;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ActionListener l : this.myActions) {
                l.actionPerformed(e);
            }
        }
    }

    public static class Zoom
    implements ActionListener {
        private CoordinateScalar myScalar;
        private double myAmount;
        private AnimationTimelinePanel myPanel;

        public Zoom(CoordinateScalar s, AnimationTimelinePanel c, double amount) {
            this.myScalar = s;
            this.myAmount = amount;
            this.myPanel = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myScalar.setScaleX(this.myScalar.getScaleX() * this.myAmount);
            int minAnim = this.myPanel.getMinWidth();
            int minPnl = this.myPanel.getMinimumSize().width;
            JScrollPane scrollPane = (JScrollPane)this.myPanel.getParent().getParent();
            int minScrl = scrollPane.getWidth() + 1;
            int size = Math.max(minAnim, minPnl);
            size = Math.max(size, minScrl);
            this.myPanel.setPreferredSize(new Dimension(size, this.myPanel.getPreferredSize().height));
            this.myPanel.revalidate();
            scrollPane.repaint();
        }
    }
}

