/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Set;
import javax.swing.JFileChooser;
import org.apache.commons.configuration.ConfigurationException;
import org.jflux.api.core.Source;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.animation.utils.AnimationUtils;
import org.robokind.api.animation.utils.ChannelsParameterSource;
import org.robokind.api.animation.xml.AnimationXML;
import org.robokind.api.common.utils.RKSource;
import org.rwshop.swing.common.utils.MessageAlerter;

public class FileAction {

    public static class Save
    implements ActionListener {
        private RKSource<AnimationEditor> mySource;
        private boolean myOpenDialog;

        public Save(RKSource<AnimationEditor> source, boolean dialog) {
            this.mySource = source;
            this.myOpenDialog = dialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimationEditor editor = (AnimationEditor)this.mySource.getValue();
            String path = editor.getFilePath();
            if (this.myOpenDialog || path == null || path.isEmpty()) {
                JFileChooser fileChooser = new JFileChooser();
                int i = fileChooser.showSaveDialog(null);
                if (i == 1) {
                    return;
                }
                path = fileChooser.getSelectedFile().getPath();
            }
            boolean error = true;
            String innerError = "";
            Throwable innerException = null;
            try {
                AnimationXML.saveAnimation((String)path, (Animation)editor.getAnimation(), (ChannelsParameterSource)AnimationUtils.getChannelsParameterSource(), (Set)editor.collectSynchronizedPointGroups());
                error = false;
                editor.setFilePath(path);
            }
            catch (ConfigurationException ex) {
                innerError = "There was an error writing the Animation to XML";
                innerException = ex;
            }
            catch (Throwable ex) {
                innerException = ex;
            }
            if (error) {
                MessageAlerter.Error((String)"Unable to save Animation", (String)innerError, (Throwable)innerException);
            } else {
                MessageAlerter.Ok((String)"File Saved", (String)"The Animation was successfully saved.");
            }
        }
    }

    public static class Open
    implements ActionListener {
        private RKSource<AnimationEditor> mySource;
        private Source<? extends HistoryStack> myHistoryFactory;
        private String myPath;

        public Open(RKSource<AnimationEditor> source, Source<? extends HistoryStack> histFact, String path) {
            this.mySource = source;
            this.myPath = path;
            this.myHistoryFactory = histFact;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String path = this.myPath;
            if (path == null || path.isEmpty()) {
                JFileChooser fileChooser = new JFileChooser();
                int i = fileChooser.showOpenDialog(null);
                if (i == 1) {
                    this.mySource.set(null);
                    return;
                }
                path = fileChooser.getSelectedFile().getPath();
            }
            AnimationEditor temp = (AnimationEditor)this.mySource.getValue();
            this.mySource.set(null);
            try {
                Animation anim = AnimationXML.loadAnimation((String)path);
                anim.setVersion(new File(path).getName(), anim.getVersion().getNumber());
                AnimationEditor editor = new AnimationEditor(anim, path, (HistoryStack)this.myHistoryFactory.getValue());
                this.mySource.set((Object)editor);
            }
            catch (Throwable t) {
                this.mySource.set((Object)temp);
                MessageAlerter.Error((String)"Unable to load Animation", null, (Throwable)t);
                return;
            }
        }
    }

    public static class New
    implements ActionListener {
        private RKSource<AnimationEditor> mySource;
        private Source<? extends HistoryStack> myHistoryFactory;

        public New(RKSource<AnimationEditor> source, Source<? extends HistoryStack> histFact) {
            this.mySource = source;
            this.myHistoryFactory = histFact;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Animation anim = new Animation();
            AnimationEditor controller = new AnimationEditor(anim, null, (HistoryStack)this.myHistoryFactory.getValue());
            this.mySource.set((Object)controller);
        }
    }
}

