/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.robokind.api.animation.MotionPath;
import org.robokind.api.interpolation.InterpolatorFactory;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.scaling.DefaultCoordinateScalar;
import org.rwshop.swing.common.utils.UIHelpers;

public class InterpolatorRenderer
extends JPanel
implements ListCellRenderer,
TableCellRenderer {
    private CoordinateScalar myScalar;
    private List<Point2D> myPoints = new ArrayList<Point2D>();
    private MotionPath myMotionPath;
    private Map<InterpolatorFactory, MotionPath> myPathMap;
    private int myLastWidth;

    public InterpolatorRenderer() {
        this.myPoints.add(new Point2D.Double(150.0, 0.15));
        this.myPoints.add(new Point2D.Double(383.0, 0.8));
        this.myPoints.add(new Point2D.Double(617.0, 0.15));
        this.myPoints.add(new Point2D.Double(850.0, 0.8));
        this.myPathMap = new HashMap<InterpolatorFactory, MotionPath>();
        this.myScalar = new DefaultCoordinateScalar(0.13, 16.0, true);
        this.setSize(this.getWidth(), 16);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 16));
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int width = list.getWidth();
        int height = 30;
        if (index == -1) {
            height = 16;
            width -= 12;
        }
        this.myScalar.setScaleY((double)height);
        this.setSize(width, height);
        this.setPreferredSize(new Dimension(width, height));
        return this.renderComponent(list, value, isSelected, width, list.getSelectionBackground(), list.getSelectionForeground());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int width = table.getColumnModel().getColumn(column).getWidth();
        int height = table.getRowHeight(row);
        this.myScalar.setScaleY((double)(height - 1));
        return this.renderComponent(table, value, isSelected, width, table.getSelectionBackground(), table.getSelectionForeground());
    }

    private Component renderComponent(JComponent component, Object value, boolean isSelected, int width, Color selBack, Color selFore) {
        if (this.myLastWidth != width) {
            this.myLastWidth = width;
            double w = this.myLastWidth;
            double sX = w / 1000.0;
            this.myScalar.setScaleX(sX);
        }
        if (isSelected) {
            this.setBackground(selBack);
            this.setForeground(selFore);
        } else {
            this.setBackground(component.getBackground());
            this.setForeground(component.getForeground());
        }
        if (!(value instanceof InterpolatorFactory)) {
            return this;
        }
        this.myMotionPath = this.getPath((InterpolatorFactory)value);
        return this;
    }

    private MotionPath getPath(InterpolatorFactory factory) {
        if (!this.myPathMap.containsKey(factory)) {
            MotionPath path = new MotionPath(factory);
            path.addPoints(this.myPoints);
            this.myPathMap.put(factory, path);
            return path;
        }
        return this.myPathMap.get(factory);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.getForeground());
        UIHelpers.drawLinePath((Graphics)g, (List)this.myMotionPath.getInterpolatedPoints(), (CoordinateScalar)this.myScalar);
    }
}

