/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.Channel;
import org.rwshop.swing.animation.PathRenderer;
import org.rwshop.swing.animation.config.PathProperties;
import org.rwshop.swing.animation.config.PropertySet;
import org.rwshop.swing.animation.config.UIStateProperties;
import org.rwshop.swing.common.DrawableLayer;
import org.rwshop.swing.common.scaling.CoordinateScalar;
import org.rwshop.swing.common.utils.SettingsRepository;

public class AnimationRenderer
extends JPanel
implements ComponentListener {
    private CoordinateScalar myScalar;
    private List<DrawableLayer> myLayers;
    private double myLength;

    public AnimationRenderer() {
        this.initComponents();
        this.myLayers = new ArrayList<DrawableLayer>();
        this.addComponentListener(this);
    }

    public void setScalar(CoordinateScalar scalar) {
        this.myScalar = scalar;
    }

    public CoordinateScalar getScaler() {
        return this.myScalar;
    }

    public void addLayer(DrawableLayer layer) {
        this.myLayers.add(layer);
    }

    public void setAnimation(Animation animation, Map<Integer, PathProperties> properties) {
        if (this.myScalar == null) {
            return;
        }
        this.myLength = 0.0;
        for (Channel channel : animation.getChannels()) {
            int id = channel.getId();
            PathProperties prop = properties.get(id);
            List points = channel.getInterpolatedPoints(-1L, -1L);
            if (points.isEmpty()) continue;
            Point2D end = (Point2D)points.get(points.size() - 1);
            double time = end.getX();
            if (time > this.myLength) {
                this.myLength = time;
            }
            if (prop == null) {
                prop = new PathProperties(null, Color.red, null);
            }
            UIStateProperties<PathProperties> uisp = new UIStateProperties<PathProperties>(prop, null, null);
            PropertySet<PathProperties> ps = new PropertySet<PathProperties>(uisp, PathProperties.Helper);
            this.myLayers.add(new PathRenderer(points, ps, this.myScalar));
        }
        this.setSize();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.setSize();
        super.paintComponent(g);
        if (SettingsRepository.getAntiAliasingRenderer()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.myLayers != null) {
            for (DrawableLayer layer : this.myLayers) {
                layer.paint(g);
            }
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 84, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 32, Short.MAX_VALUE));
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setSize();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setSize();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void setSize() {
        if (this.myScalar == null) {
            return;
        }
        if (this.myLength <= 0.0) {
            return;
        }
        double w = this.getWidth();
        double scale = w / this.myLength;
        this.myScalar.setScaleX(scale);
        this.myScalar.setScaleY((double)this.getHeight());
    }
}

