/*
 * Decompiled with CFR 0.152.
 */
package org.rwshop.swing.animation;

import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.jflux.api.core.Source;
import org.robokind.api.animation.Animation;
import org.robokind.api.animation.editor.AnimationEditor;
import org.robokind.api.animation.editor.history.HistoryFactoryImpl;
import org.robokind.api.animation.editor.history.HistoryStack;
import org.robokind.api.animation.xml.AnimationXML;
import org.rwshop.swing.animation.AnimationEditorPanel;
import org.rwshop.swing.animation.menus.MenuBarManager;
import org.rwshop.swing.animation.osgi.Activator;
import org.rwshop.swing.common.scaling.ScalingManager;
import org.rwshop.swing.common.utils.MessageAlerter;

public class AnimationFrame
extends JFrame {
    private AnimationEditorPanel animationEditor1;
    private JMenuBar myMenuBard;

    public AnimationFrame() {
        this.initComponents();
    }

    public void init(ScalingManager scalingManager) {
        this.animationEditor1.init(scalingManager);
        AnimationEditor editor = this.loadAnimation(null);
        this.animationEditor1.set(editor);
        MenuBarManager menu = new MenuBarManager(this.myMenuBard, this.animationEditor1, (Source<HistoryStack>)new HistoryFactoryImpl());
        menu.setupMenu();
    }

    private AnimationEditor loadAnimation(String path) {
        Animation anim;
        path = "./resources/anim.xml";
        if (path == null || path.isEmpty()) {
            JFileChooser fileChooser = new JFileChooser();
            int i = fileChooser.showSaveDialog(null);
            path = i == 1 ? null : fileChooser.getSelectedFile().getPath();
        }
        if (path != null) {
            try {
                anim = AnimationXML.loadAnimation((String)path);
            }
            catch (Throwable t) {
                MessageAlerter.Error((String)"animation.load.error", null, (Throwable)t);
                anim = new Animation();
            }
        } else {
            anim = new Animation();
        }
        AnimationEditor editor = new AnimationEditor(anim, path, new HistoryStack());
        return editor;
    }

    private void initComponents() {
        this.animationEditor1 = new AnimationEditorPanel();
        this.myMenuBard = new JMenuBar();
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.myMenuBard);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.animationEditor1, -1, 846, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.animationEditor1, GroupLayout.Alignment.TRAILING, -1, 470, Short.MAX_VALUE));
        this.pack();
    }

    public static void main(String[] args) {
        try {
            new Activator().start(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

