/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.plugin.overthere;

import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.common.INodeEntry;
import com.dtolabs.rundeck.core.dispatcher.DataContextUtils;
import com.dtolabs.rundeck.core.execution.ExecutionContext;
import com.dtolabs.rundeck.core.execution.service.NodeExecutor;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResult;
import com.dtolabs.rundeck.core.execution.service.NodeExecutorResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepFailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepFailureReason;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.plugins.configuration.PropertyUtil;
import com.dtolabs.rundeck.core.plugins.configuration.StringRenderingConstants;
import com.dtolabs.rundeck.core.storage.ResourceMeta;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.dtolabs.rundeck.plugins.util.PropertyBuilder;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.winrm.WinRmRuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.util.ConsoleOverthereExecutionOutputHandler;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.StorageException;

@Plugin(name="overthere-winrm", service="NodeExecutor")
public class OTWinRMNodeExecutor
implements NodeExecutor,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "overthere-winrm";
    public static final int DEFAULT_WINRM_CONNECTION_TIMEOUT = 15000;
    public static final boolean DEFAULT_WINRM_CONNECTION_ENCRYPTED = true;
    public static final String WINRM_PASSWORD_OPTION = "winrm-password-option";
    public static final String WINRM_PASSWORD_STORAGE_PATH = "winrm-password-storage-path";
    public static final String DEFAULT_WINRM_PASSWORD_OPTION = "winrmPassword";
    public static final int DEFAULT_HTTPS_PORT = 5986;
    public static final int DEFAULT_HTTP_PORT = 5985;
    public static final String WINRM_CONNECTION_TIMEOUT_PROPERTY = "winrm-connection-timeout";
    public static final String WINRM_USER = "winrm-user";
    public static final String WINRM_PORT = "winrm-port";
    public static final String WINRM_AUTH_TYPE = "winrm-auth-type";
    public static final String WINRM_CERT_TRUST = "winrm-cert-trust";
    public static final String WINRM_HOSTNAME_TRUST = "winrm-hostname-trust";
    public static final String WINRM_PROTOCOL = "winrm-protocol";
    public static final String AUTH_TYPE_KERBEROS = "kerberos";
    public static final String AUTH_TYPE_BASIC = "basic";
    public static final String WINRM_PROTOCOL_HTTPS = "https";
    public static final String WINRM_PROTOCOL_HTTP = "http";
    public static final String WINRM_SPN_ADD_PORT = "winrm-spn-add-port";
    public static final String WINRM_SPN_USE_HTTP = "winrm-spn-use-http";
    public static final String WINRM_LOCALE = "winrm-locale";
    public static final String WINRM_TIMEOUT = "winrm-timeout";
    public static final String WINRM_IS_DOMAIN_MEMBER = "winrm-is-domain-member";
    public static final String WINRM_DOMAIN = "winrm-domain";
    public static final Boolean DEFAULT_IS_DOMAIN_MEMBER = false;
    public static final String HOSTNAME_TRUST_BROWSER_COMPATIBLE = "browser-compatible";
    public static final String HOSTNAME_TRUST_STRICT = "strict";
    public static final String HOSTNAME_TRUST_ALL = "all";
    public static final String CERT_TRUST_DEFAULT = "default";
    public static final String CERT_TRUST_ALL = "all";
    public static final String CERT_TRUST_SELF_SIGNED = "self-signed";
    public static final String DEFAULT_AUTH_TYPE = "kerberos";
    public static final String DEBUG_KERBEROS_AUTH = "winrm-kerberos-debug";
    public static final Boolean DEFAULT_DEBUG_KERBEROS_AUTH = false;
    public static final String DEFAULT_WINRM_PROTOCOL = "https";
    public static final String KERBEROS_CACHE = "kerberos-cache";
    public static final Boolean DEFAULT_KERBEROS_CACHE = false;
    public static final WinrmHttpsCertificateTrustStrategy DEFAULT_CERT_TRUST = WinrmHttpsCertificateTrustStrategy.STRICT;
    public static final WinrmHttpsHostnameVerificationStrategy DEFAULT_HOSTNAME_VERIFY = WinrmHttpsHostnameVerificationStrategy.BROWSER_COMPATIBLE;
    public static final String CONFIG_AUTHENTICATION = "authentication";
    public static final String CONFIG_PROTOCOL = "protocol";
    public static final String CONFIG_CERT_TRUST = "certTrust";
    public static final String CONFIG_HOSTNAME_VERIFY = "hostnameVerify";
    public static final String CONFIG_SPN_ADD_PORT = "spnAddPort";
    public static final String CONFIG_SPN_USE_HTTP = "spnUseHttp";
    public static final String CONFIG_LOCALE = "locale";
    public static final String CONFIG_WINRM_TIMEOUT = "winrmTimeout";
    private static final String CONFIG_TIMEOUT = "timeout";
    private static final String CONFIG_PASSWORD_STORAGE_PATH = "passwordStoragePath";
    private Framework framework;
    private static final String PROJ_PROP_PREFIX = "project.";
    private static final String FWK_PROP_PREFIX = "framework.";
    static final Description DESC = DescriptionBuilder.builder().name("overthere-winrm").title("WinRM").description("Executes a command on a remote windows node via WinRM.").property(PropertyUtil.select((String)"authentication", (String)"Authentication", (String)"Authentication mechanism to use", (boolean)true, (String)"kerberos", Arrays.asList("kerberos", "basic"))).property(PropertyUtil.select((String)"protocol", (String)"WinRM Protocol", (String)"HTTP Protocol", (boolean)true, (String)"https", Arrays.asList("http", "https"))).property(PropertyUtil.select((String)"certTrust", (String)"HTTPS Certificate Trust", (String)"Strategy for certificate trust (Kerberos only)", (boolean)false, (String)DEFAULT_CERT_TRUST.toString(), Arrays.asList("all", "self-signed", "default"))).property(PropertyUtil.select((String)"hostnameVerify", (String)"HTTPS Hostname Verification", (String)"Strategy for hostname verification (Kerberos only)", (boolean)false, (String)DEFAULT_HOSTNAME_VERIFY.toString(), Arrays.asList("all", "browser-compatible", "strict"))).property(PropertyUtil.bool((String)"spnAddPort", (String)"SPN adds Port", (String)"If true, add the port (e.g. 5985) to the SPN used for Kerberos Authentication.", (boolean)true, (String)"false")).property(PropertyUtil.bool((String)"spnUseHttp", (String)"SPN uses HTTP", (String)"If true, use HTTP instead of WSMAN for the SPN used for Kerberos Authentication.", (boolean)true, (String)"false")).property(PropertyUtil.string((String)"locale", (String)"WinRM Locale", (String)"Locale, default: en-us.", (boolean)false, null)).property(PropertyUtil.string((String)"winrmTimeout", (String)"WinRM Timeout", (String)"WinRM protocol Timeout, in XML Schema Duration format. (Default: PT60.000S) \n\nsee: <http://www.w3.org/TR/xmlschema-2/#isoformats>", (boolean)false, null)).property(PropertyUtil.longProp((String)"timeout", (String)"Connection Timeout", (String)"Connection timeout, in milliseconds. Default: 15000 (15 seconds).", (boolean)false, null)).property(PropertyBuilder.builder().string("passwordStoragePath").title("Password Storage").description("Key Storage Path for winrm Password.\n\nThe path can contain property references like `${node.name}`.").renderingOption("selectionAccessor", (Object)StringRenderingConstants.SelectionAccessor.STORAGE_PATH).renderingOption("storage-path-root", (Object)"keys").renderingOption("storage-file-meta-filter", (Object)"Rundeck-data-type=password").build()).mapping("authentication", "project.winrm-auth-type").mapping("protocol", "project.winrm-protocol").mapping("certTrust", "project.winrm-cert-trust").mapping("hostnameVerify", "project.winrm-hostname-trust").mapping("spnAddPort", "project.winrm-spn-add-port").mapping("spnUseHttp", "project.winrm-spn-use-http").mapping("locale", "project.winrm-locale").mapping("winrmTimeout", "project.winrm-timeout").mapping("timeout", "project.winrm-connection-timeout").mapping("passwordStoragePath", "project.winrm-password-storage-path").build();

    public OTWinRMNodeExecutor(Framework framework) {
        this.framework = framework;
    }

    public Description getDescription() {
        return DESC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeExecutorResult executeCommand(ExecutionContext context, String[] command, INodeEntry node) {
        boolean status;
        ConnectionOptions options = null;
        String logprompt = "[overthere-winrm:" + node.extractHostname() + "] ";
        if (null == context.getExecutionListener()) {
            System.out.println(logprompt + " Bad plugin context!  NULL ExecutionListener");
        }
        context.getExecutionListener().log(3, logprompt + this.buildCommandLine(command));
        try {
            options = this.willUseConnectionOptions(new ConnectionOptionsBuilder(context, node, this.framework).build());
        }
        catch (ConfigurationException e) {
            context.getExecutionListener().log(0, logprompt + e.getMessage());
            return NodeExecutorResultImpl.createFailure((FailureReason)StepFailureReason.ConfigurationFailure, (String)e.getMessage(), (INodeEntry)node);
        }
        context.getExecutionListener().log(3, logprompt + options);
        int result = -1;
        try {
            OverthereConnection connection = new CifsConnectionBuilder("cifs", options, (AddressPortMapper)new DefaultAddressPortMapper()).connect();
            try {
                result = connection.execute((OverthereExecutionOutputHandler)ConsoleOverthereExecutionOutputHandler.sysoutHandler(), (OverthereExecutionOutputHandler)ConsoleOverthereExecutionOutputHandler.syserrHandler(), this.buildCommandLine(command));
            }
            finally {
                connection.close();
            }
        }
        catch (WinRmRuntimeIOException re) {
            String message = null;
            if (context.getLoglevel() > 2) {
                re.printStackTrace(System.err);
                message = re.getMessage();
            } else {
                message = "WinRM Error: " + re.getMessage();
            }
            context.getExecutionListener().log(0, logprompt + "failed: " + message);
            return NodeExecutorResultImpl.createFailure((FailureReason)Reason.WinRMProtocolError, (String)message, (Exception)((Object)re), (INodeEntry)node, (int)-1);
        }
        catch (RuntimeIOException re) {
            String message = null;
            if (context.getLoglevel() > 2) {
                re.printStackTrace(System.err);
                message = re.getMessage();
            } else {
                message = "runtime exception: " + (Object)((Object)re);
            }
            context.getExecutionListener().log(0, logprompt + "failed: " + message);
            return NodeExecutorResultImpl.createFailure((FailureReason)StepFailureReason.IOFailure, (String)message, (Exception)((Object)re), (INodeEntry)node, (int)-1);
        }
        int resultCode = result;
        boolean bl = status = resultCode == 0;
        if (status) {
            return NodeExecutorResultImpl.createSuccess((INodeEntry)node);
        }
        context.getExecutionListener().log(0, logprompt + "failed: exit code: " + resultCode);
        return NodeExecutorResultImpl.createFailure((FailureReason)NodeStepFailureReason.NonZeroResultCode, (String)("[overthere-winrm] result code: " + resultCode), (INodeEntry)node, (int)resultCode);
    }

    protected CmdLine buildCommandLine(String[] command) {
        return OTWinRMNodeExecutor.buildCmdLineRaw(command);
    }

    protected ConnectionOptions willUseConnectionOptions(ConnectionOptions options) throws ConfigurationException {
        return options;
    }

    public static CmdLine buildCmdLineRaw(String ... args) {
        CmdLine cmdLine = new CmdLine();
        for (String s : args) {
            cmdLine.addRaw(s);
        }
        return cmdLine;
    }

    static String evaluateSecureOption(String optionName, ExecutionContext context) {
        if (null == optionName) {
            return null;
        }
        if (null == context.getPrivateDataContext()) {
            return null;
        }
        String[] opts = optionName.split("\\.", 2);
        String dataset = null;
        String optname = null;
        if (null != opts && 2 == opts.length) {
            dataset = opts[0];
            optname = opts[1];
        } else if (null != opts && 1 == opts.length) {
            dataset = "option";
            optname = opts[0];
        }
        Map option = (Map)context.getPrivateDataContext().get(dataset);
        if (null != option) {
            return (String)option.get(optname);
        }
        return null;
    }

    private static String resolveProperty(String nodeAttribute, String defaultValue, INodeEntry node, String frameworkProject, Framework framework) {
        if (null != node.getAttributes().get(nodeAttribute)) {
            return (String)node.getAttributes().get(nodeAttribute);
        }
        if (framework.hasProjectProperty(PROJ_PROP_PREFIX + nodeAttribute, frameworkProject) && !"".equals(framework.getProjectProperty(frameworkProject, PROJ_PROP_PREFIX + nodeAttribute))) {
            return framework.getProjectProperty(frameworkProject, PROJ_PROP_PREFIX + nodeAttribute);
        }
        if (framework.hasProperty(FWK_PROP_PREFIX + nodeAttribute)) {
            return framework.getProperty(FWK_PROP_PREFIX + nodeAttribute);
        }
        return defaultValue;
    }

    private static int resolveIntProperty(String attribute, int defaultValue, INodeEntry iNodeEntry, String frameworkProject, Framework framework) throws ConfigurationException {
        int value = defaultValue;
        String string = OTWinRMNodeExecutor.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Not a valid integer: " + attribute + ": " + string);
            }
        }
        return value;
    }

    private static long resolveLongProperty(String attribute, long defaultValue, INodeEntry iNodeEntry, String frameworkProject, Framework framework) throws ConfigurationException {
        long value = defaultValue;
        String string = OTWinRMNodeExecutor.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            try {
                value = Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException("Not a valid long: " + attribute + ": " + string);
            }
        }
        return value;
    }

    private static boolean resolveBooleanProperty(String attribute, boolean defaultValue, INodeEntry iNodeEntry, String frameworkProject, Framework framework) {
        boolean value = defaultValue;
        String string = OTWinRMNodeExecutor.resolveProperty(attribute, null, iNodeEntry, frameworkProject, framework);
        if (null != string) {
            value = Boolean.parseBoolean(string);
        }
        return value;
    }

    static String nonBlank(String input) {
        if (null == input || "".equals(input.trim())) {
            return null;
        }
        return input.trim();
    }

    protected String getClearAuthPassword(ConnectionOptionsBuilder options) throws ConfigurationException {
        return options.getPassword();
    }

    protected String getKerberosUsername(ConnectionOptionsBuilder options) throws ConfigurationException {
        String username = options.getUsername();
        String hostname = options.getHostname();
        if (username.indexOf("@") < 0 && null != options.getDomain()) {
            username = username + "@" + options.getDomain().toUpperCase();
        } else if (username.indexOf("@") < 0) {
            String domain = hostname.toUpperCase();
            if (domain.contains(":")) {
                domain = domain.substring(0, domain.indexOf(":"));
            }
            int domainNameIndex = domain.indexOf(".") + 1;
            if (options.isDomainMember().booleanValue()) {
                if (domainNameIndex == 0 || domainNameIndex >= domain.length()) {
                    throw new ConfigurationException("Node FQDN is not correct for configuration as domain member (no '.' found:" + domain + ")");
                }
                domain = domain.substring(domainNameIndex);
            }
            username = username + "@" + domain;
        } else if (username.indexOf("@") > 0) {
            String domain = username.substring(username.indexOf("@"));
            username = username.substring(0, username.indexOf("@")) + domain.toUpperCase();
        }
        return username;
    }

    protected class ConnectionOptionsBuilder {
        private ExecutionContext context;
        private INodeEntry node;
        private Framework framework;
        private String frameworkProject;

        ConnectionOptionsBuilder(ExecutionContext context, INodeEntry node, Framework framework) {
            this.context = context;
            this.node = node;
            this.framework = framework;
            this.frameworkProject = context.getFrameworkProject();
        }

        public String getPassword() throws ConfigurationException {
            String storagePath = OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_PASSWORD_STORAGE_PATH, null, this.getNode(), this.getFrameworkProject(), this.getFramework());
            if (null != storagePath) {
                if (storagePath.contains("${")) {
                    storagePath = DataContextUtils.replaceDataReferences((String)storagePath, (Map)this.context.getDataContext());
                }
                Path path = PathUtil.asPath((String)storagePath);
                try {
                    ResourceMeta contents = (ResourceMeta)this.context.getStorageTree().getResource(path).getContents();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    contents.writeContent((OutputStream)byteArrayOutputStream);
                    return new String(byteArrayOutputStream.toByteArray());
                }
                catch (StorageException e) {
                    throw new ConfigurationException("Failed to read the winrm password for storage path: " + storagePath + ": " + e.getMessage());
                }
                catch (IOException e) {
                    throw new ConfigurationException("Failed to read the winrm password for storage path: " + storagePath + ": " + e.getMessage());
                }
            }
            String passwordOption = OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_PASSWORD_OPTION, OTWinRMNodeExecutor.DEFAULT_WINRM_PASSWORD_OPTION, this.getNode(), this.getFrameworkProject(), this.getFramework());
            return OTWinRMNodeExecutor.evaluateSecureOption(passwordOption, this.getContext());
        }

        public int getConnectionTimeout() throws ConfigurationException {
            return OTWinRMNodeExecutor.resolveIntProperty(OTWinRMNodeExecutor.WINRM_CONNECTION_TIMEOUT_PROPERTY, 15000, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public String getUsername() {
            String user = null != OTWinRMNodeExecutor.nonBlank(this.getNode().getUsername()) || this.getNode().containsUserName() ? OTWinRMNodeExecutor.nonBlank(this.getNode().getUsername()) : OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_USER, null, this.getNode(), this.getFrameworkProject(), this.getFramework());
            if (null != user && user.contains("${")) {
                return DataContextUtils.replaceDataReferences((String)user, (Map)this.getContext().getDataContext());
            }
            return user;
        }

        public String getHostname() {
            return this.getNode().extractHostname();
        }

        public String getAuthType() {
            return OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_AUTH_TYPE, "kerberos", this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public WinrmHttpsCertificateTrustStrategy getCertTrustStrategy() {
            String trust = OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_CERT_TRUST, DEFAULT_CERT_TRUST.toString(), this.getNode(), this.getFrameworkProject(), this.getFramework());
            if (trust == null) {
                return DEFAULT_CERT_TRUST;
            }
            if (trust.equals(OTWinRMNodeExecutor.CERT_TRUST_DEFAULT)) {
                return WinrmHttpsCertificateTrustStrategy.STRICT;
            }
            if (trust.equals(OTWinRMNodeExecutor.CERT_TRUST_SELF_SIGNED)) {
                return WinrmHttpsCertificateTrustStrategy.SELF_SIGNED;
            }
            if (trust.equals("all")) {
                return WinrmHttpsCertificateTrustStrategy.ALLOW_ALL;
            }
            return DEFAULT_CERT_TRUST;
        }

        public WinrmHttpsHostnameVerificationStrategy getHostTrust() {
            String trust = OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_HOSTNAME_TRUST, DEFAULT_HOSTNAME_VERIFY.toString(), this.getNode(), this.getFrameworkProject(), this.getFramework());
            if (trust == null) {
                return DEFAULT_HOSTNAME_VERIFY;
            }
            if (trust.equals(OTWinRMNodeExecutor.HOSTNAME_TRUST_STRICT)) {
                return WinrmHttpsHostnameVerificationStrategy.STRICT;
            }
            if (trust.equals(OTWinRMNodeExecutor.HOSTNAME_TRUST_BROWSER_COMPATIBLE)) {
                return WinrmHttpsHostnameVerificationStrategy.BROWSER_COMPATIBLE;
            }
            if (trust.equals("all")) {
                return WinrmHttpsHostnameVerificationStrategy.ALLOW_ALL;
            }
            return DEFAULT_HOSTNAME_VERIFY;
        }

        public String getProtocol() {
            return OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_PROTOCOL, "https", this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public Boolean isDebugKerberosAuth() {
            return OTWinRMNodeExecutor.resolveBooleanProperty(OTWinRMNodeExecutor.DEBUG_KERBEROS_AUTH, DEFAULT_DEBUG_KERBEROS_AUTH, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public Boolean isDomainMember() {
            return OTWinRMNodeExecutor.resolveBooleanProperty(OTWinRMNodeExecutor.WINRM_IS_DOMAIN_MEMBER, DEFAULT_IS_DOMAIN_MEMBER, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public String getDomain() {
            return OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_DOMAIN, null, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public Boolean isWinrmSpnAddPort() {
            return OTWinRMNodeExecutor.resolveBooleanProperty(OTWinRMNodeExecutor.WINRM_SPN_ADD_PORT, false, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public Boolean isWinrmSpnUseHttp() {
            return OTWinRMNodeExecutor.resolveBooleanProperty(OTWinRMNodeExecutor.WINRM_SPN_USE_HTTP, false, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public String getWinrmLocale() {
            return OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_LOCALE, null, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public String getWinrmTimeout() {
            return OTWinRMNodeExecutor.resolveProperty(OTWinRMNodeExecutor.WINRM_TIMEOUT, null, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public Boolean isKerberosCacheEnabled() {
            return OTWinRMNodeExecutor.resolveBooleanProperty(OTWinRMNodeExecutor.KERBEROS_CACHE, DEFAULT_KERBEROS_CACHE, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        private int getPort(int defaultPort) throws ConfigurationException {
            if (this.getNode().containsPort()) {
                try {
                    return Integer.parseInt(this.getNode().extractPort());
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException("Port number is not valid: " + this.getNode().extractPort(), e);
                }
            }
            return OTWinRMNodeExecutor.resolveIntProperty(OTWinRMNodeExecutor.WINRM_PORT, defaultPort, this.getNode(), this.getFrameworkProject(), this.getFramework());
        }

        public ConnectionOptions build() throws ConfigurationException {
            boolean valid;
            String username;
            boolean isKerberos;
            ConnectionOptions options = new ConnectionOptions();
            String authType = this.getAuthType();
            boolean isHttps = "https".equalsIgnoreCase(this.getProtocol());
            boolean bl = isKerberos = this.getUsername().indexOf("@") > 0 || "kerberos".equals(authType);
            if (isKerberos) {
                username = OTWinRMNodeExecutor.this.getKerberosUsername(this);
                options.set("winrmKerberosDebug", (Object)this.isDebugKerberosAuth());
                options.set("winrmKerberosAddPortToSpn", (Object)this.isWinrmSpnAddPort());
                options.set("winrmKerberosUseHttpSpn", (Object)this.isWinrmSpnUseHttp());
                options.set("winrmKerberosTicketCache", (Object)this.isKerberosCacheEnabled());
            } else {
                username = this.getUsername();
            }
            String password = OTWinRMNodeExecutor.this.getClearAuthPassword(this);
            boolean bl2 = valid = null != password && !"".equals(password);
            if (!valid) {
                throw new ConfigurationException("Password was not set");
            }
            if (isHttps) {
                options.set("winrmHttpsCertificateTrustStrategy", (Object)this.getCertTrustStrategy());
                options.set("winrmHttpsHostnameVerificationStrategy", (Object)this.getHostTrust());
            }
            options.set("address", (Object)this.getHostname());
            options.set("username", (Object)username);
            options.set("password", (Object)password);
            options.set("os", (Object)OperatingSystemFamily.WINDOWS);
            options.set("connectionTimeoutMillis", (Object)this.getConnectionTimeout());
            options.set("port", (Object)this.getPort(isHttps ? 5986 : 5985));
            options.set("connectionType", (Object)CifsConnectionType.WINRM_INTERNAL);
            options.set("winrmEnableHttps", (Object)isHttps);
            options.set("winrmKerberosAddPortToSpn", (Object)this.isWinrmSpnAddPort());
            options.set("winrmKerberosUseHttpSpn", (Object)this.isWinrmSpnUseHttp());
            if (null != this.getWinrmLocale()) {
                options.set("", (Object)this.getWinrmLocale());
            }
            if (null != this.getWinrmTimeout()) {
                options.set(OTWinRMNodeExecutor.CONFIG_WINRM_TIMEOUT, (Object)this.getWinrmTimeout());
            }
            return options;
        }

        public ExecutionContext getContext() {
            return this.context;
        }

        public INodeEntry getNode() {
            return this.node;
        }

        public Framework getFramework() {
            return this.framework;
        }

        public String getFrameworkProject() {
            return this.frameworkProject;
        }
    }

    static class ConfigurationException
    extends Exception {
        ConfigurationException(String s) {
            super(s);
        }

        ConfigurationException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }

    public static enum Reason implements FailureReason
    {
        WinRMProtocolError;

    }
}

