/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLContext;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.nio.channels.SSLServerSocketChannel;
import org.rouplex.platform.tcp.RouplexTcpEndPoint;
import org.rouplex.platform.tcp.RouplexTcpServerListener;

public class RouplexTcpServer
extends RouplexTcpEndPoint {
    protected final RouplexTcpServerListener rouplexTcpServerListener;

    public static Builder newBuilder() {
        return new Builder();
    }

    RouplexTcpServer(Builder builder) {
        super(builder);
        this.rouplexTcpServerListener = builder.rouplexTcpServerListener;
    }

    private RouplexTcpServer bind() throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.selectableChannel;
        if (this.builder.receiveBufferSize != 0) {
            serverSocketChannel.socket().setReceiveBufferSize(this.builder.receiveBufferSize);
        }
        serverSocketChannel.configureBlocking(false);
        if (!serverSocketChannel.socket().isBound()) {
            serverSocketChannel.bind(this.builder.localAddress, ((Builder)this.builder).backlog);
        }
        this.rouplexTcpSelector.asyncRegisterTcpEndPoint(this);
        return this;
    }

    void handleBound() {
        this.handleOpen(null);
        if (this.rouplexTcpServerListener != null) {
            this.rouplexTcpServerListener.onBound(this);
        }
    }

    void handleUnBound() {
        if (this.rouplexTcpServerListener != null) {
            this.rouplexTcpServerListener.onUnBound(this);
        }
    }

    public static class Builder
    extends RouplexTcpEndPoint.Builder<RouplexTcpServer, Builder> {
        protected int backlog;
        protected RouplexTcpServerListener rouplexTcpServerListener;

        protected void checkCanBuild() {
            if (this.localAddress == null) {
                throw new IllegalStateException("Missing value for localAddress");
            }
        }

        public Builder withServerSocketChannel(ServerSocketChannel serverSocketChannel) {
            this.checkNotBuilt();
            this.selectableChannel = serverSocketChannel;
            return (Builder)this.builder;
        }

        public Builder withBacklog(int backlog) {
            this.checkNotBuilt();
            this.backlog = backlog;
            return (Builder)this.builder;
        }

        public Builder withSecure(boolean secure, @Nullable SSLContext sslContext) {
            this.checkNotBuilt();
            try {
                this.sslContext = secure ? (sslContext != null ? sslContext : SSLContext.getDefault()) : null;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create SSLContext.", e);
            }
            return (Builder)this.builder;
        }

        public Builder withRouplexTcpServerListener(RouplexTcpServerListener rouplexTcpServerListener) {
            this.checkNotBuilt();
            this.rouplexTcpServerListener = rouplexTcpServerListener;
            return (Builder)this.builder;
        }

        @Override
        public RouplexTcpServer buildAsync() throws IOException {
            this.checkNotBuilt();
            this.checkCanBuild();
            if (this.selectableChannel == null) {
                this.selectableChannel = this.sslContext == null ? ServerSocketChannel.open() : SSLServerSocketChannel.open((SSLContext)this.sslContext);
            }
            RouplexTcpServer result = new RouplexTcpServer(this);
            this.builder = null;
            return result.bind();
        }
    }
}

