/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.rouplex.commons.annotations.GuardedBy;
import org.rouplex.commons.collections.SortedByValueMap;
import org.rouplex.platform.tcp.RouplexTcpBinder;
import org.rouplex.platform.tcp.RouplexTcpClient;
import org.rouplex.platform.tcp.RouplexTcpEndPoint;
import org.rouplex.platform.tcp.RouplexTcpServer;

class RouplexTcpSelector
implements Closeable {
    protected final Object lock = new Object();
    protected final RouplexTcpBinder rouplexTcpBinder;
    protected final Selector selector;
    protected final ByteBuffer readBuffer;
    @GuardedBy(value="lock")
    protected List<RouplexTcpEndPoint> registeringTcpEndPoints = new ArrayList<RouplexTcpEndPoint>();
    @GuardedBy(value="lock")
    protected Map<RouplexTcpEndPoint, Exception> unregisteringTcpEndPoints = new HashMap<RouplexTcpEndPoint, Exception>();
    protected final Map<SelectionKey, Integer> removingInterestOps = new HashMap<SelectionKey, Integer>();
    protected final SortedByValueMap<SelectionKey, Long> resumingWrites = new SortedByValueMap();
    protected final SortedByValueMap<SelectionKey, Long> resumingReads = new SortedByValueMap();
    protected final SortedByValueMap<SelectionKey, Long> resumingAccepts = new SortedByValueMap();
    private boolean closed;

    RouplexTcpSelector(RouplexTcpBinder rouplexTcpBinder, Selector selector, int readBufferSize) {
        this.rouplexTcpBinder = rouplexTcpBinder;
        this.selector = selector;
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
        this.start(rouplexTcpBinder.getExecutorService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncRegisterTcpEndPoint(RouplexTcpEndPoint tcpEndPoint) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("RouplexTcpSelector already closed.");
            }
            this.registeringTcpEndPoints.add(tcpEndPoint);
            this.selector.wakeup();
        }
    }

    private boolean registerTcpEndPoint(RouplexTcpEndPoint tcpEndPoint) {
        boolean keepAccepting = true;
        try {
            SelectableChannel selectableChannel = tcpEndPoint.getSelectableChannel();
            selectableChannel.configureBlocking(false);
            if (tcpEndPoint instanceof RouplexTcpClient) {
                RouplexTcpClient tcpClient = (RouplexTcpClient)tcpEndPoint;
                int interestOps = 4;
                boolean connected = ((SocketChannel)selectableChannel).isConnected();
                if (!connected) {
                    interestOps |= 8;
                }
                tcpClient.setSelectionKey(selectableChannel.register(this.selector, interestOps, tcpEndPoint));
                if (connected) {
                    keepAccepting = this.notifyConnectedTcpClient(tcpClient);
                }
            } else if (tcpEndPoint instanceof RouplexTcpServer) {
                selectableChannel.register(this.selector, 16, tcpEndPoint);
                this.notifyBoundTcpServer((RouplexTcpServer)tcpEndPoint);
            }
        }
        catch (Exception e) {
            tcpEndPoint.closeSilently(e);
        }
        return keepAccepting;
    }

    private boolean notifyConnectedTcpClient(RouplexTcpClient tcpClient) {
        tcpClient.handleConnected();
        if (this.rouplexTcpBinder.rouplexTcpClientListener != null) {
            this.rouplexTcpBinder.rouplexTcpClientListener.onConnected(tcpClient);
        }
        return true;
    }

    private void notifyBoundTcpServer(RouplexTcpServer tcpServer) {
        tcpServer.handleBound();
        if (this.rouplexTcpBinder.rouplexTcpServerListener != null) {
            this.rouplexTcpBinder.rouplexTcpServerListener.onBound(tcpServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncUnregisterTcpEndPoint(RouplexTcpEndPoint tcpEndPoint, Exception optionalReason) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.unregisteringTcpEndPoints.put(tcpEndPoint, optionalReason);
                this.selector.wakeup();
            }
        }
    }

    private void unregisterTcpEndPoint(RouplexTcpEndPoint tcpEndPoint, Exception optionalReason) {
        try {
            if (tcpEndPoint instanceof RouplexTcpClient) {
                RouplexTcpClient tcpClient = (RouplexTcpClient)tcpEndPoint;
                if (tcpClient.open) {
                    boolean drainedChannels = tcpClient.handleDisconnected(optionalReason);
                    if (this.rouplexTcpBinder.rouplexTcpClientListener != null) {
                        this.rouplexTcpBinder.rouplexTcpClientListener.onDisconnected(tcpClient, optionalReason, drainedChannels);
                    }
                } else {
                    tcpClient.handleConnectionFailed(optionalReason);
                    if (this.rouplexTcpBinder.rouplexTcpClientListener != null) {
                        this.rouplexTcpBinder.rouplexTcpClientListener.onConnectionFailed(tcpClient, optionalReason);
                    }
                }
            } else if (tcpEndPoint instanceof RouplexTcpServer) {
                RouplexTcpServer tcpServer = (RouplexTcpServer)tcpEndPoint;
                tcpServer.handleUnBound();
                if (this.rouplexTcpBinder.rouplexTcpServerListener != null) {
                    this.rouplexTcpBinder.rouplexTcpServerListener.onUnBound(tcpServer);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @GuardedBy(value="lock")
    private long updateInterestOpsAndCalculateSelectTimeout() {
        for (Map.Entry<SelectionKey, Integer> removingInterestOp : this.removingInterestOps.entrySet()) {
            SelectionKey selectionKey = removingInterestOp.getKey();
            if (!selectionKey.isValid()) continue;
            selectionKey.interestOps(selectionKey.interestOps() & ~removingInterestOp.getValue().intValue());
        }
        this.removingInterestOps.clear();
        long now = System.currentTimeMillis();
        long timeout = Long.MAX_VALUE;
        timeout = Math.min(timeout, this.calculateNextSelectTimeout(this.resumingAccepts, now, 16));
        timeout = Math.min(timeout, this.calculateNextSelectTimeout(this.resumingReads, now, 1));
        timeout = Math.min(timeout, this.calculateNextSelectTimeout(this.resumingWrites, now, 4));
        return timeout == Long.MAX_VALUE ? 0L : timeout;
    }

    private long calculateNextSelectTimeout(SortedByValueMap<SelectionKey, Long> resumingSelectors, long now, int op) {
        long selectTimeout = Long.MAX_VALUE;
        Iterator iterator = resumingSelectors.sortedByValue().iterator();
        while (iterator.hasNext()) {
            Map.Entry resumingOp = (Map.Entry)iterator.next();
            SelectionKey selectionKey = (SelectionKey)resumingOp.getKey();
            if (!selectionKey.isValid()) {
                iterator.remove();
                continue;
            }
            if ((Long)resumingOp.getValue() <= now) {
                selectionKey.interestOps(selectionKey.interestOps() | op);
                iterator.remove();
                continue;
            }
            selectTimeout = (Long)resumingOp.getValue() - now;
            break;
        }
        return selectTimeout;
    }

    private void start(final ExecutorService executorService) {
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                currentThread.setName("RouplexTcpSelector");
                try {
                    block5: while (true) {
                        long selectTimeout;
                        Map<RouplexTcpEndPoint, Exception> unregisterTcpEndPoints;
                        List<RouplexTcpEndPoint> registerTcpEndPoints;
                        if (executorService.isShutdown() || currentThread.isInterrupted()) {
                            RouplexTcpSelector.this.close();
                        }
                        Iterator<Object> iterator = RouplexTcpSelector.this.lock;
                        synchronized (iterator) {
                            if (RouplexTcpSelector.this.closed) {
                                break;
                            }
                            if (RouplexTcpSelector.this.registeringTcpEndPoints.isEmpty()) {
                                registerTcpEndPoints = null;
                            } else {
                                registerTcpEndPoints = RouplexTcpSelector.this.registeringTcpEndPoints;
                                RouplexTcpSelector.this.registeringTcpEndPoints = new ArrayList<RouplexTcpEndPoint>();
                            }
                            if (RouplexTcpSelector.this.unregisteringTcpEndPoints.isEmpty()) {
                                unregisterTcpEndPoints = null;
                            } else {
                                unregisterTcpEndPoints = RouplexTcpSelector.this.unregisteringTcpEndPoints;
                                RouplexTcpSelector.this.unregisteringTcpEndPoints = new HashMap<RouplexTcpEndPoint, Exception>();
                            }
                            selectTimeout = RouplexTcpSelector.this.updateInterestOpsAndCalculateSelectTimeout();
                        }
                        if (registerTcpEndPoints != null) {
                            for (RouplexTcpEndPoint rouplexTcpEndPoint : registerTcpEndPoints) {
                                RouplexTcpSelector.this.registerTcpEndPoint(rouplexTcpEndPoint);
                            }
                        }
                        if (unregisterTcpEndPoints != null) {
                            for (Map.Entry entry : unregisterTcpEndPoints.entrySet()) {
                                RouplexTcpSelector.this.unregisterTcpEndPoint((RouplexTcpEndPoint)entry.getKey(), (Exception)entry.getValue());
                            }
                        }
                        RouplexTcpSelector.this.selector.selectedKeys().clear();
                        RouplexTcpSelector.this.selector.select(selectTimeout);
                        iterator = RouplexTcpSelector.this.selector.selectedKeys().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block5;
                            SelectionKey selectionKey = (SelectionKey)iterator.next();
                            RouplexTcpSelector.this.handleSelectedKey(selectionKey);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    RouplexTcpSelector.this.logSelectException(e);
                }
                RouplexTcpSelector.this.syncClose();
            }
        });
    }

    private void handleSelectedKey(SelectionKey selectionKey) {
        block29: {
            try {
                boolean eos;
                if (selectionKey.isAcceptable()) {
                    SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
                    RouplexTcpServer rouplexTcpServer = (RouplexTcpServer)selectionKey.attachment();
                    if (rouplexTcpServer.builder.sendBufferSize != 0) {
                        socketChannel.socket().setSendBufferSize(rouplexTcpServer.builder.sendBufferSize);
                    }
                    if (rouplexTcpServer.builder.receiveBufferSize != 0) {
                        socketChannel.socket().setReceiveBufferSize(rouplexTcpServer.builder.receiveBufferSize);
                    }
                    RouplexTcpSelector rouplexTcpSelector = this.rouplexTcpBinder.nextRouplexTcpSelector();
                    rouplexTcpSelector.asyncRegisterTcpEndPoint(new RouplexTcpClient(socketChannel, rouplexTcpSelector, rouplexTcpServer));
                    return;
                }
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                RouplexTcpClient rouplexTcpClient = (RouplexTcpClient)selectionKey.attachment();
                if (selectionKey.isConnectable()) {
                    try {
                        if (!socketChannel.finishConnect()) {
                            return;
                        }
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
                        this.notifyConnectedTcpClient(rouplexTcpClient);
                    }
                    catch (Exception e) {
                        rouplexTcpClient.closeSilently(e);
                        return;
                    }
                }
                if (selectionKey.isReadable()) {
                    int read = 0;
                    try {
                        while ((read = socketChannel.read(this.readBuffer)) != 0) {
                            byte[] readPayload;
                            if (read == -1) {
                                readPayload = RouplexTcpClient.EOS_BA;
                            } else {
                                readPayload = new byte[read];
                                System.arraycopy(this.readBuffer.array(), 0, readPayload, 0, this.readBuffer.position());
                                this.readBuffer.clear();
                            }
                            if (rouplexTcpClient.throttledReceiver.consumeSocketInput(readPayload) && read != -1) continue;
                            selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
                            break;
                        }
                    }
                    catch (Exception e) {
                        if (read == 0) {
                            try {
                                rouplexTcpClient.throttledReceiver.consumeSocketInput(null);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                        rouplexTcpClient.closeSilently(e);
                        return;
                    }
                }
                if (!selectionKey.isWritable()) break block29;
                do {
                    ByteBuffer writeBuffer;
                    if ((writeBuffer = rouplexTcpClient.throttledSender.pollFirstWriteBuffer()) == null) {
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                        break;
                    }
                    eos = !writeBuffer.hasRemaining();
                    try {
                        if (eos) {
                            socketChannel.shutdownOutput();
                        } else {
                            socketChannel.write(writeBuffer);
                            if (writeBuffer.hasRemaining()) break;
                        }
                        rouplexTcpClient.throttledSender.removeWriteBuffer(writeBuffer);
                    }
                    catch (Exception e) {
                        if (!rouplexTcpClient.throttledReceiver.eosReceived) {
                            try {
                                rouplexTcpClient.throttledReceiver.consumeSocketInput(null);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                        rouplexTcpClient.closeSilently(e);
                        break;
                    }
                } while (!eos);
            }
            catch (Exception e) {
                this.logHandleSelectedKeyException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRemoveInterestOps(SelectionKey selectionKey, int interestOps) {
        Object object = this.lock;
        synchronized (object) {
            Integer alreadyRemovingInterestOps = this.removingInterestOps.put(selectionKey, interestOps);
            if (alreadyRemovingInterestOps != null) {
                this.removingInterestOps.put(selectionKey, alreadyRemovingInterestOps | interestOps);
            }
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncPauseRead(SelectionKey selectionKey, long resumeTimestamp) {
        Object object = this.lock;
        synchronized (object) {
            if (selectionKey != null && selectionKey.isValid()) {
                this.resumingReads.put((Object)selectionKey, (Object)resumeTimestamp);
                this.asyncRemoveInterestOps(selectionKey, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncResumeRead(SelectionKey selectionKey) {
        Object object = this.lock;
        synchronized (object) {
            if (selectionKey != null && selectionKey.isValid()) {
                this.resumingReads.put((Object)selectionKey, (Object)0L);
                this.selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncPauseAccept(SelectionKey selectionKey, long resumeTimestamp) {
        Object object = this.lock;
        synchronized (object) {
            if (selectionKey != null && selectionKey.isValid()) {
                this.resumingAccepts.put((Object)selectionKey, (Object)resumeTimestamp);
                this.asyncRemoveInterestOps(selectionKey, 16);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncResumeWrite(SelectionKey selectionKey) {
        Object object = this.lock;
        synchronized (object) {
            if (selectionKey != null && selectionKey.isValid()) {
                this.resumingWrites.put((Object)selectionKey, (Object)0L);
                this.selector.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.selector.wakeup();
    }

    private void logHandleSelectedKeyException(Exception e) {
    }

    private void logSelectException(Exception e) {
    }

    private void syncClose() {
        for (SelectionKey selectionKey : this.selector.keys()) {
            try {
                ((RouplexTcpEndPoint)selectionKey.attachment()).close();
            }
            catch (IOException iOException) {}
        }
        for (RouplexTcpEndPoint rouplexTcpEndPoint : this.registeringTcpEndPoints) {
            try {
                rouplexTcpEndPoint.close();
            }
            catch (IOException iOException) {}
        }
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

