/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import javax.net.ssl.SSLContext;
import org.rouplex.commons.annotations.NotThreadSafe;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.platform.tcp.RouplexTcpBinder;
import org.rouplex.platform.tcp.RouplexTcpSelector;

class RouplexTcpEndPoint
implements Closeable {
    protected final Builder builder;
    protected final Object lock = new Object();
    protected final boolean sharedRouplexBinder;
    protected final RouplexTcpBinder rouplexTcpBinder;
    protected final RouplexTcpSelector rouplexTcpSelector;
    protected final SelectableChannel selectableChannel;
    protected Object attachment;
    protected boolean open;
    private boolean closed;
    private IOException ioException;

    protected <T extends RouplexTcpEndPoint, B extends Builder> RouplexTcpEndPoint(Builder<T, B> builder) {
        this.builder = builder;
        this.sharedRouplexBinder = builder.rouplexTcpBinder != null;
        this.rouplexTcpBinder = this.sharedRouplexBinder ? builder.rouplexTcpBinder : new RouplexTcpBinder();
        this.rouplexTcpSelector = this.rouplexTcpBinder.nextRouplexTcpSelector();
        this.selectableChannel = builder.selectableChannel;
        this.attachment = builder.attachment;
    }

    RouplexTcpEndPoint(SelectableChannel selectableChannel, RouplexTcpSelector rouplexTcpSelector) {
        this.builder = null;
        this.sharedRouplexBinder = true;
        this.rouplexTcpBinder = rouplexTcpSelector.rouplexTcpBinder;
        this.rouplexTcpSelector = rouplexTcpSelector;
        this.selectableChannel = selectableChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Already closed");
            }
            return ((NetworkChannel)((Object)this.selectableChannel)).getLocalAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForOpen(long expirationTimestamp) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.open) {
                if (this.ioException != null) {
                    throw this.ioException;
                }
                if (this.closed) {
                    throw new IOException("Closed");
                }
                long waitMillis = expirationTimestamp - System.currentTimeMillis();
                if (waitMillis <= 0L) {
                    this.handleClose(new IOException("Timeout"));
                }
                try {
                    this.lock.wait(waitMillis);
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interrupted");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOpen(@Nullable Exception optionalException) {
        Object object = this.lock;
        synchronized (object) {
            this.open = optionalException == null;
            if (!this.open) {
                this.ioException = optionalException instanceof IOException ? (IOException)optionalException : new IOException(optionalException);
            }
            this.lock.notifyAll();
        }
    }

    SelectableChannel getSelectableChannel() {
        return this.selectableChannel;
    }

    @Override
    public void close() throws IOException {
        this.handleClose(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleClose(@Nullable Exception optionalException) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.closed = true;
            this.lock.notifyAll();
            if (this.ioException == null && optionalException != null) {
                this.ioException = optionalException instanceof IOException ? (IOException)optionalException : new IOException(optionalException);
            }
            try {
                this.selectableChannel.close();
            }
            catch (IOException ioe) {
                this.ioException = ioe;
            }
            if (this.rouplexTcpSelector != null) {
                this.rouplexTcpSelector.asyncUnregisterTcpEndPoint(this, optionalException);
                if (!this.sharedRouplexBinder) {
                    this.rouplexTcpBinder.close();
                }
            }
            if (this.ioException != null) {
                throw this.ioException;
            }
        }
    }

    void closeSilently(Exception reason) {
        try {
            this.handleClose(reason);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @NotThreadSafe
    static abstract class Builder<T extends RouplexTcpEndPoint, B extends Builder> {
        protected SocketAddress localAddress;
        protected RouplexTcpBinder rouplexTcpBinder;
        protected int sendBufferSize;
        protected int receiveBufferSize;
        protected Object attachment;
        protected SSLContext sslContext;
        protected SelectableChannel selectableChannel;
        protected B builder = this;

        Builder() {
        }

        public abstract T buildAsync() throws IOException;

        protected void checkNotBuilt() {
            if (this.builder == null) {
                throw new IllegalStateException("Already built. Create a new builder to build a new instance.");
            }
        }

        public B withRouplexTcpBinder(RouplexTcpBinder rouplexTcpBinder) {
            this.checkNotBuilt();
            this.rouplexTcpBinder = rouplexTcpBinder;
            return this.builder;
        }

        public B withLocalAddress(SocketAddress localAddress) {
            this.checkNotBuilt();
            this.localAddress = localAddress;
            return this.builder;
        }

        public B withLocalAddress(@Nullable String hostname, int port) {
            this.checkNotBuilt();
            if (hostname == null || hostname.length() == 0) {
                try {
                    hostname = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    hostname = "localhost";
                }
            }
            this.localAddress = new InetSocketAddress(hostname, port);
            return this.builder;
        }

        public B withSendBufferSize(int sendBufferSize) {
            this.checkNotBuilt();
            this.sendBufferSize = sendBufferSize > 0 ? sendBufferSize : 0;
            return this.builder;
        }

        public B withReceiveBufferSize(int receiveBufferSize) {
            this.checkNotBuilt();
            this.receiveBufferSize = receiveBufferSize > 0 ? receiveBufferSize : 0;
            return this.builder;
        }

        public B withAttachment(@Nullable Object attachment) {
            this.checkNotBuilt();
            this.attachment = attachment;
            return this.builder;
        }

        public T build() throws IOException {
            return this.build(0);
        }

        public T build(int timeoutMillis) throws IOException {
            T result = this.buildAsync();
            this.builder = null;
            ((RouplexTcpEndPoint)result).waitForOpen(timeoutMillis > 0 ? (long)timeoutMillis : Long.MAX_VALUE);
            return result;
        }
    }
}

