/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.rouplex.platform.tcp.AopConfig;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpClient;

public class RouplexTcpClientReporter {
    private static final Logger logger = Logger.getLogger(RouplexTcpClientReporter.class.getSimpleName());
    public static final String format = "%s.%s:%s::%s:%s";
    public final RouplexTcpClient rouplexTcpClient;
    public final AopInstrumentor aopInstrumentor;
    public String actor;
    public String remoteAddress;
    public String remotePort;
    public String localAddress;
    public String localPort;
    public Meter sentBytes;
    public Meter unsentBytes;
    public Meter innerSentBytes;
    public Meter sentEos;
    public Meter innerSentEos;
    public Meter sentDisconnect;
    public Meter receivedBytes;
    public Meter receivedEos;
    public Meter receivedDisconnect;
    public String aggregatedId;
    public String completeId;

    public RouplexTcpClientReporter(RouplexTcpClient rouplexTcpClient, AopInstrumentor aopInstrumentor) {
        this.rouplexTcpClient = rouplexTcpClient;
        this.aopInstrumentor = aopInstrumentor;
        this.actor = rouplexTcpClient.getRouplexTcpServer() == null ? "RouplexTcpClient" : "RouplexTcpServer";
        try {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)rouplexTcpClient.getLocalAddress();
            this.localAddress = inetSocketAddress.getHostName();
            this.localPort = String.valueOf(inetSocketAddress.getPort());
            inetSocketAddress = (InetSocketAddress)rouplexTcpClient.getRemoteAddress();
            this.remoteAddress = inetSocketAddress.getHostName();
            this.remotePort = String.valueOf(inetSocketAddress.getPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.update();
    }

    public Object throttledSenderSend(ProceedingJoinPoint pjp) throws Throwable {
        ByteBuffer payload = (ByteBuffer)pjp.getArgs()[0];
        int payloadSize = 0;
        if (payload == null) {
            this.sentDisconnect.mark();
        } else if (!payload.hasRemaining()) {
            this.sentEos.mark();
        } else {
            payloadSize = payload.remaining();
        }
        Object result = pjp.proceed();
        if (payload == null) {
            logger.info(String.format("throttledSenderSend %s [sentDisconnect]", this.completeId));
        } else if (payloadSize == 0) {
            logger.info(String.format("throttledSenderSend %s [sentEos]", this.completeId));
        } else {
            this.sentBytes.mark((long)(payloadSize - payload.remaining()));
            this.unsentBytes.mark((long)payload.remaining());
            logger.info(String.format("throttledSenderSend %s [%s bytes (%s remaining)]", this.completeId, payloadSize - payload.remaining(), payload.remaining()));
        }
        return result;
    }

    private void update() {
        this.completeId = String.format(format, this.actor, this.localAddress, this.localPort, this.remoteAddress, this.remotePort);
        AopConfig aopConfig = this.aopInstrumentor.aopConfig;
        this.aggregatedId = String.format(format, this.actor, aopConfig.aggregateLocalAddresses ? "A" : this.localAddress, aopConfig.aggregateLocalPorts ? "A" : this.localPort, aopConfig.aggregateRemoteAddresses ? "A" : this.remoteAddress, aopConfig.aggregateRemotePorts ? "A" : this.remotePort);
        MetricRegistry metricRegistry = this.aopInstrumentor.metricRegistry;
        this.sentBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"sentBytes"}));
        this.unsentBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"unsentBytes"}));
        this.innerSentBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"innerSentBytes"}));
        this.sentEos = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"sentEos"}));
        this.innerSentEos = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"innerSentEos"}));
        this.sentDisconnect = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"sentDisconnect"}));
        this.receivedBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"receivedBytes"}));
        this.receivedEos = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"receivedEos"}));
        this.receivedDisconnect = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"receivedDisconnect"}));
    }

    public String getAggregatedId() {
        return this.aggregatedId;
    }
}

