/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.rouplex.commons.annotations.NotThreadSafe;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.nio.channels.SSLSocketChannel;
import org.rouplex.platform.io.Receiver;
import org.rouplex.platform.io.Sender;
import org.rouplex.platform.io.Throttle;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpClient$ThrottledSender$AjcClosure1;
import org.rouplex.platform.tcp.RouplexTcpClientListener;
import org.rouplex.platform.tcp.RouplexTcpEndPoint;
import org.rouplex.platform.tcp.RouplexTcpSelector;
import org.rouplex.platform.tcp.RouplexTcpServer;

public class RouplexTcpClient
extends RouplexTcpEndPoint {
    protected static final byte[] EOS_BA = new byte[0];
    private static final ByteBuffer EOS_BB = ByteBuffer.allocate(0);
    protected final RouplexTcpServer rouplexTcpServer;
    protected final RouplexTcpClientListener rouplexTcpClientListener;
    protected ThrottledSender throttledSender;
    protected ThrottledReceiver throttledReceiver;
    private static final TrustManager trustAll = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    public static Builder newBuilder() {
        return new Builder();
    }

    private void handleEos() {
        if (this.throttledSender.eosApplied && this.throttledReceiver.eosReceived) {
            this.closeSilently(null);
        }
    }

    void handleConnected() {
        this.handleOpen(null);
        if (this.rouplexTcpClientListener != null) {
            this.rouplexTcpClientListener.onConnected(this);
        }
    }

    void handleConnectionFailed(@Nullable Exception optionalReason) {
        if (this.rouplexTcpClientListener != null) {
            this.rouplexTcpClientListener.onConnectionFailed(this, optionalReason);
        }
    }

    boolean handleDisconnected(@Nullable Exception optionalReason) {
        boolean drainedChannels;
        boolean bl = drainedChannels = this.throttledReceiver.eosReceived && this.throttledSender.eosApplied;
        if (this.rouplexTcpClientListener != null) {
            this.rouplexTcpClientListener.onDisconnected(this, optionalReason, drainedChannels);
        }
        return drainedChannels;
    }

    RouplexTcpClient(Builder builder) {
        super(builder);
        this.rouplexTcpServer = null;
        this.rouplexTcpClientListener = builder.rouplexTcpClientListener;
    }

    RouplexTcpClient(SocketChannel socketChannel, RouplexTcpSelector rouplexTcpSelector, RouplexTcpServer rouplexTcpServer) {
        super(socketChannel, rouplexTcpSelector);
        this.rouplexTcpServer = rouplexTcpServer;
        this.rouplexTcpClientListener = null;
    }

    private void connectAsync() throws IOException {
        SocketChannel socketChannel = (SocketChannel)this.selectableChannel;
        socketChannel.configureBlocking(false);
        if (!socketChannel.isConnectionPending() && !socketChannel.isConnected()) {
            socketChannel.connect(((Builder)this.builder).remoteAddress);
        }
        this.rouplexTcpSelector.asyncRegisterTcpEndPoint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Already closed");
            }
            return ((SocketChannel)this.selectableChannel).getRemoteAddress();
        }
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.throttledSender = new ThrottledSender(selectionKey);
        this.throttledReceiver = new ThrottledReceiver(selectionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sender<ByteBuffer> hookSendChannel(Throttle throttle) {
        Object object = this.lock;
        synchronized (object) {
            if (this.throttledSender.throttle != null) {
                throw new IllegalStateException("Send channel already hooked.");
            }
            this.throttledSender.throttle = throttle;
            return this.throttledSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throttle hookReceiveChannel(@Nullable Receiver<byte[]> receiver, boolean started) {
        Object object = this.lock;
        synchronized (object) {
            if (this.throttledReceiver.receiver != null) {
                throw new IllegalStateException("Receive channel already hooked.");
            }
            this.throttledReceiver.receiver = receiver;
            if (started) {
                this.throttledReceiver.resume();
            }
            return this.throttledReceiver;
        }
    }

    public RouplexTcpServer getRouplexTcpServer() {
        return this.rouplexTcpServer;
    }

    public static SSLContext buildRelaxedSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustAll}, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class ThrottledSender
    implements Sender<ByteBuffer> {
        private final LinkedList<ByteBuffer> writeBuffers = new LinkedList();
        private final SelectionKey selectionKey;
        private long remaining;
        private Throttle throttle;
        boolean paused;
        boolean eosReceived;
        boolean eosApplied;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private ThrottledSender(SelectionKey selectionKey) {
            this.selectionKey = selectionKey;
            try {
                this.remaining = ((SocketChannel)RouplexTcpClient.this.selectableChannel).socket().getSendBufferSize();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private int transfer(ByteBuffer source, ByteBuffer destination) {
            int destRemaining;
            int srcRemaining = source.remaining();
            if (srcRemaining > (destRemaining = destination.remaining())) {
                int limit = source.limit();
                source.limit(source.position() + destRemaining);
                destination.put(source);
                source.limit(limit);
                return destRemaining;
            }
            if (source.hasRemaining()) {
                destination.put(source);
            }
            return srcRemaining;
        }

        public void send(ByteBuffer payload) throws IOException {
            ByteBuffer byteBuffer = payload;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)byteBuffer);
            Object[] objectArray = new Object[]{this, byteBuffer, joinPoint};
            AopInstrumentor.aspectOf().throttledSenderSend(new RouplexTcpClient$ThrottledSender$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteBuffer pollFirstWriteBuffer() {
            Object object = RouplexTcpClient.this.lock;
            synchronized (object) {
                return this.writeBuffers.isEmpty() ? null : (ByteBuffer)this.writeBuffers.iterator().next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeWriteBuffer(ByteBuffer writeBuffer) {
            Throttle throttle;
            Object object = RouplexTcpClient.this.lock;
            synchronized (object) {
                this.writeBuffers.remove(writeBuffer);
                this.remaining += (long)writeBuffer.limit();
                if (this.paused) {
                    this.paused = false;
                    throttle = this.throttle;
                } else {
                    throttle = null;
                }
            }
            if (throttle != null) {
                throttle.resume();
            }
            if (writeBuffer == EOS_BB) {
                this.eosApplied = true;
                RouplexTcpClient.this.handleEos();
            }
        }

        static {
            ThrottledSender.ajc$preClinit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final /* synthetic */ void send_aroundBody0(ThrottledSender ajc$this, ByteBuffer payload, JoinPoint joinPoint) {
            Throttle throttle;
            ByteBuffer writeBuffer;
            int writeSize;
            Object object = ajc$this.RouplexTcpClient.this.lock;
            synchronized (object) {
                if (ajc$this.eosReceived) {
                    throw new IOException("Sender is closed");
                }
                if (ajc$this.RouplexTcpClient.this.isClosed()) {
                    throw new IOException("TcpClient is closed");
                }
                if (payload == null) {
                    ajc$this.RouplexTcpClient.this.close();
                    return;
                }
                if (!payload.hasRemaining()) {
                    payload = EOS_BB;
                    ajc$this.eosReceived = true;
                } else if (ajc$this.paused) {
                    return;
                }
                ajc$this.paused = ajc$this.remaining < (long)payload.remaining();
                writeSize = (int)(ajc$this.paused ? ajc$this.remaining : (long)payload.remaining());
                ajc$this.remaining -= (long)writeSize;
            }
            if (payload != EOS_BB) {
                writeBuffer = ByteBuffer.allocate(writeSize);
                ajc$this.transfer(payload, writeBuffer);
                writeBuffer.flip();
            } else {
                writeBuffer = EOS_BB;
            }
            Object object2 = ajc$this.RouplexTcpClient.this.lock;
            synchronized (object2) {
                ajc$this.writeBuffers.add(writeBuffer);
                throttle = ajc$this.paused ? ajc$this.throttle : null;
            }
            ajc$this.RouplexTcpClient.this.rouplexTcpSelector.asyncResumeWrite(ajc$this.selectionKey);
            if (throttle != null) {
                try {
                    throttle.pause();
                }
                catch (RuntimeException re) {
                    ajc$this.RouplexTcpClient.this.closeSilently(re);
                }
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RouplexTcpClient.java", ThrottledSender.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "send", "org.rouplex.platform.tcp.RouplexTcpClient$ThrottledSender", "java.nio.ByteBuffer", "payload", "java.io.IOException", "void"), 321);
        }
    }

    class ThrottledReceiver
    extends Throttle {
        private final SelectionKey selectionKey;
        @Nullable
        private Receiver<byte[]> receiver;
        boolean eosReceived;
        private long rateLimitCurrentTimestamp;
        private long rateLimitCurrentBytes;
        private long rateLimitBytes;
        private long rateLimitMillis;

        private ThrottledReceiver(SelectionKey selectionKey) {
            this.selectionKey = selectionKey;
        }

        public boolean setMaxRate(long maxRate, long duration, TimeUnit timeUnit) {
            this.rateLimitBytes = maxRate;
            this.rateLimitMillis = timeUnit.toMillis(duration);
            this.resume();
            return true;
        }

        public boolean pause() {
            RouplexTcpClient.this.rouplexTcpSelector.asyncPauseRead(this.selectionKey, Long.MAX_VALUE);
            return true;
        }

        public void resume() {
            RouplexTcpClient.this.rouplexTcpSelector.asyncResumeRead(this.selectionKey);
        }

        boolean consumeSocketInput(byte[] payload) {
            boolean consumed;
            boolean bl = consumed = this.receiver == null || this.receiver.receive((Object)payload);
            if (payload == null) {
                return true;
            }
            if (this.rateLimitCurrentTimestamp != 0L) {
                if (System.currentTimeMillis() > this.rateLimitCurrentTimestamp) {
                    this.rateLimitCurrentTimestamp = System.currentTimeMillis() + this.rateLimitMillis;
                    this.rateLimitBytes = 0L;
                } else {
                    this.rateLimitCurrentBytes += (long)payload.length;
                    if (this.rateLimitCurrentBytes > this.rateLimitBytes) {
                        RouplexTcpClient.this.rouplexTcpSelector.asyncPauseRead(this.selectionKey, this.rateLimitCurrentTimestamp);
                    }
                }
            }
            if (this.eosReceived = payload == EOS_BA) {
                RouplexTcpClient.this.handleEos();
            }
            return consumed;
        }
    }

    @NotThreadSafe
    public static class Builder
    extends RouplexTcpEndPoint.Builder<RouplexTcpClient, Builder> {
        protected SocketAddress remoteAddress;
        protected RouplexTcpClientListener rouplexTcpClientListener;

        protected void checkCanBuild() {
            if (this.remoteAddress == null) {
                throw new IllegalStateException("Missing value for remoteAddress");
            }
        }

        public Builder withSocketChannel(SocketChannel socketChannel) {
            this.checkNotBuilt();
            this.selectableChannel = socketChannel;
            return (Builder)this.builder;
        }

        public Builder withRemoteAddress(SocketAddress remoteAddress) {
            this.checkNotBuilt();
            this.remoteAddress = remoteAddress;
            return (Builder)this.builder;
        }

        public Builder withRemoteAddress(String hostname, int port) {
            this.checkNotBuilt();
            this.remoteAddress = new InetSocketAddress(hostname, port);
            return (Builder)this.builder;
        }

        public Builder withSecure(boolean secure, @Nullable SSLContext sslContext) {
            this.checkNotBuilt();
            this.sslContext = secure ? (sslContext != null ? sslContext : RouplexTcpClient.buildRelaxedSSLContext()) : null;
            return (Builder)this.builder;
        }

        public Builder withRouplexTcpClientListener(RouplexTcpClientListener rouplexTcpClientListener) {
            this.checkNotBuilt();
            this.rouplexTcpClientListener = rouplexTcpClientListener;
            return (Builder)this.builder;
        }

        @Override
        public RouplexTcpClient buildAsync() throws IOException {
            this.checkNotBuilt();
            this.checkCanBuild();
            if (this.selectableChannel == null) {
                this.selectableChannel = this.sslContext == null ? SocketChannel.open() : SSLSocketChannel.open((SSLContext)this.sslContext);
            }
            RouplexTcpClient result = new RouplexTcpClient(this);
            this.builder = null;
            result.connectAsync();
            return result;
        }
    }
}

