/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ConcurrentModificationException;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.rouplex.platform.tcp.AopConfig;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpBinder;
import org.rouplex.platform.tcp.RouplexTcpSelector;

public class RouplexTcpBinderReporter {
    private static final Logger logger = Logger.getLogger(RouplexTcpBinderReporter.class.getSimpleName());
    public static final String format = "RouplexTcpBinder.%s";
    public final RouplexTcpBinder rouplexTcpBinder;
    public final AopInstrumentor aopInstrumentor;
    public Meter handleSelectedKey;
    public String aggregatedId;
    public String completeId;

    public RouplexTcpBinderReporter(RouplexTcpBinder rouplexTcpBinder, AopInstrumentor aopInstrumentor) {
        this.rouplexTcpBinder = rouplexTcpBinder;
        this.aopInstrumentor = aopInstrumentor;
        this.updateId();
    }

    public Object handleSelectedKey(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        this.handleSelectedKey.mark();
        logger.info(String.format("handleSelectedKey %s", this.completeId));
        return result;
    }

    private void updateId() {
        this.completeId = String.format(format, this.rouplexTcpBinder.hashCode());
        AopConfig aopConfig = this.aopInstrumentor.aopConfig;
        this.aggregatedId = String.format(format, aopConfig.aggregateTcpBinders ? "A" : Integer.valueOf(this.rouplexTcpBinder.hashCode()));
        this.handleSelectedKey = this.aopInstrumentor.metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"handleSelectedKey"}));
        try {
            this.aopInstrumentor.metricRegistry.register(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"registeredSelectionKeys"}), (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    int totalKeys = 0;
                    try {
                        for (RouplexTcpBinder tcpBinder : RouplexTcpBinderReporter.this.aopInstrumentor.tcpBinders.keySet()) {
                            RouplexTcpSelector tcpSelector;
                            RouplexTcpSelector markedTcpSelector = tcpBinder.nextRouplexTcpSelector();
                            do {
                                tcpSelector = tcpBinder.nextRouplexTcpSelector();
                                totalKeys += tcpSelector.selector.keys().size();
                            } while (tcpSelector != markedTcpSelector);
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                    return totalKeys;
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    public Object logHandleSelectedKeyException(ProceedingJoinPoint pjp) throws Throwable {
        Exception e = (Exception)pjp.getArgs()[0];
        logger.info(String.format("logHandleSelectedKeyException %s : %s", e.getClass(), e.getMessage()));
        return pjp.proceed();
    }

    public String getAggregatedId() {
        return this.aggregatedId;
    }
}

