/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Selector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.rouplex.commons.Supplier;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.nio.channels.SSLSelector;
import org.rouplex.platform.tcp.RouplexTcpClientListener;
import org.rouplex.platform.tcp.RouplexTcpSelector;
import org.rouplex.platform.tcp.RouplexTcpServerListener;

public class RouplexTcpBinder
implements Closeable {
    private static final Supplier<Selector> DEFAULT_SELECTOR_SUPPLIER = new Supplier<Selector>(){

        public Selector get() {
            try {
                return SSLSelector.open();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not create SSLSelector", ioe);
            }
        }
    };
    private static final ThreadFactory DEFAULT_THREAD_FATORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    };
    private final Object lock = new Object();
    private final ExecutorService executorService;
    private final boolean sharedExecutorService;
    private final RouplexTcpSelector[] tcpSelectors;
    private final AtomicInteger tcpSelectorIndex = new AtomicInteger();
    private boolean closed;
    @Nullable
    protected RouplexTcpClientListener rouplexTcpClientListener;
    @Nullable
    protected RouplexTcpServerListener rouplexTcpServerListener;

    public RouplexTcpBinder() {
        this(DEFAULT_SELECTOR_SUPPLIER);
    }

    public RouplexTcpBinder(Supplier<Selector> selectorSupplier) {
        this(selectorSupplier, null);
    }

    public RouplexTcpBinder(Supplier<Selector> selectorSupplier, ExecutorService executorService) {
        this(selectorSupplier, executorService, 0x100000);
    }

    public RouplexTcpBinder(Supplier<Selector> selectorSupplier, ExecutorService executorService, int readBufferSize) {
        this.tcpSelectors = new RouplexTcpSelector[Runtime.getRuntime().availableProcessors()];
        this.sharedExecutorService = executorService != null;
        ExecutorService executorService2 = this.executorService = this.sharedExecutorService ? executorService : Executors.newFixedThreadPool(this.tcpSelectors.length, DEFAULT_THREAD_FATORY);
        if (readBufferSize <= 0) {
            throw new IllegalArgumentException("Read buffer size must be positive");
        }
        for (int counter = 0; counter < this.tcpSelectors.length; ++counter) {
            this.tcpSelectors[counter] = new RouplexTcpSelector(this, (Selector)selectorSupplier.get(), readBufferSize);
        }
    }

    RouplexTcpSelector nextRouplexTcpSelector() {
        return this.tcpSelectors[this.tcpSelectorIndex.getAndIncrement() % this.tcpSelectors.length];
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RouplexTcpBinder rouplexTcpBinder = this;
        synchronized (rouplexTcpBinder) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        for (int counter = 0; counter < this.tcpSelectors.length; ++counter) {
            this.tcpSelectors[counter].close();
        }
        if (!this.sharedExecutorService) {
            this.executorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRouplexTcpClientListener(@Nullable RouplexTcpClientListener rouplexTcpClientListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.rouplexTcpClientListener != null) {
                throw new IllegalStateException("RouplexTcpClientListener already set.");
            }
            this.rouplexTcpClientListener = rouplexTcpClientListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRouplexTcpServerListener(@Nullable RouplexTcpServerListener rouplexTcpServerListener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.rouplexTcpServerListener != null) {
                throw new IllegalStateException("RouplexTcpServerListener already set.");
            }
            this.rouplexTcpServerListener = rouplexTcpServerListener;
        }
    }
}

