/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import javax.net.ssl.SSLContext;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.nio.channels.SSLServerSocketChannel;
import org.rouplex.platform.tcp.RouplexTcpBroker;
import org.rouplex.platform.tcp.RouplexTcpClientListener;
import org.rouplex.platform.tcp.RouplexTcpEndPoint;
import org.rouplex.platform.tcp.RouplexTcpServerListener;

public class RouplexTcpServer
extends RouplexTcpEndPoint {
    final int sendBufferSize;
    final int receiveBufferSize;
    final RouplexTcpServerListener rouplexTcpServerListener;
    final RouplexTcpClientListener rouplexTcpClientListener;

    RouplexTcpServer(Builder builder) throws IOException {
        super(builder);
        this.sendBufferSize = builder.sendBufferSize;
        this.receiveBufferSize = builder.receiveBufferSize;
        this.rouplexTcpServerListener = builder.rouplexTcpServerListener;
        this.rouplexTcpClientListener = builder.rouplexTcpClientListener;
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)this.selectableChannel;
        serverSocketChannel.configureBlocking(false);
        if (!serverSocketChannel.socket().isBound()) {
            if (builder.receiveBufferSize != 0) {
                serverSocketChannel.socket().setReceiveBufferSize(builder.receiveBufferSize);
            }
            serverSocketChannel.socket().bind(builder.localAddress, builder.backlog);
        }
        this.rouplexTcpSelector.asyncRegisterTcpEndPoint(this);
    }

    void handleBound() {
        this.handleOpen();
        if (this.rouplexTcpServerListener != null) {
            this.rouplexTcpServerListener.onBound(this);
        }
    }

    void handleUnBound() {
        if (this.rouplexTcpServerListener != null) {
            this.rouplexTcpServerListener.onUnBound(this);
        }
    }

    public static class Builder
    extends RouplexTcpEndPoint.Builder<RouplexTcpServer, Builder> {
        protected int backlog;
        protected RouplexTcpServerListener rouplexTcpServerListener;
        protected RouplexTcpClientListener rouplexTcpClientListener;

        Builder(RouplexTcpBroker rouplexTcpBroker) {
            super(rouplexTcpBroker);
        }

        protected void checkCanBuild() {
            if (this.localAddress == null) {
                throw new IllegalStateException("Missing value for localAddress");
            }
        }

        public Builder withServerSocketChannel(ServerSocketChannel serverSocketChannel) {
            this.checkNotBuilt();
            this.selectableChannel = serverSocketChannel;
            return (Builder)this.builder;
        }

        public Builder withBacklog(int backlog) {
            this.checkNotBuilt();
            this.backlog = backlog;
            return (Builder)this.builder;
        }

        public Builder withSecure(boolean secure, @Nullable SSLContext sslContext) {
            this.checkNotBuilt();
            try {
                this.sslContext = secure ? (sslContext != null ? sslContext : SSLContext.getDefault()) : null;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create SSLContext.", e);
            }
            return (Builder)this.builder;
        }

        public Builder withRouplexTcpServerListener(RouplexTcpServerListener rouplexTcpServerListener) {
            this.checkNotBuilt();
            this.rouplexTcpServerListener = rouplexTcpServerListener;
            return (Builder)this.builder;
        }

        public Builder withRouplexTcpClientListener(RouplexTcpClientListener rouplexTcpClientListener) {
            this.checkNotBuilt();
            this.rouplexTcpClientListener = rouplexTcpClientListener;
            return (Builder)this.builder;
        }

        @Override
        public RouplexTcpServer buildAsync() throws IOException {
            this.checkNotBuilt();
            this.checkCanBuild();
            if (this.selectableChannel == null) {
                this.selectableChannel = this.sslContext == null ? ServerSocketChannel.open() : SSLServerSocketChannel.open((SSLContext)this.sslContext);
            }
            return new RouplexTcpServer(this);
        }
    }
}

