/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpSelector;

public class RouplexTcpSelectorReporter {
    private static final Logger logger = Logger.getLogger(RouplexTcpSelectorReporter.class.getSimpleName());
    public static final String format = "RouplexTcpSelector.%s";
    public final RouplexTcpSelector rouplexTcpSelector;
    public final AopInstrumentor aopInstrumentor;
    public Meter handleSelectedKey;
    public String aggregatedId;
    public String completeId;

    public RouplexTcpSelectorReporter(RouplexTcpSelector rouplexTcpSedlector, AopInstrumentor aopInstrumentor) {
        this.rouplexTcpSelector = rouplexTcpSedlector;
        this.aopInstrumentor = aopInstrumentor;
        this.updateId();
    }

    public Object reportHandleSelectedKey(ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        this.handleSelectedKey.mark();
        logger.info(String.format("handleSelectedKey %s", this.completeId));
        return result;
    }

    private void updateId() {
        this.completeId = String.format(format, this.rouplexTcpSelector.hashCode());
        this.aggregatedId = String.format(format, this.aopInstrumentor.aopConfig.aggregateTcpSelectors ? "A" : Integer.valueOf(this.rouplexTcpSelector.hashCode()));
        this.handleSelectedKey = this.aopInstrumentor.metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"handleSelectedKey"}));
        try {
            this.aopInstrumentor.metricRegistry.register(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"registeredSelectionKeys"}), (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    int totalKeys = 0;
                    try {
                        Iterator iterator = RouplexTcpSelectorReporter.this.aopInstrumentor.tcpSelectors.keySet().iterator();
                        while (iterator.hasNext()) {
                            RouplexTcpSelector cfr_ignored_0 = (RouplexTcpSelector)iterator.next();
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                    return totalKeys;
                }
            });
        }
        catch (RuntimeException runtimeException) {}
    }

    public Object reportHandleSelectedKeyException(ProceedingJoinPoint pjp) throws Throwable {
        Exception e = (Exception)pjp.getArgs()[0];
        logger.warning(String.format("handleSelectedKeyException %s : %s : %s", e.getClass().getSimpleName(), e.getMessage(), AopInstrumentor.getStackTrace(e)));
        return pjp.proceed();
    }

    public Object reportHandleSelectException(ProceedingJoinPoint pjp) throws Throwable {
        Exception e = (Exception)pjp.getArgs()[0];
        logger.warning(String.format("handleSelectException %s : %s : %s", e.getClass().getSimpleName(), e.getMessage(), AopInstrumentor.getStackTrace(e)));
        return pjp.proceed();
    }

    public String getAggregatedId() {
        return this.aggregatedId;
    }
}

