/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.rouplex.commons.annotations.GuardedBy;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpBroker;
import org.rouplex.platform.tcp.RouplexTcpClient;
import org.rouplex.platform.tcp.RouplexTcpEndPoint;
import org.rouplex.platform.tcp.RouplexTcpSelector$AjcClosure1;
import org.rouplex.platform.tcp.RouplexTcpSelector$AjcClosure3;
import org.rouplex.platform.tcp.RouplexTcpSelector$AjcClosure5;
import org.rouplex.platform.tcp.RouplexTcpServer;

class RouplexTcpSelector
implements Runnable {
    private final Object lock = new Object();
    private final RouplexTcpBroker rouplexTcpBroker;
    private final Selector selector;
    private final ByteBuffer readBuffer;
    @GuardedBy(value="lock")
    private List<RouplexTcpEndPoint> registeringTcpEndPoints = new ArrayList<RouplexTcpEndPoint>();
    @GuardedBy(value="lock")
    private Map<RouplexTcpEndPoint, Exception> unregisteringTcpEndPoints = new HashMap<RouplexTcpEndPoint, Exception>();
    @GuardedBy(value="lock")
    private List<PendingOps> pausingInterestOps = new ArrayList<PendingOps>();
    @GuardedBy(value="lock")
    private List<PendingOps> resumingInterestOps = new ArrayList<PendingOps>();
    private final SortedMap<Long, List<PendingOps>> resumingLaterInterestOps = new TreeMap<Long, List<PendingOps>>();
    private boolean closed;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    RouplexTcpSelector(RouplexTcpBroker rouplexTcpBroker, Selector selector, int readBufferSize) {
        this.rouplexTcpBroker = rouplexTcpBroker;
        this.selector = selector;
        this.readBuffer = ByteBuffer.allocate(readBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncRegisterTcpEndPoint(RouplexTcpEndPoint tcpEndPoint) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException("RouplexTcpSelector already closed.");
            }
            this.registeringTcpEndPoints.add(tcpEndPoint);
        }
        this.selector.wakeup();
    }

    private boolean registerTcpEndPoint(RouplexTcpEndPoint tcpEndPoint) {
        boolean keepAccepting = true;
        try {
            SelectableChannel selectableChannel = tcpEndPoint.getSelectableChannel();
            selectableChannel.configureBlocking(false);
            if (tcpEndPoint instanceof RouplexTcpClient) {
                RouplexTcpClient tcpClient = (RouplexTcpClient)tcpEndPoint;
                int interestOps = 4;
                boolean connected = ((SocketChannel)selectableChannel).isConnected();
                if (!connected) {
                    interestOps |= 8;
                }
                tcpClient.setSelectionKey(selectableChannel.register(this.selector, interestOps, tcpEndPoint));
                if (connected) {
                    tcpClient.handleConnected();
                }
            } else if (tcpEndPoint instanceof RouplexTcpServer) {
                selectableChannel.register(this.selector, 16, tcpEndPoint);
                RouplexTcpServer tcpServer = (RouplexTcpServer)tcpEndPoint;
                tcpServer.handleBound();
            }
        }
        catch (Exception e) {
            this.unregisterTcpEndPoint(tcpEndPoint, e);
        }
        return keepAccepting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncUnregisterTcpEndPoint(RouplexTcpEndPoint tcpEndPoint, Exception optionalReason) {
        Object object = this.lock;
        synchronized (object) {
            this.unregisteringTcpEndPoints.put(tcpEndPoint, optionalReason);
        }
        this.selector.wakeup();
    }

    private void unregisterTcpEndPoint(RouplexTcpEndPoint tcpEndPoint, Exception optionalReason) {
        try {
            if (tcpEndPoint instanceof RouplexTcpClient) {
                RouplexTcpClient tcpClient = (RouplexTcpClient)tcpEndPoint;
                if (tcpClient.open) {
                    tcpClient.handleDisconnected(optionalReason);
                } else {
                    tcpClient.handleConnectionFailed(optionalReason);
                }
            } else if (tcpEndPoint instanceof RouplexTcpServer) {
                RouplexTcpServer tcpServer = (RouplexTcpServer)tcpEndPoint;
                tcpServer.handleUnBound();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            block9: while (true) {
                Map<RouplexTcpEndPoint, Exception> unregisterTcpEndPoints;
                List<RouplexTcpEndPoint> registerTcpEndPoints;
                long now = System.currentTimeMillis();
                Iterator<Object> iterator = this.lock;
                synchronized (iterator) {
                    if (this.closed) {
                        break;
                    }
                    if (this.registeringTcpEndPoints.isEmpty()) {
                        registerTcpEndPoints = null;
                    } else {
                        registerTcpEndPoints = this.registeringTcpEndPoints;
                        this.registeringTcpEndPoints = new ArrayList<RouplexTcpEndPoint>();
                    }
                    if (this.unregisteringTcpEndPoints.isEmpty()) {
                        unregisterTcpEndPoints = null;
                    } else {
                        unregisterTcpEndPoints = this.unregisteringTcpEndPoints;
                        this.unregisteringTcpEndPoints = new HashMap<RouplexTcpEndPoint, Exception>();
                    }
                    if (!this.pausingInterestOps.isEmpty()) {
                        for (PendingOps pausingOps : this.pausingInterestOps) {
                            this.pauseInterestOps(pausingOps);
                        }
                        this.pausingInterestOps = new ArrayList<PendingOps>();
                    }
                    if (!this.resumingInterestOps.isEmpty()) {
                        for (PendingOps resumingOps : this.resumingInterestOps) {
                            try {
                                resumingOps.enablePendingOps();
                            }
                            catch (CancelledKeyException cancelledKeyException) {}
                        }
                        this.resumingInterestOps = new ArrayList<PendingOps>();
                    }
                }
                if (registerTcpEndPoints != null) {
                    for (RouplexTcpEndPoint rouplexTcpEndPoint : registerTcpEndPoints) {
                        this.registerTcpEndPoint(rouplexTcpEndPoint);
                    }
                }
                if (unregisterTcpEndPoints != null) {
                    for (Map.Entry entry : unregisterTcpEndPoints.entrySet()) {
                        this.unregisterTcpEndPoint((RouplexTcpEndPoint)entry.getKey(), (Exception)entry.getValue());
                    }
                }
                long selectTimeout = 0L;
                Iterator<Map.Entry<Long, List<PendingOps>>> iterator2 = this.resumingLaterInterestOps.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<Long, List<PendingOps>> resumingOpsAtSameTime = iterator2.next();
                    if (resumingOpsAtSameTime.getKey() > now) {
                        selectTimeout = resumingOpsAtSameTime.getKey() - now;
                        break;
                    }
                    for (PendingOps resumingOps : resumingOpsAtSameTime.getValue()) {
                        try {
                            resumingOps.enablePendingOps();
                        }
                        catch (CancelledKeyException cancelledKeyException) {}
                    }
                    iterator2.remove();
                }
                this.selector.selectedKeys().clear();
                this.selector.select(selectTimeout);
                Iterator<SelectionKey> iterator3 = this.selector.selectedKeys().iterator();
                while (true) {
                    if (!iterator3.hasNext()) continue block9;
                    SelectionKey selectionKey = iterator3.next();
                    this.handleSelectedKey(selectionKey);
                }
                break;
            }
        }
        catch (Exception e) {
            this.handleSelectException(e);
        }
        this.syncClose();
    }

    void handleSelectedKey(SelectionKey selectionKey) {
        SelectionKey selectionKey2 = selectionKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)selectionKey2);
        Object[] objectArray = new Object[]{this, selectionKey2, joinPoint};
        AopInstrumentor.aspectOf().aroundHandleSelectedKey(new RouplexTcpSelector$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void handleReadWriteUserException(RouplexTcpClient tcpClient, Exception e) {
        if (!tcpClient.throttledReceiver.eosReceived) {
            try {
                tcpClient.throttledReceiver.handleSocketInput(null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.unregisterTcpEndPoint(tcpClient, e);
    }

    private void pauseInterestOps(PendingOps pausingOps) {
        try {
            pausingOps.disablePendingOps();
            if (pausingOps.timestamp != 0L) {
                ArrayList<PendingOps> resumingOps = (ArrayList<PendingOps>)this.resumingLaterInterestOps.get(pausingOps.timestamp);
                if (resumingOps == null) {
                    resumingOps = new ArrayList<PendingOps>();
                    this.resumingLaterInterestOps.put(pausingOps.timestamp, resumingOps);
                }
                resumingOps.add(pausingOps);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncPauseInterestOps(SelectionKey selectionKey, int interestOps, long resumeTimestamp) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.pausingInterestOps.add(new PendingOps(selectionKey, interestOps, resumeTimestamp));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncResumeInterestOps(SelectionKey selectionKey, int interestOps) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.resumingInterestOps.add(new PendingOps(selectionKey, interestOps, 0L));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestClose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.selector.wakeup();
    }

    void handleSelectedKeyException(Exception e) {
        Exception exception = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)exception);
        Object[] objectArray = new Object[]{this, exception, joinPoint};
        AopInstrumentor.aspectOf().aroundHandleSelectedKeyException(new RouplexTcpSelector$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    void handleSelectException(Exception e) {
        Exception exception = e;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)exception);
        Object[] objectArray = new Object[]{this, exception, joinPoint};
        AopInstrumentor.aspectOf().aroundHandleSelectException(new RouplexTcpSelector$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    private void syncClose() {
        for (SelectionKey selectionKey : this.selector.keys()) {
            try {
                ((RouplexTcpEndPoint)selectionKey.attachment()).close();
            }
            catch (RuntimeException runtimeException) {}
        }
        for (RouplexTcpEndPoint rouplexTcpEndPoint : this.registeringTcpEndPoints) {
            try {
                rouplexTcpEndPoint.close();
            }
            catch (RuntimeException runtimeException) {}
        }
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        RouplexTcpSelector.ajc$preClinit();
    }

    static final /* synthetic */ void handleSelectedKey_aroundBody0(RouplexTcpSelector ajc$this, SelectionKey selectionKey, JoinPoint joinPoint) {
        block24: {
            try {
                boolean eos;
                if (selectionKey.isAcceptable()) {
                    SocketChannel socketChannel = ((ServerSocketChannel)selectionKey.channel()).accept();
                    RouplexTcpSelector tcpSelector = ajc$this.rouplexTcpBroker.nextRouplexTcpSelector();
                    tcpSelector.asyncRegisterTcpEndPoint(new RouplexTcpClient(socketChannel, tcpSelector, (RouplexTcpServer)selectionKey.attachment()));
                    return;
                }
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                RouplexTcpClient tcpClient = (RouplexTcpClient)selectionKey.attachment();
                if (selectionKey.isConnectable()) {
                    try {
                        if (!socketChannel.finishConnect()) {
                            return;
                        }
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
                        tcpClient.handleConnected();
                    }
                    catch (Exception e) {
                        ajc$this.unregisterTcpEndPoint(tcpClient, e);
                        return;
                    }
                }
                if (selectionKey.isReadable()) {
                    try {
                        int read;
                        while ((read = socketChannel.read(ajc$this.readBuffer)) != 0) {
                            byte[] readPayload;
                            if (read == -1) {
                                readPayload = RouplexTcpClient.EOS_BA;
                            } else {
                                readPayload = new byte[read];
                                System.arraycopy(ajc$this.readBuffer.array(), 0, readPayload, 0, ajc$this.readBuffer.position());
                                ajc$this.readBuffer.clear();
                            }
                            long resumeTimestamp = tcpClient.throttledReceiver.handleSocketInput(readPayload);
                            if (resumeTimestamp == -2L) {
                                ajc$this.unregisterTcpEndPoint(tcpClient, null);
                                return;
                            }
                            if (resumeTimestamp == -1L) continue;
                            if (resumeTimestamp == 0L) {
                                selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFE);
                            } else {
                                ajc$this.pauseInterestOps(ajc$this.new PendingOps(selectionKey, 1, resumeTimestamp));
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        ajc$this.handleReadWriteUserException(tcpClient, e);
                        return;
                    }
                }
                if (!selectionKey.isWritable()) break block24;
                do {
                    ByteBuffer writeBuffer;
                    if ((writeBuffer = tcpClient.throttledSender.pollFirstWriteBuffer()) == null) {
                        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
                        break;
                    }
                    eos = !writeBuffer.hasRemaining();
                    try {
                        if (eos) {
                            socketChannel.socket().shutdownOutput();
                        } else {
                            socketChannel.write(writeBuffer);
                            if (writeBuffer.hasRemaining()) break;
                        }
                        if (tcpClient.throttledSender.removeWriteBuffer(writeBuffer) != -2) continue;
                        ajc$this.unregisterTcpEndPoint(tcpClient, null);
                        return;
                    }
                    catch (Exception e) {
                        ajc$this.handleReadWriteUserException(tcpClient, e);
                        break;
                    }
                } while (!eos);
            }
            catch (Exception e) {
                ajc$this.handleSelectedKeyException(e);
            }
        }
    }

    static final /* synthetic */ void handleSelectedKeyException_aroundBody2(RouplexTcpSelector ajc$this, Exception e, JoinPoint joinPoint) {
    }

    static final /* synthetic */ void handleSelectException_aroundBody4(RouplexTcpSelector ajc$this, Exception e, JoinPoint joinPoint) {
        ajc$this.rouplexTcpBroker.close();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RouplexTcpSelector.java", RouplexTcpSelector.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "handleSelectedKey", "org.rouplex.platform.tcp.RouplexTcpSelector", "java.nio.channels.SelectionKey", "selectionKey", "", "void"), 275);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "handleSelectedKeyException", "org.rouplex.platform.tcp.RouplexTcpSelector", "java.lang.Exception", "e", "", "void"), 478);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "handleSelectException", "org.rouplex.platform.tcp.RouplexTcpSelector", "java.lang.Exception", "e", "", "void"), 482);
    }

    private class PendingOps {
        final SelectionKey selectionKey;
        final int pendingOps;
        final long timestamp;

        PendingOps(SelectionKey selectionKey, int pendingOps, long timestamp) {
            this.selectionKey = selectionKey;
            this.pendingOps = pendingOps;
            this.timestamp = timestamp;
        }

        void disablePendingOps() {
            this.selectionKey.interestOps(this.selectionKey.interestOps() & ~this.pendingOps);
        }

        void enablePendingOps() {
            this.selectionKey.interestOps(this.selectionKey.interestOps() | this.pendingOps);
        }
    }
}

