/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLContext;
import org.rouplex.commons.annotations.NotThreadSafe;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.platform.tcp.RouplexTcpBroker;
import org.rouplex.platform.tcp.RouplexTcpSelector;

class RouplexTcpEndPoint
implements Closeable {
    protected final Object lock = new Object();
    protected final RouplexTcpSelector rouplexTcpSelector;
    protected final SelectableChannel selectableChannel;
    protected Object attachment;
    protected boolean open;
    private boolean closed;
    protected IOException ioException;
    String debugId;

    protected <T extends RouplexTcpEndPoint, B extends Builder> RouplexTcpEndPoint(Builder<T, B> builder) {
        this.rouplexTcpSelector = builder.rouplexTcpSelector;
        this.selectableChannel = builder.selectableChannel;
        this.attachment = builder.attachment;
    }

    RouplexTcpEndPoint(SelectableChannel selectableChannel, RouplexTcpSelector rouplexTcpSelector) {
        this.selectableChannel = selectableChannel;
        this.rouplexTcpSelector = rouplexTcpSelector;
    }

    SelectableChannel getSelectableChannel() {
        return this.selectableChannel;
    }

    public SocketAddress getLocalAddress() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Already closed");
            }
            if (this.selectableChannel instanceof SocketChannel) {
                return ((SocketChannel)this.selectableChannel).socket().getLocalSocketAddress();
            }
            if (this.selectableChannel instanceof ServerSocketChannel) {
                return ((ServerSocketChannel)this.selectableChannel).socket().getLocalSocketAddress();
            }
            throw new Error(String.format("Internal implementation error: Class %s is not a NetworkChannel", this.selectableChannel.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForOpen(long expirationTimestamp) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.open) {
                if (this.ioException != null) {
                    throw this.ioException;
                }
                long waitMillis = expirationTimestamp - System.currentTimeMillis();
                if (waitMillis > 0L) {
                    try {
                        this.lock.wait(waitMillis);
                    }
                    catch (InterruptedException ie) {
                        this.setExceptionAndCloseChannel(new IOException("Interrupted", ie));
                    }
                    continue;
                }
                this.setExceptionAndCloseChannel(new IOException("Timeout"));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleOpen() {
        Object object = this.lock;
        synchronized (object) {
            if (this.ioException == null) {
                this.open = true;
                this.lock.notifyAll();
            }
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    void close(@Nullable Exception optionalException) {
        this.setExceptionAndCloseChannel(optionalException);
        this.rouplexTcpSelector.asyncUnregisterTcpEndPoint(this, this.ioException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExceptionAndCloseChannel(@Nullable Exception optionalException) {
        Object object = this.lock;
        synchronized (object) {
            block7: {
                if (!this.closed) {
                    this.closed = true;
                    this.lock.notifyAll();
                    if (this.ioException == null && optionalException != null) {
                        this.ioException = optionalException instanceof IOException ? (IOException)optionalException : new IOException(optionalException);
                    }
                    try {
                        this.selectableChannel.close();
                    }
                    catch (IOException ioe) {
                        if (this.ioException != null) break block7;
                        this.ioException = ioe;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.lock;
        synchronized (object) {
            return this.closed;
        }
    }

    public String getDebugId() {
        return this.debugId;
    }

    public void setDebugId(String debugId) {
        this.debugId = debugId;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @NotThreadSafe
    static abstract class Builder<T extends RouplexTcpEndPoint, B extends Builder> {
        protected final RouplexTcpSelector rouplexTcpSelector;
        protected SocketAddress localAddress;
        protected int sendBufferSize;
        protected int receiveBufferSize;
        protected Object attachment;
        protected SSLContext sslContext;
        protected SelectableChannel selectableChannel;
        protected B builder;

        Builder(RouplexTcpBroker rouplexTcpBroker) {
            this.rouplexTcpSelector = rouplexTcpBroker.nextRouplexTcpSelector();
            this.builder = this;
        }

        public abstract T buildAsync() throws IOException;

        protected void checkNotBuilt() {
            if (this.builder == null) {
                throw new IllegalStateException("Already built. Create a new builder to build a new instance.");
            }
        }

        public B withLocalAddress(SocketAddress localAddress) {
            this.checkNotBuilt();
            this.localAddress = localAddress;
            return this.builder;
        }

        public B withLocalAddress(@Nullable String hostname, int port) {
            this.checkNotBuilt();
            this.localAddress = new InetSocketAddress(hostname == null ? "localhost" : hostname, port);
            return this.builder;
        }

        public B withSendBufferSize(int sendBufferSize) {
            this.checkNotBuilt();
            this.sendBufferSize = sendBufferSize > 0 ? sendBufferSize : 0;
            return this.builder;
        }

        public B withReceiveBufferSize(int receiveBufferSize) {
            this.checkNotBuilt();
            this.receiveBufferSize = receiveBufferSize > 0 ? receiveBufferSize : 0;
            return this.builder;
        }

        public B withAttachment(@Nullable Object attachment) {
            this.checkNotBuilt();
            this.attachment = attachment;
            return this.builder;
        }

        public T build() throws IOException {
            return this.build(0);
        }

        public T build(int timeoutMillis) throws IOException {
            T result = this.buildAsync();
            this.builder = null;
            ((RouplexTcpEndPoint)result).waitForOpen(timeoutMillis > 0 ? (long)timeoutMillis : Long.MAX_VALUE);
            return result;
        }
    }
}

