/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.rouplex.platform.tcp.AopConfig;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpClient;

public class RouplexTcpClientReporter {
    private static final Logger logger = Logger.getLogger(RouplexTcpClientReporter.class.getSimpleName());
    public static final String format = "%s.%s:%s::%s:%s";
    public final RouplexTcpClient rouplexTcpClient;
    public final AopInstrumentor aopInstrumentor;
    public Meter sentBytes;
    public Meter unsentBytes;
    public Meter innerSentBytes;
    public Meter sentEos;
    public Meter innerSentEos;
    public Meter sentDisconnect;
    public Meter receivedBytes;
    public Meter receivedEos;
    public Meter receivedDisconnect;
    public String aggregatedId;
    public String completeId;

    public RouplexTcpClientReporter(RouplexTcpClient rouplexTcpClient, AopInstrumentor aopInstrumentor) {
        this.rouplexTcpClient = rouplexTcpClient;
        this.aopInstrumentor = aopInstrumentor;
        try {
            String actor;
            InetSocketAddress inetSocketAddress = (InetSocketAddress)rouplexTcpClient.getLocalAddress();
            String localAddress = inetSocketAddress.getHostName();
            int localPort = inetSocketAddress.getPort();
            inetSocketAddress = (InetSocketAddress)rouplexTcpClient.getRemoteAddress();
            String remoteAddress = inetSocketAddress.getHostName();
            int remotePort = inetSocketAddress.getPort();
            AopConfig aopConfig = aopInstrumentor.aopConfig;
            String string = actor = rouplexTcpClient.getRouplexTcpServer() == null ? "RouplexTcpClient" : "RouplexTcpServer";
            this.completeId = aopConfig.useShortFormat ? (rouplexTcpClient.getRouplexTcpServer() == null ? "C:" + localPort + "->S" : "S->C:" + remotePort) : String.format(format, actor, localAddress, localPort, remoteAddress, remotePort);
            this.aggregatedId = String.format(format, actor, aopConfig.aggregateLocalAddresses ? "A" : localAddress, aopConfig.aggregateLocalPorts ? "A" : Integer.valueOf(localPort), aopConfig.aggregateRemoteAddresses ? "A" : remoteAddress, aopConfig.aggregateRemotePorts ? "A" : Integer.valueOf(remotePort));
        }
        catch (Exception exception) {
            this.completeId = "A";
            this.aggregatedId = "A";
        }
        MetricRegistry metricRegistry = aopInstrumentor.metricRegistry;
        this.sentBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"sentBytes"}));
        this.unsentBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"unsentBytes"}));
        this.innerSentBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"innerSentBytes"}));
        this.sentEos = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"sentEos"}));
        this.innerSentEos = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"innerSentEos"}));
        this.sentDisconnect = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"sentDisconnect"}));
        this.receivedBytes = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"receivedBytes"}));
        this.receivedEos = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"receivedEos"}));
        this.receivedDisconnect = metricRegistry.meter(MetricRegistry.name((String)this.aggregatedId, (String[])new String[]{"receivedDisconnect"}));
    }

    public Object reportHandleClose(ProceedingJoinPoint pjp) throws Throwable {
        Exception optionalException = (Exception)pjp.getArgs()[0];
        if (optionalException == null) {
            logger.warning(String.format("syncClose %s [graceful]", this.completeId));
        } else {
            logger.warning(String.format("syncClose %s [abrupt]. Cause: %s %s", this.completeId, optionalException.getClass().getSimpleName(), optionalException.getMessage()));
        }
        return pjp.proceed();
    }

    public Object reportThrottledSenderSend(ProceedingJoinPoint pjp) throws Throwable {
        ByteBuffer payload = (ByteBuffer)pjp.getArgs()[0];
        int payloadSize = 0;
        if (payload == null) {
            this.sentDisconnect.mark();
        } else if (!payload.hasRemaining()) {
            this.sentEos.mark();
        } else {
            payloadSize = payload.remaining();
        }
        Object result = pjp.proceed();
        if (payload == null) {
            logger.info(String.format("throttledSenderSend %s [disconnect]", this.completeId));
        } else if (payloadSize == 0) {
            logger.info(String.format("throttledSenderSend %s [eos]", this.completeId));
        } else {
            this.sentBytes.mark((long)(payloadSize - payload.remaining()));
            this.unsentBytes.mark((long)payload.remaining());
            logger.info(String.format("throttledSenderSend %s [%s bytes (%s remaining)]", this.completeId, payloadSize - payload.remaining(), payload.remaining()));
        }
        return result;
    }

    public Object reportThrottledSenderRemoveWriteBuffer(ProceedingJoinPoint pjp) throws Throwable {
        logger.info(String.format("removeWriteBuffer %s [entering]", this.completeId));
        Object result = pjp.proceed();
        logger.info(String.format("removeWriteBuffer %s [exiting]", this.completeId));
        return result;
    }

    public Object reportThrottledReceiverConsume(ProceedingJoinPoint pjp) throws Throwable {
        byte[] payload = (byte[])pjp.getArgs()[0];
        if (payload == null) {
            this.receivedDisconnect.mark();
        } else if (payload.length == 0) {
            this.receivedEos.mark();
        }
        Object result = pjp.proceed();
        if (payload == null) {
            logger.info(String.format("throttledReceiverConsume %s [disconnect]", this.completeId));
        } else if (payload.length == 0) {
            logger.info(String.format("throttledReceiverConsume %s [eos]", this.completeId));
        } else {
            this.receivedBytes.mark((long)payload.length);
            logger.info(String.format("throttledReceiverConsume %s [%s bytes]", this.completeId, payload.length));
        }
        return result;
    }

    public String getAggregatedId() {
        return this.aggregatedId;
    }
}

