/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.rouplex.commons.annotations.NotThreadSafe;
import org.rouplex.commons.annotations.Nullable;
import org.rouplex.nio.channels.SSLSocketChannel;
import org.rouplex.platform.io.Receiver;
import org.rouplex.platform.io.Sender;
import org.rouplex.platform.io.Throttle;
import org.rouplex.platform.tcp.AopInstrumentor;
import org.rouplex.platform.tcp.RouplexTcpBroker;
import org.rouplex.platform.tcp.RouplexTcpClient$ThrottledReceiver$AjcClosure1;
import org.rouplex.platform.tcp.RouplexTcpClient$ThrottledSender$AjcClosure1;
import org.rouplex.platform.tcp.RouplexTcpClient$ThrottledSender$AjcClosure3;
import org.rouplex.platform.tcp.RouplexTcpClientListener;
import org.rouplex.platform.tcp.RouplexTcpEndPoint;
import org.rouplex.platform.tcp.RouplexTcpSelector;
import org.rouplex.platform.tcp.RouplexTcpServer;

public class RouplexTcpClient
extends RouplexTcpEndPoint {
    protected static final byte[] EOS_BA = new byte[0];
    private static final ByteBuffer EOS_BB = ByteBuffer.allocate(0);
    protected final RouplexTcpServer rouplexTcpServer;
    protected final RouplexTcpClientListener rouplexTcpClientListener;
    protected final ThrottledSender throttledSender = new ThrottledSender();
    protected final ThrottledReceiver throttledReceiver = new ThrottledReceiver();
    private SelectionKey selectionKey;
    private static final TrustManager trustAll = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    void handleConnected() {
        this.handleOpen();
        if (this.rouplexTcpClientListener != null) {
            this.rouplexTcpClientListener.onConnected(this);
        }
    }

    void handleConnectionFailed(@Nullable Exception optionalReason) {
        this.setExceptionAndCloseChannel(optionalReason);
        if (this.rouplexTcpClientListener != null) {
            this.rouplexTcpClientListener.onConnectionFailed(this, this.ioException);
        }
    }

    boolean handleDisconnected(@Nullable Exception optionalReason) {
        boolean drainedChannels;
        this.setExceptionAndCloseChannel(optionalReason);
        boolean bl = drainedChannels = this.throttledReceiver.eosReceived && this.throttledSender.eosApplied;
        if (this.rouplexTcpClientListener != null) {
            this.rouplexTcpClientListener.onDisconnected(this, this.ioException, drainedChannels);
        }
        return drainedChannels;
    }

    RouplexTcpClient(Builder builder) throws IOException {
        super(builder);
        this.rouplexTcpServer = null;
        this.rouplexTcpClientListener = builder.rouplexTcpClientListener;
        SocketChannel socketChannel = (SocketChannel)this.selectableChannel;
        if (builder.sendBufferSize != 0) {
            socketChannel.socket().setSendBufferSize(builder.sendBufferSize);
        }
        if (builder.receiveBufferSize != 0) {
            socketChannel.socket().setReceiveBufferSize(builder.receiveBufferSize);
        }
        if (!socketChannel.isConnectionPending() && !socketChannel.isConnected()) {
            socketChannel.configureBlocking(false);
            socketChannel.connect(builder.remoteAddress);
        }
        this.rouplexTcpSelector.asyncRegisterTcpEndPoint(this);
    }

    RouplexTcpClient(SocketChannel socketChannel, RouplexTcpSelector rouplexTcpSelector, RouplexTcpServer rouplexTcpServer) throws IOException {
        super(socketChannel, rouplexTcpSelector);
        this.rouplexTcpServer = rouplexTcpServer;
        this.rouplexTcpClientListener = rouplexTcpServer.rouplexTcpClientListener;
        if (rouplexTcpServer.sendBufferSize != 0) {
            socketChannel.socket().setSendBufferSize(rouplexTcpServer.sendBufferSize);
        }
        if (rouplexTcpServer.receiveBufferSize != 0) {
            socketChannel.socket().setReceiveBufferSize(rouplexTcpServer.receiveBufferSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress getRemoteAddress() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new IOException("Already closed");
            }
            return ((SocketChannel)this.selectableChannel).socket().getRemoteSocketAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelectionKey(SelectionKey selectionKey) {
        Object object = this.lock;
        synchronized (object) {
            this.selectionKey = selectionKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sender<ByteBuffer> obtainSendChannel(Throttle throttle, int sendBufferSize) {
        Object object = this.lock;
        synchronized (object) {
            if (this.throttledSender.throttle != null) {
                throw new IllegalStateException("Send channel already hooked.");
            }
            if (throttle == null) {
                throw new IllegalArgumentException("Throttle cannot be null.");
            }
            if (sendBufferSize == 0) {
                try {
                    sendBufferSize = ((SocketChannel)this.selectableChannel).socket().getSendBufferSize();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.throttledSender.remaining = sendBufferSize != 0 ? (long)sendBufferSize : 65536L;
            this.throttledSender.throttle = throttle;
            return this.throttledSender;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throttle assignReceiveChannel(@Nullable Receiver<byte[]> receiver, boolean started) {
        Object object = this.lock;
        synchronized (object) {
            if (this.throttledReceiver.receiver != null) {
                throw new IllegalStateException("Receive channel already hooked.");
            }
            this.throttledReceiver.receiver = receiver;
            if (started) {
                this.throttledReceiver.resume();
            }
            return this.throttledReceiver;
        }
    }

    public RouplexTcpServer getRouplexTcpServer() {
        return this.rouplexTcpServer;
    }

    public static SSLContext buildRelaxedSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustAll}, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    class ThrottledSender
    implements Sender<ByteBuffer> {
        private final LinkedList<ByteBuffer> writeBuffers = new LinkedList();
        private long remaining;
        private Throttle throttle;
        boolean paused;
        boolean eosReceived;
        boolean eosApplied;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        ThrottledSender() {
        }

        private int transfer(ByteBuffer source, ByteBuffer destination) {
            int destRemaining;
            int srcRemaining = source.remaining();
            if (srcRemaining > (destRemaining = destination.remaining())) {
                int limit = source.limit();
                source.limit(source.position() + destRemaining);
                destination.put(source);
                source.limit(limit);
                return destRemaining;
            }
            if (source.hasRemaining()) {
                destination.put(source);
            }
            return srcRemaining;
        }

        public void send(ByteBuffer payload) throws IOException {
            ByteBuffer byteBuffer = payload;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)byteBuffer);
            Object[] objectArray = new Object[]{this, byteBuffer, joinPoint};
            AopInstrumentor.aspectOf().aroundThrottledSenderSend(new RouplexTcpClient$ThrottledSender$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ByteBuffer pollFirstWriteBuffer() {
            Object object = RouplexTcpClient.this.lock;
            synchronized (object) {
                return this.writeBuffers.isEmpty() ? null : this.writeBuffers.getFirst();
            }
        }

        int removeWriteBuffer(ByteBuffer writeBuffer) {
            ByteBuffer byteBuffer = writeBuffer;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)byteBuffer);
            Object[] objectArray = new Object[]{this, byteBuffer, joinPoint};
            return Conversions.intValue((Object)AopInstrumentor.aspectOf().aroundThrottledSenderRemoveWriteBuffer(new RouplexTcpClient$ThrottledSender$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }

        static {
            ThrottledSender.ajc$preClinit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final /* synthetic */ void send_aroundBody0(ThrottledSender ajc$this, ByteBuffer payload, JoinPoint joinPoint) {
            Object object = ajc$this.RouplexTcpClient.this.lock;
            synchronized (object) {
                if (ajc$this.eosReceived) {
                    throw new IOException("Sender is closed");
                }
                if (ajc$this.RouplexTcpClient.this.isClosed()) {
                    throw new IOException("TcpClient is closed");
                }
                if (payload == null) {
                    ajc$this.RouplexTcpClient.this.close();
                    return;
                }
                if (payload.hasRemaining()) {
                    if (ajc$this.paused) {
                        return;
                    }
                    ajc$this.paused = ajc$this.remaining < (long)payload.remaining();
                    int writeSize = (int)(ajc$this.paused ? ajc$this.remaining : (long)payload.remaining());
                    if (writeSize == 0) {
                        return;
                    }
                    ajc$this.remaining -= (long)writeSize;
                    ByteBuffer writeBuffer = ByteBuffer.allocate(writeSize);
                    ajc$this.transfer(payload, writeBuffer);
                    writeBuffer.flip();
                    ajc$this.writeBuffers.add(writeBuffer);
                } else {
                    ajc$this.eosReceived = true;
                    ajc$this.writeBuffers.add(EOS_BB);
                }
                if (ajc$this.RouplexTcpClient.this.selectionKey != null) {
                    ajc$this.RouplexTcpClient.this.rouplexTcpSelector.asyncResumeInterestOps(ajc$this.RouplexTcpClient.this.selectionKey, 4);
                }
                if (ajc$this.paused) {
                    try {
                        ajc$this.throttle.pause();
                    }
                    catch (RuntimeException re) {
                        ajc$this.RouplexTcpClient.this.close(re);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static final /* synthetic */ int removeWriteBuffer_aroundBody2(ThrottledSender ajc$this, ByteBuffer writeBuffer, JoinPoint joinPoint) {
            Throttle throttle;
            Object object = ajc$this.RouplexTcpClient.this.lock;
            synchronized (object) {
                ajc$this.writeBuffers.removeFirst();
                ajc$this.remaining += (long)writeBuffer.limit();
                if (ajc$this.paused) {
                    ajc$this.paused = false;
                    throttle = ajc$this.throttle;
                } else {
                    throttle = null;
                }
            }
            if (throttle != null) {
                throttle.resume();
            }
            ajc$this.eosApplied = writeBuffer == EOS_BB;
            return ajc$this.eosApplied && ajc$this.RouplexTcpClient.this.throttledReceiver.eosReceived ? -2 : 0;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RouplexTcpClient.java", ThrottledSender.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "send", "org.rouplex.platform.tcp.RouplexTcpClient$ThrottledSender", "java.nio.ByteBuffer", "payload", "java.io.IOException", "void"), 299);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "removeWriteBuffer", "org.rouplex.platform.tcp.RouplexTcpClient$ThrottledSender", "java.nio.ByteBuffer", "writeBuffer", "", "int"), 389);
        }
    }

    class ThrottledReceiver
    extends Throttle {
        @Nullable
        private Receiver<byte[]> receiver;
        boolean eosReceived;
        private long rateLimitCurrentTimestamp;
        private long rateLimitCurrentBytes;
        private long rateLimitBytes;
        private long rateLimitMillis;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        ThrottledReceiver() {
        }

        public void setMaxRate(long maxRate, long duration, TimeUnit timeUnit) {
            this.rateLimitBytes = maxRate;
            this.rateLimitMillis = timeUnit.toMillis(duration);
            this.resume();
        }

        public void pause() {
            RouplexTcpClient.this.rouplexTcpSelector.asyncPauseInterestOps(RouplexTcpClient.this.selectionKey, 1, 0L);
        }

        public void resume() {
            RouplexTcpClient.this.rouplexTcpSelector.asyncResumeInterestOps(RouplexTcpClient.this.selectionKey, 1);
        }

        long handleSocketInput(byte[] payload) {
            byte[] byArray = payload;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)byArray);
            Object[] objectArray = new Object[]{this, byArray, joinPoint};
            return Conversions.longValue((Object)AopInstrumentor.aspectOf().aroundThrottledReceiverConsume(new RouplexTcpClient$ThrottledReceiver$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }

        static {
            ThrottledReceiver.ajc$preClinit();
        }

        static final /* synthetic */ long handleSocketInput_aroundBody0(ThrottledReceiver ajc$this, byte[] payload, JoinPoint joinPoint) {
            long resumeTimestamp;
            long l = resumeTimestamp = ajc$this.receiver == null || ajc$this.receiver.receive((Object)payload) ? -1L : 0L;
            if (payload == null) {
                return 0L;
            }
            if (ajc$this.rateLimitCurrentTimestamp != 0L) {
                if (System.currentTimeMillis() > ajc$this.rateLimitCurrentTimestamp) {
                    ajc$this.rateLimitCurrentTimestamp = System.currentTimeMillis() + ajc$this.rateLimitMillis;
                    ajc$this.rateLimitBytes = 0L;
                } else {
                    ajc$this.rateLimitCurrentBytes += (long)payload.length;
                    if (ajc$this.rateLimitCurrentBytes > ajc$this.rateLimitBytes) {
                        resumeTimestamp = ajc$this.rateLimitCurrentTimestamp;
                    }
                }
            }
            return (ajc$this.eosReceived = payload == EOS_BA) ? (ajc$this.RouplexTcpClient.this.throttledSender.eosApplied ? -2L : 0L) : resumeTimestamp;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RouplexTcpClient.java", ThrottledReceiver.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "handleSocketInput", "org.rouplex.platform.tcp.RouplexTcpClient$ThrottledReceiver", "[B", "payload", "", "long"), 209);
        }
    }

    @NotThreadSafe
    public static class Builder
    extends RouplexTcpEndPoint.Builder<RouplexTcpClient, Builder> {
        protected SocketAddress remoteAddress;
        protected String remoteHost;
        protected int remotePort;
        protected RouplexTcpClientListener rouplexTcpClientListener;

        Builder(RouplexTcpBroker rouplexTcpBroker) {
            super(rouplexTcpBroker);
        }

        protected void checkCanBuild() {
            if (this.remoteAddress == null) {
                throw new IllegalStateException("Missing value for remoteAddress");
            }
        }

        public Builder withSocketChannel(SocketChannel socketChannel) {
            this.checkNotBuilt();
            this.selectableChannel = socketChannel;
            return (Builder)this.builder;
        }

        public Builder withRemoteAddress(SocketAddress remoteAddress) {
            this.checkNotBuilt();
            this.remoteAddress = remoteAddress;
            return (Builder)this.builder;
        }

        public Builder withRemoteAddress(String hostname, int port) {
            this.checkNotBuilt();
            this.remoteHost = hostname;
            this.remotePort = port;
            this.remoteAddress = new InetSocketAddress(hostname, port);
            return (Builder)this.builder;
        }

        public Builder withSecure(boolean secure, @Nullable SSLContext sslContext) {
            this.checkNotBuilt();
            this.sslContext = secure ? (sslContext != null ? sslContext : RouplexTcpClient.buildRelaxedSSLContext()) : null;
            return (Builder)this.builder;
        }

        public Builder withRouplexTcpClientListener(RouplexTcpClientListener rouplexTcpClientListener) {
            this.checkNotBuilt();
            this.rouplexTcpClientListener = rouplexTcpClientListener;
            return (Builder)this.builder;
        }

        @Override
        public RouplexTcpClient buildAsync() throws IOException {
            this.checkNotBuilt();
            this.checkCanBuild();
            if (this.selectableChannel == null) {
                this.selectableChannel = this.sslContext == null ? SocketChannel.open() : SSLSocketChannel.open((SSLContext)this.sslContext, (String)this.remoteHost, (int)this.remotePort, (boolean)true, null, null);
            }
            return new RouplexTcpClient(this);
        }
    }
}

