/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.atomic.AtomicInteger;
import org.rouplex.platform.tcp.RouplexTcpClient;
import org.rouplex.platform.tcp.RouplexTcpSelector;
import org.rouplex.platform.tcp.RouplexTcpServer;

public class RouplexTcpBroker
implements Closeable {
    private final RouplexTcpSelector[] tcpSelectors;
    private final AtomicInteger tcpSelectorIndex = new AtomicInteger();
    private boolean closed;

    public RouplexTcpBroker(SelectorProvider selectorProvider) throws IOException {
        this(selectorProvider, 0x100000);
    }

    public RouplexTcpBroker(SelectorProvider selectorProvider, int readBufferSize) throws IOException {
        if (readBufferSize <= 0) {
            throw new IllegalArgumentException("Read buffer size must be positive");
        }
        this.tcpSelectors = new RouplexTcpSelector[Runtime.getRuntime().availableProcessors()];
        for (int index = 0; index < this.tcpSelectors.length; ++index) {
            this.tcpSelectors[index] = new RouplexTcpSelector(this, selectorProvider.openSelector(), readBufferSize);
            Thread thread = new Thread(this.tcpSelectors[index]);
            thread.setDaemon(true);
            thread.setName("RouplexTcpBroker-" + this.hashCode() + "-" + this.tcpSelectorIndex.incrementAndGet());
            thread.start();
        }
    }

    public RouplexTcpClient.Builder newRouplexTcpClientBuilder() {
        return new RouplexTcpClient.Builder(this);
    }

    public RouplexTcpServer.Builder newRouplexTcpServerBuilder() {
        return new RouplexTcpServer.Builder(this);
    }

    RouplexTcpSelector nextRouplexTcpSelector() {
        return this.tcpSelectors[this.tcpSelectorIndex.getAndIncrement() % this.tcpSelectors.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RouplexTcpSelector[] rouplexTcpSelectorArray = this;
        synchronized (this) {
            if (this.closed) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.closed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (RouplexTcpSelector tcpSelector : this.tcpSelectors) {
                tcpSelector.requestClose();
            }
            return;
        }
    }
}

