/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.platform.tcp;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.rouplex.platform.tcp.AopConfig;
import org.rouplex.platform.tcp.RouplexTcpClient;
import org.rouplex.platform.tcp.RouplexTcpClientReporter;
import org.rouplex.platform.tcp.RouplexTcpSelector;
import org.rouplex.platform.tcp.RouplexTcpSelectorReporter;

@Aspect
public class AopInstrumentor {
    static Field throttledSenderField;
    static Field throttledReceiverField;
    public final AopConfig aopConfig = AopConfig.shortFormat();
    public final MetricRegistry metricRegistry = new MetricRegistry();
    public final ConcurrentMap<RouplexTcpSelector, RouplexTcpSelectorReporter> tcpSelectors = new ConcurrentHashMap<RouplexTcpSelector, RouplexTcpSelectorReporter>();
    public final ConcurrentMap<RouplexTcpClient, RouplexTcpClientReporter> tcpClients = new ConcurrentHashMap<RouplexTcpClient, RouplexTcpClientReporter>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ AopInstrumentor ajc$perSingletonInstance;

    static {
        try {
            throttledSenderField = RouplexTcpClient.ThrottledSender.class.getDeclaredField("this$0");
            throttledSenderField.setAccessible(true);
            throttledReceiverField = RouplexTcpClient.ThrottledReceiver.class.getDeclaredField("this$0");
            throttledReceiverField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not initialize class. Cause: %s %s", e.getClass().getSimpleName(), e.getMessage()));
        }
        try {
            AopInstrumentor.ajc$perSingletonInstance = new AopInstrumentor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    RouplexTcpSelectorReporter getRouplexTcpSelectorReporter(ProceedingJoinPoint pjp) {
        RouplexTcpSelector tcpSelector = (RouplexTcpSelector)pjp.getThis();
        RouplexTcpSelectorReporter tcpSelectorReporter = (RouplexTcpSelectorReporter)this.tcpSelectors.get(tcpSelector);
        if (tcpSelectorReporter == null) {
            this.tcpSelectors.putIfAbsent(tcpSelector, new RouplexTcpSelectorReporter(tcpSelector, this));
            tcpSelectorReporter = (RouplexTcpSelectorReporter)this.tcpSelectors.get(tcpSelector);
        }
        return tcpSelectorReporter;
    }

    RouplexTcpClientReporter getRouplexTcpClientReporterOfSender(ProceedingJoinPoint pjp) throws Exception {
        RouplexTcpClient.ThrottledSender throttledSender = (RouplexTcpClient.ThrottledSender)pjp.getThis();
        return this.getRouplexTcpClientReporter((RouplexTcpClient)throttledSenderField.get(throttledSender));
    }

    RouplexTcpClientReporter getRouplexTcpClientReporterOfReceiver(ProceedingJoinPoint pjp) throws Exception {
        RouplexTcpClient.ThrottledReceiver throttledReceiver = (RouplexTcpClient.ThrottledReceiver)((Object)pjp.getThis());
        return this.getRouplexTcpClientReporter((RouplexTcpClient)throttledReceiverField.get((Object)throttledReceiver));
    }

    RouplexTcpClientReporter getRouplexTcpClientReporter(ProceedingJoinPoint pjp) throws Exception {
        return this.getRouplexTcpClientReporter((RouplexTcpClient)pjp.getThis());
    }

    private RouplexTcpClientReporter getRouplexTcpClientReporter(RouplexTcpClient tcpClient) {
        RouplexTcpClientReporter tcpClientReporter = (RouplexTcpClientReporter)this.tcpClients.get(tcpClient);
        if (tcpClientReporter == null) {
            this.tcpClients.putIfAbsent(tcpClient, new RouplexTcpClientReporter(tcpClient, this));
            tcpClientReporter = (RouplexTcpClientReporter)this.tcpClients.get(tcpClient);
        }
        return tcpClientReporter;
    }

    AopInstrumentor() {
        JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build().start();
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpSelector.handleSelectedKeyException(..))")
    public Object aroundHandleSelectedKeyException(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpSelectorReporter(pjp).reportHandleSelectedKeyException(pjp);
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpSelector.handleSelectException(..))")
    public Object aroundHandleSelectException(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpSelectorReporter(pjp).reportHandleSelectException(pjp);
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpSelector.handleSelectedKey(..))")
    public Object aroundHandleSelectedKey(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpSelectorReporter(pjp).reportHandleSelectedKey(pjp);
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpClient.ThrottledSender.send(..))")
    public Object aroundThrottledSenderSend(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpClientReporterOfSender(pjp).reportThrottledSenderSend(pjp);
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpClient.ThrottledSender.removeWriteBuffer(..))")
    public Object aroundThrottledSenderRemoveWriteBuffer(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpClientReporterOfSender(pjp).reportThrottledSenderRemoveWriteBuffer(pjp);
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpClient.ThrottledReceiver.handleSocketInput(..))")
    public Object aroundThrottledReceiverConsume(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpClientReporterOfReceiver(pjp).reportThrottledReceiverConsume(pjp);
    }

    @Around(value="execution(* org.rouplex.platform.tcp.RouplexTcpEndPoint.syncClose(..))")
    public Object aroundHandleClose(ProceedingJoinPoint pjp) throws Throwable {
        return this.getRouplexTcpClientReporter(pjp).reportHandleClose(pjp);
    }

    static String getStackTrace(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(baos));
        return new String(baos.toByteArray());
    }

    public static AopInstrumentor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.rouplex.platform.tcp.AopInstrumentor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

