/*
 * Decompiled with CFR 0.152.
 */
package org.rouplex.service.deployment;

import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.rouplex.service.deployment.Cluster;
import org.rouplex.service.deployment.CreateDeploymentRequest;
import org.rouplex.service.deployment.CreateEc2ClusterRequest;
import org.rouplex.service.deployment.CreateEc2ClusterResponse;
import org.rouplex.service.deployment.Deployment;
import org.rouplex.service.deployment.Ec2Cluster;
import org.rouplex.service.deployment.Host;

@Path(value="/deployment")
public interface DeploymentService {
    @PUT
    @Path(value="/deployments/{deploymentId}")
    public void createDeployment(@PathParam(value="deploymentId") String var1, CreateDeploymentRequest var2) throws Exception;

    @GET
    @Path(value="/deployments")
    public Set<String> listDeploymentIds() throws Exception;

    @GET
    @Path(value="/deployments/{deploymentId}")
    public Deployment getDeployment(@PathParam(value="deploymentId") String var1) throws Exception;

    @DELETE
    @Path(value="/deployments/{deploymentId}")
    public void destroyDeployment(@PathParam(value="deploymentId") String var1) throws Exception;

    @GET
    @Path(value="/deployments/{deploymentId}/clusters/{clusterId}")
    public Cluster<? extends Host> getCluster(@PathParam(value="deploymentId") String var1, @PathParam(value="clusterId") String var2) throws Exception;

    @POST
    @Path(value="/deployments/{deploymentId}/ec2/clusters")
    public CreateEc2ClusterResponse createEc2Cluster(@PathParam(value="deploymentId") String var1, CreateEc2ClusterRequest var2) throws Exception;

    @GET
    @Path(value="/deployments/{deploymentId}/ec2/clusters")
    public Set<String> listEc2ClusterIds(@PathParam(value="deploymentId") String var1) throws Exception;

    @GET
    @Path(value="/deployments/{deploymentId}/ec2/clusters/{clusterId}")
    public Ec2Cluster getEc2Cluster(@PathParam(value="deploymentId") String var1, @PathParam(value="clusterId") String var2) throws Exception;

    @DELETE
    @Path(value="/deployments/{deploymentId}/ec2/clusters/{clusterId}")
    public void destroyEc2Cluster(@PathParam(value="deploymentId") String var1, @PathParam(value="clusterId") String var2) throws Exception;
}

