/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rooftop.netx.api.SagaException;
import org.rooftop.netx.core.Codec;
import org.rooftop.netx.engine.AbstractSagaManager;
import org.rooftop.netx.engine.SagaIdGenerator;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.engine.core.SagaState;
import org.rooftop.netx.redis.RedisStreamSagaManager;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000bH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rooftop/netx/redis/RedisStreamSagaManager;", "Lorg/rooftop/netx/engine/AbstractSagaManager;", "codec", "Lorg/rooftop/netx/core/Codec;", "nodeName", "", "sagaIdGenerator", "Lorg/rooftop/netx/engine/SagaIdGenerator;", "nodeGroup", "reactiveRedisTemplate", "Lorg/springframework/data/redis/core/ReactiveRedisTemplate;", "Lorg/rooftop/netx/engine/core/Saga;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/rooftop/netx/core/Codec;Ljava/lang/String;Lorg/rooftop/netx/engine/SagaIdGenerator;Ljava/lang/String;Lorg/springframework/data/redis/core/ReactiveRedisTemplate;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getAnySaga", "Lreactor/core/publisher/Mono;", "Lorg/rooftop/netx/engine/core/SagaState;", "id", "publishSaga", "saga", "Companion", "netx"})
public final class RedisStreamSagaManager
extends AbstractSagaManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final String DATA = "data";
    @NotNull
    private static final String STREAM_KEY = "NETX_STREAM";
    @NotNull
    private static final String STATE_KEY = "TX_STATE";

    public RedisStreamSagaManager(@NotNull Codec codec, @NotNull String nodeName, @NotNull SagaIdGenerator sagaIdGenerator, @NotNull String nodeGroup, @NotNull ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)sagaIdGenerator, (String)"sagaIdGenerator");
        Intrinsics.checkNotNullParameter((Object)nodeGroup, (String)"nodeGroup");
        Intrinsics.checkNotNullParameter(reactiveRedisTemplate, (String)"reactiveRedisTemplate");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        super(codec, nodeGroup, nodeName, sagaIdGenerator);
        this.reactiveRedisTemplate = reactiveRedisTemplate;
        this.objectMapper = objectMapper;
    }

    @Override
    @NotNull
    protected Mono<SagaState> getAnySaga(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Mono mono = this.reactiveRedisTemplate.opsForHash().get((Object)id, (Object)STATE_KEY).switchIfEmpty(Mono.error(() -> RedisStreamSagaManager.getAnySaga$lambda$0(id))).map(arg_0 -> RedisStreamSagaManager.getAnySaga$lambda$1(getAnySaga.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @Override
    @NotNull
    protected Mono<String> publishSaga(@NotNull String id, @NotNull Saga saga2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)saga2, (String)"saga");
        Mono mono = this.reactiveRedisTemplate.opsForHash().putAll((Object)id, MapsKt.mapOf((Pair)TuplesKt.to((Object)STATE_KEY, (Object)saga2.getState().name()))).map(arg_0 -> RedisStreamSagaManager.publishSaga$lambda$2((Function1)new Function1<Boolean, String>(this, saga2){
            final /* synthetic */ RedisStreamSagaManager this$0;
            final /* synthetic */ Saga $saga;
            {
                this.this$0 = $receiver;
                this.$saga = $saga;
                super(1);
            }

            public final String invoke(Boolean it) {
                return RedisStreamSagaManager.access$getObjectMapper$p(this.this$0).writeValueAsString((Object)this.$saga);
            }
        }, arg_0)).flatMap(arg_0 -> RedisStreamSagaManager.publishSaga$lambda$3((Function1)new Function1<String, Mono<? extends RecordId>>(this){
            final /* synthetic */ RedisStreamSagaManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends RecordId> invoke(String it) {
                return RedisStreamSagaManager.access$getReactiveRedisTemplate$p(this.this$0).opsForStream().add((Record)Record.of((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"data", (Object)it))).withStreamKey((Object)"NETX_STREAM"));
            }
        }, arg_0)).map(arg_0 -> RedisStreamSagaManager.publishSaga$lambda$4((Function1)new Function1<RecordId, String>(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            public final String invoke(RecordId it) {
                return this.$id;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final Throwable getAnySaga$lambda$0(String $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        throw new SagaException("Cannot find exists saga by id \"" + $id + "\"");
    }

    private static final SagaState getAnySaga$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SagaState)((Object)$tmp0.invoke(p0));
    }

    private static final String publishSaga$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Mono publishSaga$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final String publishSaga$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(RedisStreamSagaManager $this) {
        return $this.objectMapper;
    }

    public static final /* synthetic */ ReactiveRedisTemplate access$getReactiveRedisTemplate$p(RedisStreamSagaManager $this) {
        return $this.reactiveRedisTemplate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/rooftop/netx/redis/RedisStreamSagaManager$Companion;", "", "()V", "DATA", "", "STATE_KEY", "STREAM_KEY", "netx"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

