/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.redis;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.rooftop.netx.engine.AbstractSagaDispatcher;
import org.rooftop.netx.engine.AbstractSagaListener;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.engine.logging.LoggingSupportsKt;
import org.rooftop.netx.redis.RedisStreamSagaListener;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.stream.StreamReceiver;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u0018H\u0002J\u001a\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\u001a0\u0018H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00f7\u0001\u0010\u0011\u001a\u00ea\u0001\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012`\u0012^\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t \u0013*.\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0018\u00010\u00140\u0014 \u0013*t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012`\u0012^\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t \u0013*.\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0018\u00010\u00140\u0014\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00f7\u0001\u0010\u0015\u001a\u00ea\u0001\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012`\u0012^\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t \u0013*.\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0018\u00010\u00140\u0014 \u0013*t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012`\u0012^\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t \u0013*.\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\t0\t\u0018\u00010\u00140\u0014\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/rooftop/netx/redis/RedisStreamSagaListener;", "Lorg/rooftop/netx/engine/AbstractSagaListener;", "backpressureSize", "", "sagaDispatcher", "Lorg/rooftop/netx/engine/AbstractSagaDispatcher;", "connectionFactory", "Lorg/springframework/data/redis/connection/ReactiveRedisConnectionFactory;", "nodeGroup", "", "nodeName", "reactiveRedisTemplate", "Lorg/springframework/data/redis/core/ReactiveRedisTemplate;", "Lorg/rooftop/netx/engine/core/Saga;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(ILorg/rooftop/netx/engine/AbstractSagaDispatcher;Lorg/springframework/data/redis/connection/ReactiveRedisConnectionFactory;Ljava/lang/String;Ljava/lang/String;Lorg/springframework/data/redis/core/ReactiveRedisTemplate;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "options", "Lorg/springframework/data/redis/stream/StreamReceiver$StreamReceiverOptions;", "kotlin.jvm.PlatformType", "Lorg/springframework/data/redis/connection/stream/MapRecord;", "receiver", "Lorg/springframework/data/redis/stream/StreamReceiver;", "createGroupIfNotExists", "Lreactor/core/publisher/Flux;", "receive", "Lkotlin/Pair;", "shutdownCascade", "", "Companion", "netx"})
public final class RedisStreamSagaListener
extends AbstractSagaListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactiveRedisConnectionFactory connectionFactory;
    @NotNull
    private final String nodeGroup;
    @NotNull
    private final String nodeName;
    @NotNull
    private final ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate;
    @NotNull
    private final ObjectMapper objectMapper;
    private final StreamReceiver.StreamReceiverOptions<String, MapRecord<String, String, String>> options;
    private final StreamReceiver<String, MapRecord<String, String, String>> receiver;
    @NotNull
    private static final String STREAM_KEY = "NETX_STREAM";

    public RedisStreamSagaListener(int backpressureSize, @NotNull AbstractSagaDispatcher sagaDispatcher, @NotNull ReactiveRedisConnectionFactory connectionFactory, @NotNull String nodeGroup, @NotNull String nodeName, @NotNull ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)sagaDispatcher, (String)"sagaDispatcher");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        Intrinsics.checkNotNullParameter((Object)nodeGroup, (String)"nodeGroup");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter(reactiveRedisTemplate, (String)"reactiveRedisTemplate");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        super(backpressureSize, sagaDispatcher);
        this.connectionFactory = connectionFactory;
        this.nodeGroup = nodeGroup;
        this.nodeName = nodeName;
        this.reactiveRedisTemplate = reactiveRedisTemplate;
        this.objectMapper = objectMapper;
        StreamReceiver.StreamReceiverOptionsBuilder streamReceiverOptionsBuilder = StreamReceiver.StreamReceiverOptions.builder();
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS);
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        this.options = streamReceiverOptionsBuilder.pollTimeout(duration).build();
        this.receiver = StreamReceiver.create((ReactiveRedisConnectionFactory)this.connectionFactory, this.options);
    }

    @Override
    @NotNull
    protected Flux<Pair<Saga, String>> receive() {
        Flux flux = this.createGroupIfNotExists().flatMap(arg_0 -> RedisStreamSagaListener.receive$lambda$0((Function1)new Function1<String, Publisher<? extends Pair<? extends Saga, ? extends String>>>(this){
            final /* synthetic */ RedisStreamSagaListener this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends Pair<Saga, String>> invoke(String it) {
                return (Publisher)RedisStreamSagaListener.access$getReceiver$p(this.this$0).receive(Consumer.from((String)RedisStreamSagaListener.access$getNodeGroup$p(this.this$0), (String)RedisStreamSagaListener.access$getNodeName$p(this.this$0)), StreamOffset.create((Object)"NETX_STREAM", (ReadOffset)ReadOffset.from((String)">"))).map(arg_0 -> receive.1.invoke$lambda$0((Function1)new Function1<MapRecord<String, String, String>, Pair<? extends Saga, ? extends String>>(this.this$0){
                    final /* synthetic */ RedisStreamSagaListener this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Pair<Saga, String> invoke(MapRecord<String, String, String> it) {
                        return TuplesKt.to((Object)RedisStreamSagaListener.access$getObjectMapper$p(this.this$0).readValue((String)((Map)it.getValue()).get("data"), Saga.class), (Object)it.getId().getValue());
                    }
                }, arg_0));
            }

            private static final Pair invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Pair)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMap(...)");
        return flux;
    }

    private final Flux<String> createGroupIfNotExists() {
        Mono mono = this.reactiveRedisTemplate.opsForStream().createGroup((Object)STREAM_KEY, ReadOffset.from((String)"0"), this.nodeGroup);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"createGroup(...)");
        Flux flux = LoggingSupportsKt.info(mono, "Redis stream group created key \"NETX_STREAM\" group \"" + this.nodeGroup + "\"").onErrorResume(arg_0 -> RedisStreamSagaListener.createGroupIfNotExists$lambda$1(createGroupIfNotExists.1.INSTANCE, arg_0)).flatMapMany(arg_0 -> RedisStreamSagaListener.createGroupIfNotExists$lambda$2(createGroupIfNotExists.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"flatMapMany(...)");
        return flux;
    }

    @Override
    protected void shutdownCascade() {
        this.connectionFactory.getReactiveConnection().close();
    }

    private static final Publisher receive$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono createGroupIfNotExists$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Publisher createGroupIfNotExists$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ StreamReceiver access$getReceiver$p(RedisStreamSagaListener $this) {
        return $this.receiver;
    }

    public static final /* synthetic */ String access$getNodeGroup$p(RedisStreamSagaListener $this) {
        return $this.nodeGroup;
    }

    public static final /* synthetic */ String access$getNodeName$p(RedisStreamSagaListener $this) {
        return $this.nodeName;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(RedisStreamSagaListener $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/rooftop/netx/redis/RedisStreamSagaListener$Companion;", "", "()V", "STREAM_KEY", "", "netx"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

