/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.redis;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.rooftop.netx.api.FailedAckSagaException;
import org.rooftop.netx.api.SagaManager;
import org.rooftop.netx.core.Codec;
import org.rooftop.netx.engine.AbstractSagaDispatcher;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.meta.SagaHandler;
import org.rooftop.netx.redis.RedisStreamSagaDispatcher;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\nH\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/rooftop/netx/redis/RedisStreamSagaDispatcher;", "Lorg/rooftop/netx/engine/AbstractSagaDispatcher;", "codec", "Lorg/rooftop/netx/core/Codec;", "sagaManager", "Lorg/rooftop/netx/api/SagaManager;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "reactiveRedisTemplate", "Lorg/springframework/data/redis/core/ReactiveRedisTemplate;", "", "Lorg/rooftop/netx/engine/core/Saga;", "nodeGroup", "(Lorg/rooftop/netx/core/Codec;Lorg/rooftop/netx/api/SagaManager;Lorg/springframework/context/ApplicationContext;Lorg/springframework/data/redis/core/ReactiveRedisTemplate;Ljava/lang/String;)V", "ack", "Lreactor/core/publisher/Mono;", "Lkotlin/Pair;", "saga", "messageId", "findHandlers", "", "", "Companion", "netx"})
public final class RedisStreamSagaDispatcher
extends AbstractSagaDispatcher {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate;
    @NotNull
    private final String nodeGroup;
    @NotNull
    private static final String STREAM_KEY = "NETX_STREAM";

    public RedisStreamSagaDispatcher(@NotNull Codec codec, @NotNull SagaManager sagaManager, @NotNull ApplicationContext applicationContext, @NotNull ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate, @NotNull String nodeGroup) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)sagaManager, (String)"sagaManager");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter(reactiveRedisTemplate, (String)"reactiveRedisTemplate");
        Intrinsics.checkNotNullParameter((Object)nodeGroup, (String)"nodeGroup");
        super(codec, sagaManager);
        this.applicationContext = applicationContext;
        this.reactiveRedisTemplate = reactiveRedisTemplate;
        this.nodeGroup = nodeGroup;
    }

    @Override
    @NotNull
    protected List<Object> findHandlers() {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.applicationContext.getBeansWithAnnotation(SagaHandler.class).entrySet()), (Function1)findHandlers.1.INSTANCE));
    }

    @Override
    @NotNull
    protected Mono<Pair<Saga, String>> ack(@NotNull Saga saga2, @NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)saga2, (String)"saga");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        String[] stringArray = new String[]{messageId};
        Mono mono = this.reactiveRedisTemplate.opsForStream().acknowledge((Object)STREAM_KEY, this.nodeGroup, stringArray).map(arg_0 -> RedisStreamSagaDispatcher.ack$lambda$0((Function1)new Function1<Long, Pair<? extends Saga, ? extends String>>(saga2, messageId){
            final /* synthetic */ Saga $saga;
            final /* synthetic */ String $messageId;
            {
                this.$saga = $saga;
                this.$messageId = $messageId;
                super(1);
            }

            public final Pair<Saga, String> invoke(Long it) {
                return TuplesKt.to((Object)this.$saga, (Object)this.$messageId);
            }
        }, arg_0)).switchIfEmpty(Mono.error(() -> RedisStreamSagaDispatcher.ack$lambda$1(saga2, messageId)));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"switchIfEmpty(...)");
        return mono;
    }

    private static final Pair ack$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0);
    }

    private static final Throwable ack$lambda$1(Saga $saga, String $messageId) {
        Intrinsics.checkNotNullParameter((Object)$saga, (String)"$saga");
        Intrinsics.checkNotNullParameter((Object)$messageId, (String)"$messageId");
        throw new FailedAckSagaException("Fail to ack saga id \"" + $saga.getId() + "\" messageId \"" + $messageId + "\"");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/rooftop/netx/redis/RedisStreamSagaDispatcher$Companion;", "", "()V", "STREAM_KEY", "", "netx"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

