/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.redis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rooftop.netx.api.OrchestratorFactory;
import org.rooftop.netx.api.SagaManager;
import org.rooftop.netx.engine.AbstractSagaRetrySupporter;
import org.rooftop.netx.engine.JsonCodec;
import org.rooftop.netx.engine.RequestHolder;
import org.rooftop.netx.engine.ResultHolder;
import org.rooftop.netx.engine.SagaIdGenerator;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.engine.logging.LoggerFactory;
import org.rooftop.netx.engine.logging.LoggingSupportsKt;
import org.rooftop.netx.redis.RedisRequestHolder;
import org.rooftop.netx.redis.RedisResultHolder;
import org.rooftop.netx.redis.RedisSagaRetrySupporter;
import org.rooftop.netx.redis.RedisStreamSagaDispatcher;
import org.rooftop.netx.redis.RedisStreamSagaListener;
import org.rooftop.netx.redis.RedisStreamSagaManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B{\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\u0003\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\u000b\u0012\b\b\u0001\u0010\r\u001a\u00020\b\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0014H\u0011\u00a2\u0006\u0002\b\u0015J\r\u0010\u0016\u001a\u00020\u0017H\u0011\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0011\u00a2\u0006\u0002\b\u001bJ\u0019\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001dH\u0011\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020 H\u0011\u00a2\u0006\u0002\b!J\r\u0010\"\u001a\u00020#H\u0011\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020&H\u0011\u00a2\u0006\u0002\b'J\r\u0010(\u001a\u00020)H\u0011\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020,H\u0011\u00a2\u0006\u0002\b-J\r\u0010.\u001a\u00020/H\u0011\u00a2\u0006\u0002\b0J\r\u00101\u001a\u000202H\u0011\u00a2\u0006\u0002\b3J\u0019\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002050\u001dH\u0011\u00a2\u0006\u0002\b6J\r\u00107\u001a\u000208H\u0011\u00a2\u0006\u0002\b9R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/rooftop/netx/redis/RedisSagaConfigurer;", "", "host", "", "port", "password", "nodeGroup", "nodeId", "", "nodeName", "recoveryMilli", "", "orphanMilli", "backpressureSize", "loggingLevel", "poolSize", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;JJILjava/lang/String;ILorg/springframework/context/ApplicationContext;)V", "jsonCodec", "Lorg/rooftop/netx/engine/JsonCodec;", "jsonCodec$netx", "netxObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "netxObjectMapper$netx", "reactiveRedisConnectionFactory", "Lorg/springframework/data/redis/connection/ReactiveRedisConnectionFactory;", "reactiveRedisConnectionFactory$netx", "reactiveRedisTemplate", "Lorg/springframework/data/redis/core/ReactiveRedisTemplate;", "reactiveRedisTemplate$netx", "redisRequestHolder", "Lorg/rooftop/netx/engine/RequestHolder;", "redisRequestHolder$netx", "redisResultHolder", "Lorg/rooftop/netx/engine/ResultHolder;", "redisResultHolder$netx", "redisSagaRetrySupporter", "Lorg/rooftop/netx/redis/RedisSagaRetrySupporter;", "redisSagaRetrySupporter$netx", "redisStreamOrchestratorFactory", "Lorg/rooftop/netx/engine/OrchestratorFactory;", "redisStreamOrchestratorFactory$netx", "redisStreamSagaDispatcher", "Lorg/rooftop/netx/redis/RedisStreamSagaDispatcher;", "redisStreamSagaDispatcher$netx", "redisStreamSagaListener", "Lorg/rooftop/netx/redis/RedisStreamSagaListener;", "redisStreamSagaListener$netx", "redisStreamSagaManager", "Lorg/rooftop/netx/api/SagaManager;", "redisStreamSagaManager$netx", "sagaReactiveRedisTemplate", "Lorg/rooftop/netx/engine/core/Saga;", "sagaReactiveRedisTemplate$netx", "tsidSagaIdGenerator", "Lorg/rooftop/netx/engine/SagaIdGenerator;", "tsidSagaIdGenerator$netx", "netx"})
@SourceDebugExtension(value={"SMAP\nRedisSagaConfigurer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisSagaConfigurer.kt\norg/rooftop/netx/redis/RedisSagaConfigurer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1#2:203\n*E\n"})
public class RedisSagaConfigurer {
    @NotNull
    private final String host;
    @NotNull
    private final String port;
    @NotNull
    private final String password;
    @NotNull
    private final String nodeGroup;
    private final int nodeId;
    @NotNull
    private final String nodeName;
    private final long recoveryMilli;
    private final long orphanMilli;
    private final int backpressureSize;
    private final int poolSize;
    @NotNull
    private final ApplicationContext applicationContext;

    public RedisSagaConfigurer(@Value(value="${netx.host}") @NotNull String host, @Value(value="${netx.port}") @NotNull String port, @Value(value="${netx.password:0000}") @NotNull String password, @Value(value="${netx.group}") @NotNull String nodeGroup, @Value(value="${netx.node-id}") int nodeId, @Value(value="${netx.node-name}") @NotNull String nodeName, @Value(value="${netx.recovery-milli:1000}") long recoveryMilli, @Value(value="${netx.orphan-milli:60000}") long orphanMilli, @Value(value="${netx.backpressure:40}") int backpressureSize, @Value(value="${netx.logging.level:off}") @NotNull String loggingLevel, @Value(value="${netx.pool-size:10}") int poolSize, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)nodeGroup, (String)"nodeGroup");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)loggingLevel, (String)"loggingLevel");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.host = host;
        this.port = port;
        this.password = password;
        this.nodeGroup = nodeGroup;
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.recoveryMilli = recoveryMilli;
        this.orphanMilli = orphanMilli;
        this.backpressureSize = backpressureSize;
        this.poolSize = poolSize;
        this.applicationContext = applicationContext;
        LoggingSupportsKt.setLogger((Logger)LoggerFactory.INSTANCE.getLogger$netx(loggingLevel));
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public org.rooftop.netx.engine.OrchestratorFactory redisStreamOrchestratorFactory$netx() {
        org.rooftop.netx.engine.OrchestratorFactory orchestratorFactory;
        org.rooftop.netx.engine.OrchestratorFactory $this$redisStreamOrchestratorFactory_u24lambda_u240 = orchestratorFactory = new org.rooftop.netx.engine.OrchestratorFactory(this.redisStreamSagaManager$netx(), this.redisStreamSagaDispatcher$netx(), this.jsonCodec$netx(), this.redisResultHolder$netx(), this.redisRequestHolder$netx());
        boolean bl = false;
        OrchestratorFactory.Instance.setOrchestratorFactory$netx($this$redisStreamOrchestratorFactory_u24lambda_u240);
        return orchestratorFactory;
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public SagaManager redisStreamSagaManager$netx() {
        Object object = this.nodeName;
        String string = this.nodeGroup;
        ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate = this.sagaReactiveRedisTemplate$netx();
        JsonCodec jsonCodec = this.jsonCodec$netx();
        SagaIdGenerator sagaIdGenerator = this.tsidSagaIdGenerator$netx();
        ObjectMapper objectMapper = this.netxObjectMapper$netx();
        Object it = object = new RedisStreamSagaManager(jsonCodec, (String)object, sagaIdGenerator, string, reactiveRedisTemplate, objectMapper);
        boolean bl = false;
        LoggingSupportsKt.info("RedisStreamSagaManager connect to host : \"" + this.host + "\" port : \"" + this.port + "\" nodeName : \"" + this.nodeName + "\" nodeGroup : \"" + this.nodeGroup + "\"");
        return (SagaManager)object;
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public SagaIdGenerator tsidSagaIdGenerator$netx() {
        return new SagaIdGenerator(this.nodeId, null, 2, null);
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public RedisStreamSagaListener redisStreamSagaListener$netx() {
        RedisStreamSagaListener redisStreamSagaListener;
        RedisStreamSagaListener it = redisStreamSagaListener = new RedisStreamSagaListener(this.backpressureSize, this.redisStreamSagaDispatcher$netx(), this.reactiveRedisConnectionFactory$netx(), this.nodeGroup, this.nodeName, this.sagaReactiveRedisTemplate$netx(), this.netxObjectMapper$netx());
        boolean bl = false;
        LoggingSupportsKt.info("RedisStreamSagaListener connect to host : \"" + this.host + "\" port : \"" + this.port + "\" nodeName : \"" + this.nodeName + "\" nodeGroup : \"" + this.nodeGroup + "\" backpressureSize : \"" + this.backpressureSize + "\"");
        it.subscribeStream();
        return redisStreamSagaListener;
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public ResultHolder redisResultHolder$netx() {
        return new RedisResultHolder(this.poolSize, this.jsonCodec$netx(), this.netxObjectMapper$netx(), this.reactiveRedisTemplate$netx());
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public RequestHolder redisRequestHolder$netx() {
        return new RedisRequestHolder(this.jsonCodec$netx(), this.reactiveRedisTemplate$netx());
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public JsonCodec jsonCodec$netx() {
        return new JsonCodec(this.netxObjectMapper$netx());
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public ObjectMapper netxObjectMapper$netx() {
        ObjectMapper objectMapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).registerModule((Module)new ParameterNamesModule(JsonCreator.Mode.PROPERTIES)).registerModule((Module)new KotlinModule.Builder().build()).registerModule((Module)new JavaTimeModule());
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"registerModule(...)");
        return objectMapper;
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public RedisSagaRetrySupporter redisSagaRetrySupporter$netx() {
        Object object = this.nodeGroup;
        String string = this.nodeName;
        ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate = this.sagaReactiveRedisTemplate$netx();
        RedisStreamSagaDispatcher redisStreamSagaDispatcher = this.redisStreamSagaDispatcher$netx();
        long l = this.orphanMilli;
        long l2 = this.recoveryMilli;
        int n = this.backpressureSize;
        ObjectMapper objectMapper = this.netxObjectMapper$netx();
        Object it = object = new RedisSagaRetrySupporter(l2, n, redisStreamSagaDispatcher, (String)object, string, reactiveRedisTemplate, l, objectMapper);
        boolean bl = false;
        LoggingSupportsKt.info("RedisSagaRetrySupporter connect to host : \"" + this.host + "\" port : \"" + this.port + "\" nodeName : \"" + this.nodeName + "\" nodeGroup : \"" + this.nodeGroup + "\" orphanMilli : \"" + this.orphanMilli + "\" recoveryMilli : \"" + this.recoveryMilli + "\" backpressureSize : \"" + this.backpressureSize + "\"");
        ((AbstractSagaRetrySupporter)it).watchOrphanSaga();
        return object;
    }

    @Bean
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public RedisStreamSagaDispatcher redisStreamSagaDispatcher$netx() {
        Object object = this.applicationContext;
        ReactiveRedisTemplate<String, Saga> reactiveRedisTemplate = this.sagaReactiveRedisTemplate$netx();
        String string = this.nodeGroup;
        JsonCodec jsonCodec = this.jsonCodec$netx();
        SagaManager sagaManager = this.redisStreamSagaManager$netx();
        Object it = object = new RedisStreamSagaDispatcher(jsonCodec, sagaManager, (ApplicationContext)object, reactiveRedisTemplate, string);
        boolean bl = false;
        LoggingSupportsKt.info("RedisStreamSagaDispatcher connect to host : \"" + this.host + "\" port : \"" + this.port + "\" nodeName : \"" + this.nodeName + "\" nodeGroup : \"" + this.nodeGroup + "\"");
        return object;
    }

    @Bean
    @Primary
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public ReactiveRedisTemplate<String, Saga> sagaReactiveRedisTemplate$netx() {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        Jackson2JsonRedisSerializer valueSerializer = new Jackson2JsonRedisSerializer(this.netxObjectMapper$netx(), Saga.class);
        RedisSerializationContext.RedisSerializationContextBuilder redisSerializationContextBuilder = RedisSerializationContext.newSerializationContext((RedisSerializer)((RedisSerializer)keySerializer));
        Intrinsics.checkNotNullExpressionValue((Object)redisSerializationContextBuilder, (String)"newSerializationContext(...)");
        RedisSerializationContext.RedisSerializationContextBuilder builder = redisSerializationContextBuilder;
        RedisSerializationContext context2 = builder.value((RedisSerializer)valueSerializer).build();
        return new ReactiveRedisTemplate(this.reactiveRedisConnectionFactory$netx(), context2);
    }

    @Bean
    @Primary
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public ReactiveRedisTemplate<String, String> reactiveRedisTemplate$netx() {
        StringRedisSerializer keySerializer = new StringRedisSerializer();
        StringRedisSerializer valueSerializer = new StringRedisSerializer();
        RedisSerializationContext.RedisSerializationContextBuilder redisSerializationContextBuilder = RedisSerializationContext.newSerializationContext((RedisSerializer)((RedisSerializer)keySerializer));
        Intrinsics.checkNotNullExpressionValue((Object)redisSerializationContextBuilder, (String)"newSerializationContext(...)");
        RedisSerializationContext.RedisSerializationContextBuilder builder = redisSerializationContextBuilder;
        RedisSerializationContext context2 = builder.value((RedisSerializer)valueSerializer).build();
        return new ReactiveRedisTemplate(this.reactiveRedisConnectionFactory$netx(), context2);
    }

    @Bean
    @Primary
    @ConditionalOnProperty(prefix="netx", name={"mode"}, havingValue="redis")
    @NotNull
    public ReactiveRedisConnectionFactory reactiveRedisConnectionFactory$netx() {
        String string = System.getProperty("netx.port");
        if (string == null) {
            string = this.port;
        }
        String port = string;
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.host);
        redisStandaloneConfiguration.setPort(Integer.parseInt(port));
        redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        return (ReactiveRedisConnectionFactory)new LettuceConnectionFactory(redisStandaloneConfiguration);
    }
}

