/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.redis;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.rooftop.netx.api.Result;
import org.rooftop.netx.api.ResultTimeoutException;
import org.rooftop.netx.core.Codec;
import org.rooftop.netx.engine.ResultHolder;
import org.rooftop.netx.redis.RedisResultHolder;
import org.springframework.data.redis.core.ReactiveListOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Mono;
import reactor.pool.InstrumentedPool;
import reactor.pool.PoolBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 #2\u00020\u0001:\u0002#$B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ8\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00120\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J-\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0011\"\b\b\u0000\u0010\u0013*\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001c\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u001c\u001a\u0002H\u0013H\u0016\u00a2\u0006\u0002\u0010\u001fJ\f\u0010 \u001a\u00020!*\u00020\nH\u0002J\f\u0010\"\u001a\u00020\n*\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00a3\u0001\u0010\f\u001a\u0096\u0001\u0012D\u0012B\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0018\u00010\u000e0\u000e \u000f*J\u0012D\u0012B\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n\u0018\u00010\u000e0\u000e\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006%"}, d2={"Lorg/rooftop/netx/redis/RedisResultHolder;", "Lorg/rooftop/netx/engine/ResultHolder;", "poolSize", "", "codec", "Lorg/rooftop/netx/core/Codec;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "reactiveRedisTemplate", "Lorg/springframework/data/redis/core/ReactiveRedisTemplate;", "", "(ILorg/rooftop/netx/core/Codec;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/data/redis/core/ReactiveRedisTemplate;)V", "pool", "Lreactor/pool/InstrumentedPool;", "Lorg/springframework/data/redis/core/ReactiveListOperations;", "kotlin.jvm.PlatformType", "getResult", "Lreactor/core/publisher/Mono;", "Lorg/rooftop/netx/api/Result;", "T", "", "timeout", "Lkotlin/time/Duration;", "id", "getResult-VtjQ1oo", "(JLjava/lang/String;)Lreactor/core/publisher/Mono;", "setFailResult", "", "result", "(Ljava/lang/String;Ljava/lang/Throwable;)Lreactor/core/publisher/Mono;", "setSuccessResult", "(Ljava/lang/String;Ljava/lang/Object;)Lreactor/core/publisher/Mono;", "isSuccess", "", "value", "Companion", "Error", "netx"})
public final class RedisResultHolder
implements ResultHolder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Codec codec;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ReactiveRedisTemplate<String, String> reactiveRedisTemplate;
    private final InstrumentedPool<ReactiveListOperations<String, String>> pool;
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;

    public RedisResultHolder(int poolSize, @NotNull Codec codec, @NotNull ObjectMapper objectMapper, @NotNull ReactiveRedisTemplate<String, String> reactiveRedisTemplate) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter(reactiveRedisTemplate, (String)"reactiveRedisTemplate");
        this.codec = codec;
        this.objectMapper = objectMapper;
        this.reactiveRedisTemplate = reactiveRedisTemplate;
        this.pool = PoolBuilder.from((Publisher)((Publisher)Mono.just((Object)this.reactiveRedisTemplate.opsForList()))).sizeBetween(1, poolSize).maxPendingAcquireUnbounded().buildPool();
    }

    @Override
    @NotNull
    public <T> Mono<Result<T>> getResult-VtjQ1oo(long timeout, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Mono mono = this.pool.withPoolable(arg_0 -> RedisResultHolder.getResult_VtjQ1oo$lambda$1(id, timeout, arg_0)).single().map(arg_0 -> RedisResultHolder.getResult_VtjQ1oo$lambda$2((Function1)new Function1<String, Result<T>>(this){
            final /* synthetic */ RedisResultHolder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Result<T> invoke(String result) {
                Intrinsics.checkNotNull((Object)result);
                boolean isSuccess = RedisResultHolder.access$isSuccess(this.this$0, result);
                String value = RedisResultHolder.access$value(this.this$0, result);
                if (isSuccess) {
                    return Result.Companion.success(RedisResultHolder.access$getCodec$p(this.this$0), value);
                }
                Error encodedError = (Error)RedisResultHolder.access$getObjectMapper$p(this.this$0).readValue(value, Error.class);
                boolean $i$f$jacksonTypeRef = false;
                Class type = (Class)RedisResultHolder.access$getObjectMapper$p(this.this$0).readValue(encodedError.getType(), (TypeReference)new TypeReference<Class<Throwable>>(){});
                Codec codec = RedisResultHolder.access$getCodec$p(this.this$0);
                String string = encodedError.getError();
                Intrinsics.checkNotNull((Object)type);
                return Result.Companion.fail(codec, string, (KClass<Throwable>)JvmClassMappingKt.getKotlinClass((Class)type));
            }
        }, arg_0)).doOnNext(arg_0 -> RedisResultHolder.getResult_VtjQ1oo$lambda$3(getResult.3.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    private final boolean isSuccess(String $this$isSuccess) {
        String[] stringArray = new String[]{":"};
        return Intrinsics.areEqual(StringsKt.split$default((CharSequence)$this$isSuccess, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0), (Object)"0");
    }

    private final String value(String $this$value) {
        String string = $this$value.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Override
    @NotNull
    public <T> Mono<T> setSuccessResult(@NotNull String id, @NotNull T result) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Mono mono = this.reactiveRedisTemplate.opsForList().leftPush((Object)("Netx:Result:" + id), (Object)("0:" + this.objectMapper.writeValueAsString(result))).map(arg_0 -> RedisResultHolder.setSuccessResult$lambda$4((Function1)new Function1<Long, T>(result){
            final /* synthetic */ T $result;
            {
                this.$result = $result;
                super(1);
            }

            public final T invoke(Long it) {
                return this.$result;
            }
        }, arg_0)).doOnNext(arg_0 -> RedisResultHolder.setSuccessResult$lambda$5(setSuccessResult.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    @Override
    @NotNull
    public <T extends Throwable> Mono<T> setFailResult(@NotNull String id, @NotNull T result) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = this.objectMapper.writeValueAsString(result.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        String string2 = this.objectMapper.writeValueAsString(result);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
        Error error = new Error(string, string2);
        String encodedError = this.objectMapper.writeValueAsString((Object)error);
        Mono mono = this.reactiveRedisTemplate.opsForList().leftPush((Object)("Netx:Result:" + id), (Object)("1:" + encodedError)).map(arg_0 -> RedisResultHolder.setFailResult$lambda$6((Function1)new Function1<Long, T>(result){
            final /* synthetic */ T $result;
            {
                this.$result = $result;
                super(1);
            }

            public final T invoke(Long it) {
                return this.$result;
            }
        }, arg_0)).doOnNext(arg_0 -> RedisResultHolder.setFailResult$lambda$7(setFailResult.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnNext(...)");
        return mono;
    }

    private static final Throwable getResult_VtjQ1oo$lambda$1$lambda$0(long $timeout) {
        return new ResultTimeoutException("Cannot get result in \"" + Duration.toString-impl((long)$timeout) + "\" time", new TimeoutException());
    }

    private static final Publisher getResult_VtjQ1oo$lambda$1(String $id, long $timeout, ReactiveListOperations it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        String string = "Netx:Result:" + $id;
        long l = $timeout;
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        return (Publisher)it.leftPop((Object)string, duration).switchIfEmpty(Mono.error(() -> RedisResultHolder.getResult_VtjQ1oo$lambda$1$lambda$0($timeout)));
    }

    private static final Result getResult_VtjQ1oo$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Result)$tmp0.invoke(p0);
    }

    private static final void getResult_VtjQ1oo$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Object setSuccessResult$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final void setSuccessResult$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Throwable setFailResult$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Throwable)$tmp0.invoke(p0);
    }

    private static final void setFailResult$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isSuccess(RedisResultHolder $this, String $receiver) {
        return $this.isSuccess($receiver);
    }

    public static final /* synthetic */ String access$value(RedisResultHolder $this, String $receiver) {
        return $this.value($receiver);
    }

    public static final /* synthetic */ Codec access$getCodec$p(RedisResultHolder $this) {
        return $this.codec;
    }

    public static final /* synthetic */ ObjectMapper access$getObjectMapper$p(RedisResultHolder $this) {
        return $this.objectMapper;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rooftop/netx/redis/RedisResultHolder$Companion;", "", "()V", "FAIL", "", "SUCCESS", "netx"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/rooftop/netx/redis/RedisResultHolder$Error;", "", "type", "", "error", "(Ljava/lang/String;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "netx"})
    private static final class Error {
        @NotNull
        private final String type;
        @NotNull
        private final String error;

        public Error(@NotNull String type, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.type = type;
            this.error = error;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.error;
        }

        @NotNull
        public final Error copy(@NotNull String type, @NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            return new Error(type, error);
        }

        public static /* synthetic */ Error copy$default(Error error, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = error.type;
            }
            if ((n & 2) != 0) {
                string2 = error.error;
            }
            return error.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Error(type=" + this.type + ", error=" + this.error + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.error.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)error.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.error, (Object)error.error);
        }
    }
}

