/*
 * Decompiled with CFR 0.152.
 */
package org.rooftop.netx.engine;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rooftop.netx.api.AlreadyCommittedSagaException;
import org.rooftop.netx.api.SagaException;
import org.rooftop.netx.api.SagaManager;
import org.rooftop.netx.core.Codec;
import org.rooftop.netx.engine.SagaIdGenerator;
import org.rooftop.netx.engine.core.Saga;
import org.rooftop.netx.engine.core.SagaState;
import org.rooftop.netx.engine.logging.LoggingSupportsKt;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b \u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0005J-\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J'\u0010\u0012\u001a\u00020\u0005\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\u0006\u0010\f\u001a\u00020\u0005H$J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J-\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0010J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J%\u0010\u001a\u001a\u00020\u0005\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dH$J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J5\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010 J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010\"\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J/\u0010\"\u001a\u00020\u0005\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016J#\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010'\u001a\u00020\u0005H\u0016J\u001d\u0010'\u001a\u00020\u0005\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/rooftop/netx/engine/AbstractSagaManager;", "Lorg/rooftop/netx/api/SagaManager;", "codec", "Lorg/rooftop/netx/core/Codec;", "nodeGroup", "", "nodeName", "sagaIdGenerator", "Lorg/rooftop/netx/engine/SagaIdGenerator;", "(Lorg/rooftop/netx/core/Codec;Ljava/lang/String;Ljava/lang/String;Lorg/rooftop/netx/engine/SagaIdGenerator;)V", "commit", "Lreactor/core/publisher/Mono;", "id", "T", "", "event", "(Ljava/lang/String;Ljava/lang/Object;)Lreactor/core/publisher/Mono;", "commitSaga", "commitSync", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;", "exists", "existsSync", "getAnySaga", "Lorg/rooftop/netx/engine/core/SagaState;", "join", "joinSaga", "joinSync", "publishSaga", "saga", "Lorg/rooftop/netx/engine/core/Saga;", "rollback", "cause", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Lreactor/core/publisher/Mono;", "rollbackSaga", "rollbackSync", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;", "start", "(Ljava/lang/Object;)Lreactor/core/publisher/Mono;", "startSaga", "startSync", "(Ljava/lang/Object;)Ljava/lang/String;", "mapSagaId", "Companion", "netx"})
public abstract class AbstractSagaManager
implements SagaManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Codec codec;
    @NotNull
    private final String nodeGroup;
    @NotNull
    private final String nodeName;
    @NotNull
    private final SagaIdGenerator sagaIdGenerator;
    @NotNull
    private static final String CONTEXT_TX_KEY = "sagaId";

    public AbstractSagaManager(@NotNull Codec codec, @NotNull String nodeGroup, @NotNull String nodeName, @NotNull SagaIdGenerator sagaIdGenerator) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)nodeGroup, (String)"nodeGroup");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)sagaIdGenerator, (String)"sagaIdGenerator");
        this.codec = codec;
        this.nodeGroup = nodeGroup;
        this.nodeName = nodeName;
        this.sagaIdGenerator = sagaIdGenerator;
    }

    @Override
    @NotNull
    public String startSync() {
        String string = (String)this.start().block();
        if (string == null) {
            throw new SagaException("Cannot start saga");
        }
        return string;
    }

    @Override
    @NotNull
    public final <T> String startSync(@NotNull T event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        String string = (String)this.start(event).block();
        if (string == null) {
            throw new SagaException("Cannot start saga \"" + event + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public String joinSync(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = (String)this.join(id).block();
        if (string == null) {
            throw new SagaException("Cannot join saga \"" + id + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public final <T> String joinSync(@NotNull String id, @NotNull T event) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        String string = (String)this.join(id, event).block();
        if (string == null) {
            throw new SagaException("Cannot join saga \"" + id + "\", \"" + event + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public final String existsSync(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = (String)this.exists(id).block();
        if (string == null) {
            throw new SagaException("Cannot exists saga \"" + id + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public final String commitSync(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String string = (String)this.commit(id).block();
        if (string == null) {
            throw new SagaException("Cannot commit saga \"" + id + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public <T> String commitSync(@NotNull String id, @NotNull T event) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        String string = (String)this.commit(id, event).block();
        if (string == null) {
            throw new SagaException("Cannot commit saga \"" + id + "\" \"" + event + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public final String rollbackSync(@NotNull String id, @NotNull String cause) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        String string = (String)this.rollback(id, cause).block();
        if (string == null) {
            throw new SagaException("Cannot rollback saga \"" + id + "\", \"" + cause + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public <T> String rollbackSync(@NotNull String id, @NotNull String cause, @NotNull T event) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        String string = (String)this.rollback(id, cause, event).block();
        if (string == null) {
            throw new SagaException("Cannot rollback saga \"" + id + "\", \"" + cause + "\" \"" + event + "\"");
        }
        return string;
    }

    @Override
    @NotNull
    public Mono<String> start() {
        Mono mono = LoggingSupportsKt.info(this.startSaga(null), "Start saga").contextWrite(arg_0 -> AbstractSagaManager.start$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"contextWrite(...)");
        return mono;
    }

    @Override
    @NotNull
    public final <T> Mono<String> start(@NotNull T event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Mono mono = Mono.fromCallable(() -> AbstractSagaManager.start$lambda$1(this, event)).flatMap(arg_0 -> AbstractSagaManager.start$lambda$2((Function1)new Function1<String, Mono<? extends String>>(this, event){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ T $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final Mono<? extends String> invoke(String encodedEvent) {
                return LoggingSupportsKt.info(AbstractSagaManager.access$startSaga(this.this$0, encodedEvent), "Start saga event \"" + this.$event + "\"");
            }
        }, arg_0)).contextWrite(arg_0 -> AbstractSagaManager.start$lambda$3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"contextWrite(...)");
        return mono;
    }

    private final Mono<String> startSaga(String event) {
        Mono mono = Mono.deferContextual(AbstractSagaManager::startSaga$lambda$4).flatMap(arg_0 -> AbstractSagaManager.startSaga$lambda$5((Function1)new Function1<String, Mono<? extends String>>(this, event){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final Mono<? extends String> invoke(String id) {
                Intrinsics.checkNotNull((Object)id);
                return this.this$0.publishSaga(id, new Saga(id, AbstractSagaManager.access$getNodeName$p(this.this$0), AbstractSagaManager.access$getNodeGroup$p(this.this$0), SagaState.START, null, this.$event, 16, null));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<String> join(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Mono mono = this.getAnySaga(id).map(arg_0 -> AbstractSagaManager.join$lambda$6((Function1)new Function1<SagaState, String>(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            public final String invoke(SagaState it) {
                if (it == SagaState.COMMIT) {
                    throw new AlreadyCommittedSagaException(this.$id, it.name());
                }
                return this.$id;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        Mono mono2 = LoggingSupportsKt.warningOnError(mono, "Cannot join saga").flatMap(arg_0 -> AbstractSagaManager.join$lambda$7((Function1)new Function1<String, Mono<? extends String>>(this, id){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1);
            }

            public final Mono<? extends String> invoke(String it) {
                return LoggingSupportsKt.info(AbstractSagaManager.access$joinSaga(this.this$0, this.$id, null), "Join saga id \"" + this.$id + "\"");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"flatMap(...)");
        return mono2;
    }

    @Override
    @NotNull
    public <T> Mono<String> join(@NotNull String id, @NotNull T event) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Mono mono = this.getAnySaga(id).map(arg_0 -> AbstractSagaManager.join$lambda$8((Function1)new Function1<SagaState, String>(id){
            final /* synthetic */ String $id;
            {
                this.$id = $id;
                super(1);
            }

            public final String invoke(SagaState it) {
                if (it == SagaState.COMMIT) {
                    throw new AlreadyCommittedSagaException(this.$id, it.name());
                }
                return this.$id;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        Mono mono2 = LoggingSupportsKt.warningOnError(mono, "Cannot join saga").map(arg_0 -> AbstractSagaManager.join$lambda$9((Function1)new Function1<String, String>(this, event){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ T $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final String invoke(String it) {
                return AbstractSagaManager.access$getCodec$p(this.this$0).encode(this.$event);
            }
        }, arg_0)).flatMap(arg_0 -> AbstractSagaManager.join$lambda$10((Function1)new Function1<String, Mono<? extends String>>(this, id, event){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ T $event;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$event = $event;
                super(1);
            }

            public final Mono<? extends String> invoke(String it) {
                return LoggingSupportsKt.info(AbstractSagaManager.access$joinSaga(this.this$0, this.$id, it), "Join saga id \"" + this.$id + "\", event \"" + this.$event + "\"");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"flatMap(...)");
        return mono2;
    }

    private final Mono<String> joinSaga(String id, String event) {
        return this.publishSaga(id, new Saga(id, this.nodeName, this.nodeGroup, SagaState.JOIN, null, event, 16, null));
    }

    @Override
    @NotNull
    public final Mono<String> rollback(@NotNull String id, @NotNull String cause) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Mono mono = LoggingSupportsKt.infoOnError(this.exists(id), "Cannot rollback saga cause, saga \"" + id + "\" is not exists").flatMap(arg_0 -> AbstractSagaManager.rollback$lambda$11((Function1)new Function1<String, Mono<? extends String>>(this, id, cause){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ String $cause;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$cause = $cause;
                super(1);
            }

            public final Mono<? extends String> invoke(String it) {
                return AbstractSagaManager.access$rollbackSaga(this.this$0, this.$id, this.$cause, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        Mono mono2 = LoggingSupportsKt.info(mono, "Rollback saga \"" + id + "\"").contextWrite(arg_0 -> AbstractSagaManager.rollback$lambda$12(id, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"contextWrite(...)");
        return mono2;
    }

    @Override
    @NotNull
    public <T> Mono<String> rollback(@NotNull String id, @NotNull String cause, @NotNull T event) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Mono mono = LoggingSupportsKt.infoOnError(this.exists(id), "Cannot rollback saga cause, saga \"" + id + "\" is not exists").map(arg_0 -> AbstractSagaManager.rollback$lambda$13((Function1)new Function1<String, String>(this, event){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ T $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final String invoke(String it) {
                return AbstractSagaManager.access$getCodec$p(this.this$0).encode(this.$event);
            }
        }, arg_0)).flatMap(arg_0 -> AbstractSagaManager.rollback$lambda$14((Function1)new Function1<String, Mono<? extends String>>(this, id, cause){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $id;
            final /* synthetic */ String $cause;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$cause = $cause;
                super(1);
            }

            public final Mono<? extends String> invoke(String encodedEvent) {
                return AbstractSagaManager.access$rollbackSaga(this.this$0, this.$id, this.$cause, encodedEvent);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        Mono mono2 = LoggingSupportsKt.info(mono, "Rollback saga \"" + id + "\"").contextWrite(arg_0 -> AbstractSagaManager.rollback$lambda$15(id, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"contextWrite(...)");
        return mono2;
    }

    private final Mono<String> rollbackSaga(String id, String cause, String event) {
        return this.publishSaga(id, new Saga(id, this.nodeName, this.nodeGroup, SagaState.ROLLBACK, cause, event));
    }

    @Override
    @NotNull
    public final Mono<String> commit(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Mono mono = LoggingSupportsKt.infoOnError(this.exists(id), "Cannot commit saga cause, saga \"" + id + "\" is not exists").flatMap(arg_0 -> AbstractSagaManager.commit$lambda$16((Function1)new Function1<String, Mono<? extends String>>(this, id){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1);
            }

            public final Mono<? extends String> invoke(String it) {
                return AbstractSagaManager.access$commitSaga(this.this$0, this.$id, null);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        Mono mono2 = LoggingSupportsKt.info(mono, "Commit saga \"" + id + "\"").contextWrite(arg_0 -> AbstractSagaManager.commit$lambda$17(id, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"contextWrite(...)");
        return mono2;
    }

    @Override
    @NotNull
    public <T> Mono<String> commit(@NotNull String id, @NotNull T event) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Mono mono = LoggingSupportsKt.infoOnError(this.exists(id), "Cannot commit saga cause, saga \"" + id + "\" is not exists").map(arg_0 -> AbstractSagaManager.commit$lambda$18((Function1)new Function1<String, String>(this, event){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ T $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(1);
            }

            public final String invoke(String it) {
                return AbstractSagaManager.access$getCodec$p(this.this$0).encode(this.$event);
            }
        }, arg_0)).flatMap(arg_0 -> AbstractSagaManager.commit$lambda$19((Function1)new Function1<String, Mono<? extends String>>(this, id){
            final /* synthetic */ AbstractSagaManager this$0;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                super(1);
            }

            public final Mono<? extends String> invoke(String encodedEvent) {
                return AbstractSagaManager.access$commitSaga(this.this$0, this.$id, encodedEvent);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        Mono mono2 = LoggingSupportsKt.info(mono, "Commit saga \"" + id + "\"").contextWrite(arg_0 -> AbstractSagaManager.commit$lambda$20(id, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"contextWrite(...)");
        return mono2;
    }

    private final Mono<String> commitSaga(String id, String event) {
        return this.publishSaga(id, new Saga(id, this.nodeName, this.nodeGroup, SagaState.COMMIT, null, event, 16, null));
    }

    @Override
    @NotNull
    public final Mono<String> exists(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Mono mono = this.mapSagaId(LoggingSupportsKt.infoOnError(this.getAnySaga(id), "There is no saga corresponding to id \"" + id + "\"")).contextWrite(arg_0 -> AbstractSagaManager.exists$lambda$21(id, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"contextWrite(...)");
        return mono;
    }

    @NotNull
    protected abstract Mono<SagaState> getAnySaga(@NotNull String var1);

    private final Mono<String> mapSagaId(Mono<?> $this$mapSagaId) {
        Mono mono = $this$mapSagaId.flatMap(AbstractSagaManager::mapSagaId$lambda$23);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @NotNull
    protected abstract Mono<String> publishSaga(@NotNull String var1, @NotNull Saga var2);

    private static final Context start$lambda$0(AbstractSagaManager this$0, Context it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return it.put((Object)CONTEXT_TX_KEY, (Object)this$0.sagaIdGenerator.generate());
    }

    private static final String start$lambda$1(AbstractSagaManager this$0, Object $event) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        return this$0.codec.encode($event);
    }

    private static final Mono start$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Context start$lambda$3(AbstractSagaManager this$0, Context it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return it.put((Object)CONTEXT_TX_KEY, (Object)this$0.sagaIdGenerator.generate());
    }

    private static final Mono startSaga$lambda$4(ContextView it) {
        return Mono.just((Object)it.get((Object)CONTEXT_TX_KEY));
    }

    private static final Mono startSaga$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final String join$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Mono join$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final String join$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String join$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Mono join$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono rollback$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Context rollback$lambda$12(String $id, Context it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return it.put((Object)CONTEXT_TX_KEY, (Object)$id);
    }

    private static final String rollback$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Mono rollback$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Context rollback$lambda$15(String $id, Context it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return it.put((Object)CONTEXT_TX_KEY, (Object)$id);
    }

    private static final Mono commit$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Context commit$lambda$17(String $id, Context it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return it.put((Object)CONTEXT_TX_KEY, (Object)$id);
    }

    private static final String commit$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final Mono commit$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Context commit$lambda$20(String $id, Context it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return it.put((Object)CONTEXT_TX_KEY, (Object)$id);
    }

    private static final Context exists$lambda$21(String $id, Context it) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return it.put((Object)CONTEXT_TX_KEY, (Object)$id);
    }

    private static final Mono mapSagaId$lambda$23$lambda$22(ContextView it) {
        return Mono.just((Object)it.get((Object)CONTEXT_TX_KEY));
    }

    private static final Mono mapSagaId$lambda$23(Object it) {
        return Mono.deferContextual(AbstractSagaManager::mapSagaId$lambda$23$lambda$22);
    }

    public static final /* synthetic */ Mono access$startSaga(AbstractSagaManager $this, String event) {
        return $this.startSaga(event);
    }

    public static final /* synthetic */ String access$getNodeName$p(AbstractSagaManager $this) {
        return $this.nodeName;
    }

    public static final /* synthetic */ String access$getNodeGroup$p(AbstractSagaManager $this) {
        return $this.nodeGroup;
    }

    public static final /* synthetic */ Mono access$joinSaga(AbstractSagaManager $this, String id, String event) {
        return $this.joinSaga(id, event);
    }

    public static final /* synthetic */ Codec access$getCodec$p(AbstractSagaManager $this) {
        return $this.codec;
    }

    public static final /* synthetic */ Mono access$rollbackSaga(AbstractSagaManager $this, String id, String cause, String event) {
        return $this.rollbackSaga(id, cause, event);
    }

    public static final /* synthetic */ Mono access$commitSaga(AbstractSagaManager $this, String id, String event) {
        return $this.commitSaga(id, event);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/rooftop/netx/engine/AbstractSagaManager$Companion;", "", "()V", "CONTEXT_TX_KEY", "", "netx"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

